/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public final class TaskAttribute {
    public static final String ADD_SELF_CC = "task.common.addselfcc";
    public static final String ATTACHMENT_AUTHOR = "task.common.attachment.author";
    public static final String ATTACHMENT_CONTENT_TYPE = "task.common.attachment.ctype";
    public static final String ATTACHMENT_DATE = "task.common.attachment.date";
    public static final String ATTACHMENT_DESCRIPTION = "task.common.attachment.description";
    public static final String ATTACHMENT_FILENAME = "filename";
    public static final String ATTACHMENT_ID = "task.common.attachment.id";
    public static final String ATTACHMENT_IS_DEPRECATED = "task.common.attachment.deprecated";
    public static final String ATTACHMENT_IS_PATCH = "task.common.attachment.patch";
    public static final String ATTACHMENT_REPLACE_EXISTING = "task.common.attachment.replaceExisting";
    public static final String ATTACHMENT_SIZE = "task.common.attachment.size";
    public static final String ATTACHMENT_URL = "task.common.attachment.url";
    public static final String COMMENT_ATTACHMENT_ID = "task.common.comment.attachment.id";
    public static final String COMMENT_AUTHOR = "task.common.comment.author";
    @Deprecated
    public static final String COMMENT_AUTHOR_NAME = "task.common.comment.author.name";
    public static final String COMMENT_DATE = "task.common.comment.date";
    public static final String COMMENT_HAS_ATTACHMENT = "task.common.comment.attachment";
    public static final String COMMENT_NEW = "task.common.comment.new";
    public static final String COMMENT_NUMBER = "task.common.comment.number";
    public static final String COMMENT_TEXT = "task.common.comment.text";
    public static final String COMMENT_URL = "task.common.comment.url";
    public static final String COMPONENT = "task.common.component";
    public static final String DATE_COMPLETION = "task.common.date.completed";
    public static final String DATE_CREATION = "task.common.date.created";
    public static final String DATE_DUE = "task.common.date.due";
    public static final String DATE_MODIFICATION = "task.common.date.modified";
    public static final String DESCRIPTION = "task.common.description";
    public static final String KEYWORDS = "task.common.keywords";
    public static final String KIND_DEFAULT = "task.common.kind.default";
    public static final String KIND_OPERATION = "task.common.kind.operation";
    public static final String KIND_PEOPLE = "task.common.kind.people";
    public static final String META_ASSOCIATED_ATTRIBUTE_ID = "task.meta.associated.attribute";
    public static final String META_ATTRIBUTE_KIND = "task.meta.attributeKind";
    public static final String META_ATTRIBUTE_TYPE = "task.meta.type";
    public static final String META_DEFAULT_OPTION = "task.meta.defaultOption";
    public static final String META_LABEL = "task.meta.label";
    public static final String META_READ_ONLY = "task.meta.readOnly";
    public static final String COMMENT_ISPRIVATE = "task.common.comment.isprivate";
    public static final String META_DISABLED = "task.meta.disabled";
    public static final String META_DESCRIPTION = "task.meta.description";
    public static final String META_INDEXED_AS_CONTENT = "task.meta.index.content";
    public static final String NEW_ATTACHMENT = "task.common.new.attachment";
    public static final String OPERATION = "task.common.operation";
    public static final String PERSON_NAME = "task.common.person.name";
    public static final String PREFIX_ATTACHMENT = "task.common.attachment-";
    public static final String PREFIX_COMMENT = "task.common.comment-";
    public static final String PREFIX_OPERATION = "task.common.operation-";
    public static final String PRIORITY = "task.common.priority";
    public static final String PRODUCT = "task.common.product";
    public static final String RESOLUTION = "task.common.resolution";
    public static final String STATUS = "task.common.status";
    public static final String SUMMARY = "task.common.summary";
    public static final String TASK_KEY = "task.common.key";
    public static final String TASK_KIND = "task.common.kind";
    public static final String RANK = "task.common.rank";
    public static final String TASK_URL = "task.common.url";
    public static final String TYPE_ATTACHMENT = "attachment";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_COMMENT = "comment";
    public static final String TYPE_CONTAINER = "container";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_DATETIME = "dateTime";
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_LONG_RICH_TEXT = "longRichText";
    public static final String TYPE_LONG_TEXT = "longText";
    public static final String TYPE_MULTI_SELECT = "multiSelect";
    public static final String TYPE_OPERATION = "operation";
    public static final String TYPE_PERSON = "person";
    public static final String TYPE_SHORT_RICH_TEXT = "shortRichText";
    public static final String TYPE_SHORT_TEXT = "shortText";
    public static final String TYPE_SINGLE_SELECT = "singleSelect";
    public static final String TYPE_TASK_DEPENDENCY = "taskDepenedency";
    public static final String TYPE_URL = "url";
    public static final String TYPE_DOUBLE = "double";
    public static final String USER_ASSIGNED = "task.common.user.assigned";
    @Deprecated
    public static final String USER_ASSIGNED_NAME = "task.common.user.assigned.name";
    public static final String USER_CC = "task.common.user.cc";
    public static final String USER_REPORTER = "task.common.user.reporter";
    @Deprecated
    public static final String USER_REPORTER_NAME = "task.common.user.reporter.name";
    public static final String SEVERITY = "task.common.severity";
    public static final String VERSION = "task.common.version";
    private Map<String, TaskAttribute> attributeById;
    private final String attributeId;
    private Map<String, String> metaData;
    private Map<String, String> optionByKey;
    private final TaskAttribute parentAttribute;
    private final TaskData taskData;
    private final List<String> values;

    public TaskAttribute(TaskAttribute parentAttribute, String attributeId) {
        Assert.isNotNull((Object)parentAttribute);
        Assert.isNotNull((Object)attributeId);
        this.parentAttribute = parentAttribute;
        this.attributeId = attributeId.intern();
        this.taskData = parentAttribute.getTaskData();
        this.values = new ArrayList<String>(1);
        parentAttribute.add(this);
    }

    TaskAttribute(TaskData taskData) {
        Assert.isNotNull((Object)taskData);
        this.parentAttribute = null;
        this.taskData = taskData;
        this.attributeId = "root";
        this.values = new ArrayList<String>(1);
    }

    private void add(TaskAttribute attribute) {
        if (this.attributeById == null) {
            this.attributeById = new LinkedHashMap<String, TaskAttribute>();
        }
        this.attributeById.put(attribute.getId(), attribute);
    }

    public void addValue(String value) {
        Assert.isNotNull((Object)value);
        this.values.add(value);
    }

    public void clearAttributes() {
        this.attributeById = null;
    }

    void clearMetaDataMap() {
        this.metaData = null;
    }

    public void clearOptions() {
        this.optionByKey = null;
    }

    public void clearValues() {
        this.values.clear();
    }

    public TaskAttribute createAttribute(String attributeId) {
        return new TaskAttribute(this, attributeId);
    }

    public void deepAddCopy(TaskAttribute source) {
        TaskAttribute target = this.createAttribute(source.getId());
        target.values.addAll(source.values);
        if (source.metaData != null) {
            target.metaData = new LinkedHashMap<String, String>(source.metaData);
        }
        if (source.optionByKey != null) {
            target.optionByKey = new LinkedHashMap<String, String>(source.optionByKey);
        }
        if (source.attributeById != null) {
            for (TaskAttribute child : source.attributeById.values()) {
                target.deepAddCopy(child);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskAttribute other = (TaskAttribute)obj;
        return !(this.attributeId == null ? other.attributeId != null : !this.attributeId.equals(other.attributeId));
    }

    public TaskAttribute getAttribute(String attributeId) {
        Assert.isNotNull((Object)attributeId);
        return this.attributeById != null ? this.attributeById.get(attributeId) : null;
    }

    public Map<String, TaskAttribute> getAttributes() {
        if (this.attributeById != null) {
            return Collections.unmodifiableMap(this.attributeById);
        }
        return Collections.emptyMap();
    }

    public String getId() {
        return this.attributeId;
    }

    public TaskAttribute getMappedAttribute(String attributeId) {
        Assert.isNotNull((Object)attributeId);
        return this.attributeById != null ? this.attributeById.get(this.getTaskData().getAttributeMapper().mapToRepositoryKey(this, attributeId)) : null;
    }

    public TaskAttribute getMappedAttribute(String[] path) {
        TaskAttribute attribute = this;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if ((attribute = attribute.getMappedAttribute(id)) == null) break;
            ++n2;
        }
        return attribute;
    }

    String getMetaDatum(String key) {
        return this.metaData != null ? this.metaData.get(key) : null;
    }

    Map<String, String> getMetaDataMap() {
        if (this.metaData != null) {
            return Collections.unmodifiableMap(this.metaData);
        }
        return Collections.emptyMap();
    }

    public String getOption(String key) {
        return this.optionByKey != null ? this.optionByKey.get(key) : null;
    }

    public Map<String, String> getOptions() {
        if (this.optionByKey != null) {
            return Collections.unmodifiableMap(this.optionByKey);
        }
        return Collections.emptyMap();
    }

    public TaskAttribute getParentAttribute() {
        return this.parentAttribute;
    }

    public String[] getPath() {
        ArrayList<String> path = new ArrayList<String>();
        TaskAttribute attribute = this;
        while (attribute.getParentAttribute() != null) {
            path.add(attribute.getId());
            attribute = attribute.getParentAttribute();
        }
        Collections.reverse(path);
        return path.toArray(new String[0]);
    }

    public TaskAttributeMetaData getMetaData() {
        return new TaskAttributeMetaData(this);
    }

    public TaskData getTaskData() {
        return this.taskData;
    }

    public String getValue() {
        if (this.values.size() > 0) {
            return this.values.get(0);
        }
        return "";
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public boolean hasValue() {
        return this.values.size() > 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.attributeId == null ? 0 : this.attributeId.hashCode());
        return result;
    }

    void putMetaDatum(String key, String value) {
        Assert.isNotNull((Object)key);
        Assert.isNotNull((Object)value);
        if (this.metaData == null) {
            this.metaData = new LinkedHashMap<String, String>();
        }
        this.metaData.put(key.intern(), value);
    }

    public void putOption(String key, String value) {
        Assert.isNotNull((Object)key);
        Assert.isNotNull((Object)value);
        if (this.optionByKey == null) {
            this.optionByKey = new LinkedHashMap<String, String>();
        }
        this.optionByKey.put(key.intern(), value);
    }

    public void removeAttribute(String attributeId) {
        if (this.attributeById != null) {
            this.attributeById.remove(attributeId);
        }
    }

    void removeMetaDatum(String metaDataId) {
        if (this.metaData != null) {
            this.metaData.remove(metaDataId);
        }
    }

    public void removeValue(String value) {
        this.values.remove(value);
    }

    public void setValue(String value) {
        Assert.isNotNull((Object)value);
        if (this.values.size() > 0) {
            this.values.clear();
        }
        this.values.add(value);
    }

    public void setValues(List<String> values) {
        Assert.isNotNull(values);
        Assert.isTrue((!values.contains(null) ? 1 : 0) != 0);
        this.values.clear();
        this.values.addAll(values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, "");
        return sb.toString();
    }

    private void toString(StringBuilder sb, String prefix) {
        sb.append(prefix);
        sb.append("TaskAttribute[id=");
        sb.append(this.attributeId);
        sb.append(",values=");
        sb.append(this.values);
        sb.append(",options=");
        sb.append(this.optionByKey);
        sb.append(",metaData=");
        sb.append(this.metaData);
        sb.append("]");
        if (this.attributeById != null) {
            for (TaskAttribute child : this.attributeById.values()) {
                sb.append("\n");
                child.toString(sb, String.valueOf(prefix) + " ");
            }
        }
    }

    public TaskAttribute createMappedAttribute(String attributeId) {
        Assert.isNotNull((Object)attributeId);
        String mappedAttributeId = this.getTaskData().getAttributeMapper().mapToRepositoryKey(this, attributeId);
        Assert.isNotNull((Object)mappedAttributeId);
        return new TaskAttribute(this, mappedAttributeId);
    }
}

