/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.model;

import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelEvent;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSession;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSession;
import org.eclipse.swt.graphics.Image;

public class UiModelEvent
implements IUiModelElement {
    private IUiModelElement parent = null;
    private OpModelEvent event;
    private UiModelSession[] sessions;

    public UiModelEvent(OpModelEvent event) {
        if (event != null) {
            this.event = event;
            this.refreshModel();
        }
    }

    private void refreshModel() {
        OpModelSession[] dataModelSessions = this.event.getSessions();
        this.sessions = new UiModelSession[dataModelSessions.length];
        int i = 0;
        while (i < dataModelSessions.length) {
            this.sessions[i] = new UiModelSession(this, dataModelSessions[i]);
            ++i;
        }
    }

    public String toString() {
        return this.event == null ? "" : this.event.getName();
    }

    public String getLabelText() {
        return this.toString();
    }

    public IUiModelElement[] getChildren() {
        return this.sessions;
    }

    public boolean hasChildren() {
        return this.sessions != null && this.sessions.length != 0;
    }

    public IUiModelElement getParent() {
        return this.parent;
    }

    public Image getLabelImage() {
        return OprofileUiPlugin.getImageDescriptor("icons/event.gif").createImage();
    }
}

