/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.client.EventSettingsBuilder;
import com.oracle.jrockit.jfr.client.FlightRecorderClient;
import com.oracle.jrockit.jfr.client.FlightRecordingClient;
import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.openmbean.OpenDataException;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.JFRImpl;
import oracle.jrockit.jfr.JFRStats;
import oracle.jrockit.jfr.NativeJFRStats;
import oracle.jrockit.jfr.NativeProducerDescriptor;
import oracle.jrockit.jfr.Options;
import oracle.jrockit.jfr.Process;
import oracle.jrockit.jfr.ProducerDescriptor;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.RepositoryChunk;
import oracle.jrockit.jfr.StringConstantPool;
import oracle.jrockit.jfr.Timing;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.settings.EventSetting;

@Deprecated
public final class VMJFR
extends JFRImpl {
    private static final int addressSize;
    private final NativeProducerDescriptor vm;
    private final NativeJFRStats jfrStats;
    static final int PREV = 0;
    static final int NEXT;
    static final int START;
    static final int TOP;
    static final int POS;
    static final int END;
    static final int USED;
    static final int RESERVED;
    static final int DATA;
    private final ThreadLocal<ThreadBuffer> bufferLocal = new ThreadLocal<ThreadBuffer>(){

        @Override
        protected ThreadBuffer initialValue() {
            return new ThreadBuffer(VMJFR.this.buffer());
        }
    };

    VMJFR() {
        super(VMJFR.options());
        assert (VMJFR.isEnabled());
        ByteBuffer byteBuffer = this.init(Locale.getDefault().toString(), TimeZone.getDefault().getRawOffset(), this.getRepository().getPath().getPath());
        this.jfrStats = new NativeJFRStats(byteBuffer.order(ByteOrder.nativeOrder()));
        try {
            this.vm = new NativeProducerDescriptor(1, this);
        }
        catch (Exception exception) {
            throw (Error)new InternalError().initCause(exception);
        }
        this.addProducer(this.vm, this.vm.controls());
        this.startDefaultRecording();
    }

    private static native boolean isEnabled();

    private static native Options options();

    private native ByteBuffer init(String var1, int var2, String var3);

    @Override
    public boolean isNativeImplementation() {
        return true;
    }

    @Override
    public ByteBuffer getThreadBuffer(int n) {
        return this.bufferLocal.get().ensure(n);
    }

    @Override
    public void releaseThreadBuffer(ByteBuffer byteBuffer, boolean bl) {
        this.bufferLocal.get().finish(byteBuffer, bl);
    }

    private native void addConstPool(ByteBuffer var1, int var2, boolean var3);

    private native void removeConstPool(int var1);

    private native boolean storeConstPool(int var1);

    @Override
    protected void addConstpool(StringConstantPool stringConstantPool) {
        this.addConstPool(stringConstantPool.getConstantData(), stringConstantPool.getConstantIndex(), stringConstantPool.emptyOnRotation());
    }

    @Override
    protected void removeConstpool(StringConstantPool stringConstantPool) {
        this.removeConstPool(stringConstantPool.getConstantIndex());
    }

    @Override
    protected boolean storeConstpool(StringConstantPool stringConstantPool) {
        return this.storeConstPool(stringConstantPool.getConstantIndex());
    }

    @Override
    public native long classID(Class<?> var1);

    @Override
    public long counterTime() {
        return Timing.counterTime();
    }

    @Override
    public long nanoToCounter(long l) {
        return Timing.nanoToCounter(l);
    }

    @Override
    public native long stackTraceID(int var1);

    @Override
    public native int threadID();

    @Override
    public int getpid() {
        return Process.current.pid();
    }

    @Override
    public JFRStats getJFRStats() {
        return this.jfrStats;
    }

    @Override
    protected native void rotate();

    @Override
    protected native void shutdown();

    @Override
    protected native void start(boolean var1);

    @Override
    protected native void stop();

    private native ByteBuffer buffer();

    private native void flush();

    private native void write(byte[] var1, int var2, int var3);

    private native void add(int var1, byte[] var2, int var3, int var4);

    private native void remove(int var1);

    native void setThreshold(int var1, long var2);

    native void setPeriod(int var1, long var2);

    native long getPeriod(int var1);

    native int descriptors(int var1, ByteBuffer[] var2);

    @Override
    protected void add(ProducerDescriptor producerDescriptor) {
        if (producerDescriptor == this.vm) {
            return;
        }
        ByteBuffer byteBuffer = producerDescriptor.getBinaryDescriptor();
        this.add(producerDescriptor.getId(), byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
    }

    @Override
    protected void remove(ProducerDescriptor producerDescriptor) {
        if (producerDescriptor == this.vm) {
            return;
        }
        this.remove(producerDescriptor.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishChunk(String string, long l, long l2, boolean bl) throws IOException {
        RepositoryChunk repositoryChunk = new RepositoryChunk(this.getRepository(), this.logger, new File(string));
        try {
            repositoryChunk.finish(l, l2);
            this.addChunk(repositoryChunk);
        }
        finally {
            repositoryChunk.release();
            repositoryChunk = null;
            this.chunkDone();
        }
    }

    private long startRecording(String string, String[] stringArray, boolean bl, long l, long l2, String string2, boolean bl2, long l3, long l4) throws Throwable {
        Object object;
        FlightRecorderClient flightRecorderClient = new FlightRecorderClient();
        if (bl) {
            flightRecorderClient.enableDefaultRecording();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.loadDefaultSettings(this.getEventSettings(), stringArray[i]);
                }
            }
            return 0L;
        }
        if (string2 != null && string == null) {
            object = new File(string2);
            string = ((File)object).getName();
        }
        object = flightRecorderClient.createRecordingObject(string);
        try {
            if (stringArray != null) {
                EventSettingsBuilder eventSettingsBuilder = new EventSettingsBuilder();
                for (int i = 0; i < stringArray.length; ++i) {
                    eventSettingsBuilder.addSettings(this.findEventDefaultSet(stringArray[i]));
                }
                ((FlightRecordingClient)object).addEventDefaults(eventSettingsBuilder.createDefaultSettings());
            }
            if (l2 != 0L) {
                l2 = Math.max(1000L, TimeUnit.MILLISECONDS.convert(l2, TimeUnit.NANOSECONDS));
            }
            if (l != 0L) {
                l = TimeUnit.MILLISECONDS.convert(l, TimeUnit.NANOSECONDS);
            }
            if (l3 != 0L) {
                l3 = TimeUnit.MILLISECONDS.convert(l3, TimeUnit.NANOSECONDS);
            }
            ((FlightRecordingClient)object).setDuration(l2);
            ((FlightRecordingClient)object).setDestination(string2);
            ((FlightRecordingClient)object).setDestinationCompressed(bl2);
            ((FlightRecordingClient)object).setMaxAge(l3);
            ((FlightRecordingClient)object).setMaxSize(l4);
            if (l != 0L) {
                ((FlightRecordingClient)object).setStartTime(new Date(System.currentTimeMillis() + l));
            } else {
                ((FlightRecordingClient)object).start();
            }
        }
        catch (Throwable throwable) {
            ((FlightRecordingClient)object).close();
            throw throwable;
        }
        return ((FlightRecordingClient)object).getId();
    }

    private FlightRecordingClient findRecording(String string, long l) throws InstanceNotFoundException, NullPointerException, IOException, OpenDataException, NoSuchRecordingException {
        FlightRecorderClient flightRecorderClient = new FlightRecorderClient();
        List<FlightRecordingClient> list = flightRecorderClient.getRecordingObjects();
        for (FlightRecordingClient flightRecordingClient : list) {
            if ((l != -1L || string == null || !string.equals(flightRecordingClient.getName())) && flightRecordingClient.getId() != l) continue;
            return flightRecordingClient;
        }
        throw new NoSuchRecordingException(string + ":" + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRecording(String string, long l, boolean bl, String string2, boolean bl2) throws NoSuchRecordingException, IOException, OpenDataException, InstanceNotFoundException, NullPointerException {
        try (FlightRecordingClient flightRecordingClient = this.findRecording(string, l);){
            if (bl) {
                flightRecordingClient.setDestination(null);
            }
            flightRecordingClient.setStartTime(null);
            flightRecordingClient.stop();
            if (string2 != null) {
                flightRecordingClient.copyTo(string2, bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpRecording(String string, long l, String string2, boolean bl) throws InstanceNotFoundException, NullPointerException, IOException, OpenDataException, NoSuchRecordingException {
        if (string2 == null) {
            throw new NullPointerException("copyTo");
        }
        FlightRecordingClient flightRecordingClient = this.findRecording(string, l);
        try (FlightRecordingClient flightRecordingClient2 = flightRecordingClient.cloneRecordingObject(string + "_copy_" + System.nanoTime(), true);){
            flightRecordingClient2.copyTo(string2, bl);
        }
    }

    private String checkRecording(String string, long l, boolean bl) throws NoSuchRecordingException, InstanceNotFoundException, NullPointerException, OpenDataException, IOException {
        if (l != -1L || string != null) {
            FlightRecordingClient flightRecordingClient = this.findRecording(string, l);
            return this.printRecording(this.getRecording(flightRecordingClient.getId()), bl);
        }
        StringBuilder stringBuilder = new StringBuilder();
        FlightRecorderClient flightRecorderClient = new FlightRecorderClient();
        for (FlightRecordingClient flightRecordingClient : flightRecorderClient.getRecordingObjects()) {
            try {
                stringBuilder.append(this.printRecording(this.getRecording(flightRecordingClient.getId()), bl));
                stringBuilder.append('\n');
            }
            catch (NoSuchRecordingException noSuchRecordingException) {}
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String printRecording(Recording recording, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Recording : id=" + recording.getId() + " name=\"" + recording.getName() + "\" duration=" + recording.getDuration(TimeUnit.SECONDS) + "s");
        String string = recording.getDestination();
        if (string != null) {
            stringBuilder.append(" dest=\"" + string + "\" compress=" + recording.isDestinationCompressed());
        }
        if (!recording.isStarted()) {
            stringBuilder.append(" (unstarted)");
        }
        if (recording.isRunning()) {
            stringBuilder.append(" (running)");
        }
        if (recording.isStopped()) {
            stringBuilder.append(" (stopped)");
        }
        if (!bl) {
            return stringBuilder.toString();
        }
        stringBuilder.append('\n');
        Collection<EventDescriptor> collection = this.getEvents();
        Collection<EventSetting> collection2 = recording.getEventSettings().getSettings();
        TreeMap<String, EventDescriptor> treeMap = new TreeMap<String, EventDescriptor>();
        for (EventDescriptor object2 : collection) {
            treeMap.put(object2.getURI().toString(), object2);
        }
        HashMap hashMap = new HashMap();
        for (EventSetting eventSetting : collection2) {
            hashMap.put(eventSetting.getId(), eventSetting);
        }
        Object var9_11 = null;
        for (Map.Entry entry : treeMap.entrySet()) {
            EventSetting eventSetting;
            void var9_12;
            String string2 = (String)entry.getKey();
            EventDescriptor eventDescriptor = (EventDescriptor)entry.getValue();
            if (var9_12 == null || !string2.startsWith((String)var9_12)) {
                String string3 = string2.substring(0, string2.length() - eventDescriptor.getPath().length());
                stringBuilder.append(string3).append(":\n");
            }
            if ((eventSetting = (EventSetting)hashMap.get(eventDescriptor.getId())) == null) continue;
            stringBuilder.append('\t').append(eventDescriptor.getPath()).append(" : ");
            stringBuilder.append(eventSetting.isEnabled() ? "enabled" : "disabled");
            if (eventDescriptor.hasStackTrace() && eventSetting.isStacktraceEnabled()) {
                stringBuilder.append(" stacktrace");
            }
            if (eventDescriptor.isTimed()) {
                stringBuilder.append(" threshold=").append(eventSetting.getThreshold());
            }
            if (eventDescriptor.isRequestable()) {
                stringBuilder.append(" period=").append(eventSetting.getPeriod());
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    static JFR create() {
        if (VMJFR.isEnabled()) {
            return new VMJFR();
        }
        return null;
    }

    static {
        System.loadLibrary("jfr");
        addressSize = Integer.parseInt(System.getProperty("sun.arch.data.model")) / 8;
        NEXT = 1 * addressSize;
        START = 2 * addressSize;
        TOP = 3 * addressSize;
        POS = 4 * addressSize;
        END = 5 * addressSize;
        USED = 6 * addressSize;
        RESERVED = USED + 4;
        DATA = RESERVED + 4;
    }

    private final class ThreadBuffer {
        private final ByteBuffer base;
        private final ByteBuffer buffer;

        public ThreadBuffer(ByteBuffer byteBuffer) {
            this.base = byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.position(DATA);
            this.buffer = byteBuffer.slice();
        }

        public void acquire() {
            this.base.put(USED, (byte)1);
        }

        public void release() {
            this.base.put(USED, (byte)0);
        }

        public void finish(ByteBuffer byteBuffer, boolean bl) {
            if (byteBuffer != this.buffer && bl) {
                byteBuffer.flip();
                VMJFR.this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
                return;
            }
            if (bl) {
                int n = this.buffer.position();
                if (addressSize == 8) {
                    long l = this.base.getLong(START);
                    this.base.putLong(POS, l + (long)n);
                }
                if (addressSize == 4) {
                    int n2 = this.base.getInt(START);
                    this.base.putInt(POS, n2 + n);
                }
            }
            this.release();
        }

        public ByteBuffer ensure(int n) {
            int n2;
            assert (n != 0);
            if (this.buffer.capacity() < n) {
                return ByteBuffer.allocate(n + 512);
            }
            while (true) {
                this.acquire();
                if (addressSize == 8) {
                    long l;
                    long l2 = this.base.getLong(END);
                    if (l2 - (l = this.base.getLong(POS)) < (long)n) {
                        this.release();
                        VMJFR.this.flush();
                        continue;
                    }
                    int n3 = (int)(l - this.base.getLong(START));
                    this.buffer.position(n3);
                    return this.buffer;
                }
                if (addressSize != 4) continue;
                int n4 = this.base.getInt(END);
                if (n4 - (n2 = this.base.getInt(POS)) >= n) break;
                this.release();
                VMJFR.this.flush();
            }
            int n5 = n2 - this.base.getInt(START);
            this.buffer.position(n5);
            return this.buffer;
        }
    }
}

