/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.dialogs;

import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.DiagramToolTip;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.NGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDWidget;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.dialogs.SDPrintDialog;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.Messages;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SDPrintDialogUI {
    private Button fSetHPagesNumber;
    private Button fSetVPagesNumber;
    private Button fUseCurrentZoom;
    private Button fAllPages;
    private Button fCurrentPage;
    private Button fPageList;
    private Button fPageRange;
    private Text fFromPage;
    private Text fToPage;
    private SDWidget fSdView;
    private Text fHorPagesNum;
    private Text fVertPagesNum;
    private Text fTotalPages;
    private ModifyListener fModifyListener;
    private SelectionListener fSelectionListener;
    private LocalSD fOverviewCanvas;
    private int fNbPages = 0;
    private int fPageNum = -1;
    private int fFirstPage = -1;
    private int[] fPagesList;
    private float fStepX;
    private float fStepY;
    private float sTX;
    private float sTY;
    private int fFrom;
    private int fTo;
    private boolean fMultiSelection = false;
    private boolean fAreaSelection = false;
    private boolean fPrintAll;
    private boolean fPrintCurrent;
    private boolean fPrintSelection;
    private boolean fPrintRange;
    private int fNbRows;
    private int fNbLines;
    private float fZoomFactor;
    private PrinterData fPrinterData;
    private DiagramToolTip fToolTip = null;
    private Label fCurrentSelection;
    private Shell fShell;
    private Button fPrinterDialog;
    private boolean fShowPrintButton;
    private int fTest = 3;
    private WizardPage fParentWizardPage = null;
    private SDPrintDialog fParentDialog = null;

    public SDPrintDialogUI(Shell shell, SDWidget sdWidget) {
        this(shell, sdWidget, false);
    }

    public SDPrintDialogUI(Shell shell, SDWidget sdWidget, boolean showPrintBtn) {
        this.fShell = shell;
        this.fSdView = sdWidget;
        this.fShowPrintButton = showPrintBtn;
        this.fPrinterData = Printer.getDefaultPrinterData();
        if (this.fPrinterData != null) {
            this.fPrinterData.scope = 2;
        }
        this.fPagesList = new int[0];
        this.fSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SDPrintDialogUI.this.fUseCurrentZoom.getSelection()) {
                    SDPrintDialogUI.this.fHorPagesNum.setEnabled(false);
                    SDPrintDialogUI.this.fVertPagesNum.setEnabled(false);
                }
                if (SDPrintDialogUI.this.fSetHPagesNumber.getSelection()) {
                    SDPrintDialogUI.this.fHorPagesNum.setEnabled(true);
                    SDPrintDialogUI.this.fVertPagesNum.setEnabled(false);
                    if (SDPrintDialogUI.this.fCurrentPage.getSelection()) {
                        SDPrintDialogUI.this.fCurrentPage.setSelection(false);
                        SDPrintDialogUI.this.fAllPages.setSelection(true);
                    }
                    if ("".equals(SDPrintDialogUI.this.fHorPagesNum.getText())) {
                        SDPrintDialogUI.this.fHorPagesNum.setText("1");
                    }
                }
                if (SDPrintDialogUI.this.fSetVPagesNumber.getSelection()) {
                    SDPrintDialogUI.this.fHorPagesNum.setEnabled(false);
                    SDPrintDialogUI.this.fVertPagesNum.setEnabled(true);
                    if (SDPrintDialogUI.this.fCurrentPage.getSelection()) {
                        SDPrintDialogUI.this.fCurrentPage.setSelection(false);
                        SDPrintDialogUI.this.fAllPages.setSelection(true);
                    }
                    if ("".equals(SDPrintDialogUI.this.fVertPagesNum.getText())) {
                        SDPrintDialogUI.this.fVertPagesNum.setText("1");
                    }
                }
                if (SDPrintDialogUI.this.fCurrentPage.getSelection() || SDPrintDialogUI.this.fAllPages.getSelection() || SDPrintDialogUI.this.fPageList.getSelection()) {
                    SDPrintDialogUI.this.fFromPage.setEnabled(false);
                    SDPrintDialogUI.this.fToPage.setEnabled(false);
                } else {
                    SDPrintDialogUI.this.fFromPage.setEnabled(true);
                    SDPrintDialogUI.this.fToPage.setEnabled(true);
                }
                SDPrintDialogUI.this.fCurrentPage.setEnabled(SDPrintDialogUI.this.fUseCurrentZoom.getSelection());
                SDPrintDialogUI.this.fOverviewCanvas.setEnabled(SDPrintDialogUI.this.fPageList.getSelection());
                if (SDPrintDialogUI.this.fOverviewCanvas.isEnabled() && (e.widget == SDPrintDialogUI.this.fUseCurrentZoom || e.widget == SDPrintDialogUI.this.fSetHPagesNumber || e.widget == SDPrintDialogUI.this.fSetVPagesNumber)) {
                    SDPrintDialogUI.this.fPagesList = new int[1];
                    ((SDPrintDialogUI)SDPrintDialogUI.this).fPagesList[0] = 1;
                    SDPrintDialogUI.this.fPageNum = 1;
                    SDPrintDialogUI.this.fFirstPage = 1;
                } else if (SDPrintDialogUI.this.fOverviewCanvas.isEnabled() && e.widget == SDPrintDialogUI.this.fPageList && (SDPrintDialogUI.this.fPagesList == null || SDPrintDialogUI.this.fPagesList.length <= 0)) {
                    SDPrintDialogUI.this.fPagesList = new int[1];
                    ((SDPrintDialogUI)SDPrintDialogUI.this).fPagesList[0] = 1;
                    SDPrintDialogUI.this.fPageNum = 1;
                    SDPrintDialogUI.this.fFirstPage = 1;
                }
                SDPrintDialogUI.this.computeStepXY();
                SDPrintDialogUI.this.fTotalPages.setText(Integer.valueOf(SDPrintDialogUI.this.maxNumOfPages()).toString());
                SDPrintDialogUI.this.fOverviewCanvas.redraw();
                SDPrintDialogUI.this.fOverviewCanvas.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SDPrintDialogUI.this.fPagesList = new int[0];
                SDPrintDialogUI.this.computeStepXY();
                SDPrintDialogUI.this.fOverviewCanvas.redraw();
            }
        };
        this.fModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDPrintDialogUI.this.fPagesList = new int[0];
                SDPrintDialogUI.this.computeStepXY();
                SDPrintDialogUI.this.fTotalPages.setText(Integer.valueOf(SDPrintDialogUI.this.maxNumOfPages()).toString());
                SDPrintDialogUI.this.fOverviewCanvas.redraw();
            }
        };
    }

    protected GridData newGridData(int span) {
        GridData data = new GridData(1808);
        data.horizontalSpan = span;
        return data;
    }

    public Control createDialogArea(Composite parent) {
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 6;
        parent.setLayout((Layout)parentLayout);
        Group g1 = new Group(parent, 32);
        g1.setText(Messages.SequenceDiagram_ZoomOption);
        g1.setLayoutData((Object)this.newGridData(3));
        GridLayout g1layout = new GridLayout();
        g1layout.numColumns = 2;
        g1.setLayout((Layout)g1layout);
        this.fUseCurrentZoom = new Button((Composite)g1, 16);
        this.fUseCurrentZoom.setText(Messages.SequenceDiagram_UseCurrentZoom);
        this.fUseCurrentZoom.setLayoutData((Object)this.newGridData(2));
        this.fUseCurrentZoom.addSelectionListener(this.fSelectionListener);
        this.fSetHPagesNumber = new Button((Composite)g1, 16);
        this.fSetHPagesNumber.setText(Messages.SequenceDiagram_NumberOfHorizontalPages);
        this.fSetHPagesNumber.setLayoutData((Object)this.newGridData(1));
        this.fSetHPagesNumber.addSelectionListener(this.fSelectionListener);
        this.fHorPagesNum = new Text((Composite)g1, 2052);
        this.fHorPagesNum.addModifyListener(this.fModifyListener);
        this.fSetVPagesNumber = new Button((Composite)g1, 16);
        this.fSetVPagesNumber.setText(Messages.SequenceDiagram_NumberOfVerticalPages);
        this.fSetVPagesNumber.setLayoutData((Object)this.newGridData(1));
        this.fSetVPagesNumber.addSelectionListener(this.fSelectionListener);
        this.fVertPagesNum = new Text((Composite)g1, 2052);
        this.fVertPagesNum.addModifyListener(this.fModifyListener);
        Label nbTotal = new Label((Composite)g1, 131104);
        nbTotal.setText(Messages.TotalNumberOfPages);
        this.fTotalPages = new Text((Composite)g1, 2060);
        Group g2 = new Group(parent, 32);
        g2.setText(Messages.SequenceDiagram_Preview);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 2;
        g2.setLayoutData((Object)data);
        GridLayout g2layout = new GridLayout();
        g2layout.numColumns = 1;
        g2.setLayout((Layout)g2layout);
        GridData data2 = new GridData(1808);
        data2.horizontalSpan = 1;
        data2.verticalSpan = 1;
        this.fOverviewCanvas = new LocalSD((Composite)g2, 262144);
        GridData seqDiagLayoutData = new GridData(272);
        this.fOverviewCanvas.setLayoutData(seqDiagLayoutData);
        this.fTest = this.fSdView.getContentsWidth() < this.fSdView.getVisibleWidth() && this.fSdView.getContentsHeight() < this.fSdView.getVisibleHeight() ? 3 : 10;
        this.fOverviewCanvas.setFrame(this.fSdView.getFrame(), true);
        this.fOverviewCanvas.setZoomValue(1.0f / (float)this.fTest);
        this.fOverviewCanvas.setCornerControl(null);
        seqDiagLayoutData.widthHint = this.fOverviewCanvas.getContentsWidth() / this.fTest;
        seqDiagLayoutData.widthHint = this.fOverviewCanvas.getFrame().getWidth() / this.fTest + 15;
        if (this.fSdView.getVisibleWidth() < this.fSdView.getContentsWidth()) {
            seqDiagLayoutData.widthHint = this.fOverviewCanvas.getContentsWidth() / this.fTest;
            if (seqDiagLayoutData.widthHint > Display.getDefault().getClientArea().width / 4) {
                seqDiagLayoutData.widthHint = Display.getDefault().getClientArea().width / 4;
            }
        } else {
            seqDiagLayoutData.widthHint = this.fOverviewCanvas.getFrame().getWidth() / this.fTest + 15;
        }
        if (this.fSdView.getVisibleHeight() < this.fSdView.getContentsHeight()) {
            seqDiagLayoutData.heightHint = this.fOverviewCanvas.getContentsHeight() / this.fTest;
            if (seqDiagLayoutData.heightHint > Display.getDefault().getClientArea().width / 4) {
                seqDiagLayoutData.heightHint = Display.getDefault().getClientArea().width / 4;
            }
        } else {
            seqDiagLayoutData.heightHint = this.fOverviewCanvas.getFrame().getHeight() / this.fTest;
        }
        this.fOverviewCanvas.setEnabled(false);
        this.fCurrentSelection = new Label((Composite)g2, 16416);
        this.fCurrentSelection.setLayoutData((Object)this.newGridData(1));
        Group g3 = new Group(parent, 32);
        g3.setText(Messages.SequenceDiagram_PrintRange);
        g3.setLayoutData((Object)this.newGridData(3));
        GridLayout g3layout = new GridLayout();
        g3layout.numColumns = 4;
        g3.setLayout((Layout)g3layout);
        this.fAllPages = new Button((Composite)g3, 16);
        this.fAllPages.setText(Messages.SequenceDiagram_AllPages);
        this.fAllPages.setLayoutData((Object)this.newGridData(4));
        this.fAllPages.addSelectionListener(this.fSelectionListener);
        this.fCurrentPage = new Button((Composite)g3, 16);
        this.fCurrentPage.setText(Messages.SequenceDiagram_CurrentView);
        this.fCurrentPage.setLayoutData((Object)this.newGridData(4));
        this.fCurrentPage.setEnabled(true);
        this.fCurrentPage.setSelection(true);
        this.fCurrentPage.addSelectionListener(this.fSelectionListener);
        this.fPageList = new Button((Composite)g3, 16);
        this.fPageList.setText(Messages.SequenceDiagram_SelectedPages);
        this.fPageList.setLayoutData((Object)this.newGridData(4));
        this.fPageList.addSelectionListener(this.fSelectionListener);
        this.fPageRange = new Button((Composite)g3, 16);
        this.fPageRange.setText(Messages.SequenceDiagram_FromPage);
        this.fPageRange.setLayoutData((Object)this.newGridData(1));
        this.fPageRange.addSelectionListener(this.fSelectionListener);
        this.fFromPage = new Text((Composite)g3, 2052);
        Label labelTo = new Label((Composite)g3, 0x1000000);
        labelTo.setText(Messages.SequenceDiagram_to);
        this.fToPage = new Text((Composite)g3, 2052);
        this.fToolTip = new DiagramToolTip((Control)this.fOverviewCanvas);
        this.fOverviewCanvas.getViewControl().addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                SDPrintDialogUI.this.fToolTip.hideToolTip();
            }

            public void mouseExit(MouseEvent e) {
                SDPrintDialogUI.this.fToolTip.hideToolTip();
            }

            public void mouseHover(MouseEvent e) {
                int x2;
                int x1 = (int)((float)SDPrintDialogUI.this.fOverviewCanvas.viewToContentsX(e.x) / SDPrintDialogUI.this.fOverviewCanvas.getZoomValue() / SDPrintDialogUI.this.fStepX);
                int num = x1 + (x2 = (int)((float)SDPrintDialogUI.this.fOverviewCanvas.viewToContentsY(e.y) / SDPrintDialogUI.this.fOverviewCanvas.getZoomValue() / SDPrintDialogUI.this.fStepY)) * SDPrintDialogUI.this.getNbRow() + 1;
                if (num > SDPrintDialogUI.this.maxNumOfPages()) {
                    return;
                }
                if (num > 0) {
                    SDPrintDialogUI.this.fToolTip.showToolTip(String.valueOf(num));
                    SDPrintDialogUI.this.displayPageNum();
                } else {
                    SDPrintDialogUI.this.fCurrentSelection.setText("");
                    SDPrintDialogUI.this.fToolTip.hideToolTip();
                }
            }
        });
        this.fOverviewCanvas.addTraverseListener(new LocalTraverseListener());
        this.fOverviewCanvas.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                SDPrintDialogUI.this.fOverviewCanvas.redraw();
            }

            public void focusLost(FocusEvent e) {
                SDPrintDialogUI.this.fOverviewCanvas.redraw();
            }
        });
        if (this.fShowPrintButton) {
            Composite printerDlg = new Composite(parent, 0);
            data = new GridData(4, -1, true, false);
            data.horizontalSpan = 6;
            parentLayout = new GridLayout();
            parentLayout.numColumns = 2;
            printerDlg.setLayout((Layout)parentLayout);
            printerDlg.setLayoutData((Object)data);
            Label label = new Label(printerDlg, 0);
            label.setLayoutData((Object)new GridData(4, -1, true, false));
            this.fPrinterDialog = new Button(printerDlg, 8);
            this.fPrinterDialog.setText(Messages.SequenceDiagram_Printer);
            this.fPrinterDialog.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SDPrintDialogUI.this.printButtonSelected();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.updatePrinterStatus();
        return parent;
    }

    public int getPagesForSelection() {
        return this.fNbPages;
    }

    public boolean okPressed() {
        block9: {
            block8: {
                block7: {
                    this.fPrintAll = this.fAllPages.getSelection();
                    this.fPrintCurrent = this.fCurrentPage.getSelection();
                    this.fPrintSelection = this.fPageList.getSelection();
                    this.fPrintRange = this.fPageRange.getSelection();
                    try {
                        if (!this.fPrintRange) break block7;
                        this.fFrom = Integer.valueOf(this.fFromPage.getText());
                        this.fTo = Integer.valueOf(this.fToPage.getText());
                        if (this.fFrom > this.maxNumOfPages() || this.fTo > this.maxNumOfPages() || this.fFrom <= 0 || this.fTo <= 0) {
                            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SequenceDiagram_Error, (String)Messages.SequenceDiagram_InvalidRange);
                            return false;
                        }
                    }
                    catch (Exception exception) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.SequenceDiagram_Error, (String)Messages.SequenceDiagram_InvalidRange);
                        this.fFrom = 0;
                        this.fTo = 0;
                        return false;
                    }
                }
                if (!this.fSetHPagesNumber.getSelection() || this.fNbPages > 0) break block8;
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.SequenceDiagram_Error, (String)Messages.SequenceDiagram_InvalidNbHorizontal);
                return false;
            }
            if (!this.fSetVPagesNumber.getSelection() || this.fNbPages > 0) break block9;
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SequenceDiagram_Error, (String)Messages.SequenceDiagram_InvalidNbVertical);
            return false;
        }
        if (this.fPrintSelection && this.getPageList().length <= 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SequenceDiagram_Error, (String)Messages.SequenceDiagram_NoPageSelected);
            return false;
        }
        return true;
    }

    public ImageData drawRegionSelected(Image img, Rectangle r, RGB color) {
        ImageData id = img.getImageData();
        int a = 0;
        while (a < r.width && r.x + a < id.width) {
            int b = 0;
            while (b < r.height && r.y + b < id.height) {
                int index = id.getPixel(r.x + a, r.y + b);
                RGB rgb = id.palette.getRGB(index);
                rgb = SDPrintDialogUI.combine(color, rgb);
                id.setPixel(r.x + a, r.y + b, id.palette.getPixel(rgb));
                ++b;
            }
            ++a;
        }
        return id;
    }

    public static RGB combine(RGB front, RGB back) {
        int _af = 128;
        int _ab = 200;
        double af = (double)_af / 255.0;
        double rf = front.red;
        double gf = front.green;
        double bf = front.blue;
        double ab = (double)_ab / 255.0;
        double rb = back.red;
        double gb = back.green;
        double bb = back.blue;
        double k = (1.0 - af) * ab;
        int r = (int)(af * rf + k * rb);
        int g = (int)(af * gf + k * gb);
        int b = (int)(af * bf + k * bb);
        return new RGB(r, g, b);
    }

    protected void computeStepXY() {
        float cw = (float)this.fOverviewCanvas.getContentsWidth() / this.fOverviewCanvas.getZoomValue();
        float ch = (float)this.fOverviewCanvas.getContentsHeight() / this.fOverviewCanvas.getZoomValue();
        try {
            if (this.fPrinterData == null) {
                this.fStepX = 0.0f;
                this.fStepY = 0.0f;
                this.fNbPages = 0;
                this.fZoomFactor = 0.0f;
            } else {
                Printer printer = new Printer(this.fPrinterData);
                if (this.fSetHPagesNumber.getSelection()) {
                    this.fNbPages = Integer.valueOf(this.fHorPagesNum.getText());
                    float z1 = (float)this.fSdView.getContentsWidth() / cw;
                    float z2 = (float)printer.getClientArea().width / ((float)this.fSdView.getContentsWidth() / (float)this.fNbPages);
                    this.fStepY = (float)printer.getClientArea().height / z1 / z2;
                    this.fStepX = cw / (float)this.fNbPages;
                } else if (this.fSetVPagesNumber.getSelection()) {
                    this.fNbPages = Integer.valueOf(this.fVertPagesNum.getText());
                    float z1 = (float)this.fSdView.getContentsHeight() / ch;
                    float z2 = (float)printer.getClientArea().height / ((float)this.fSdView.getContentsHeight() / (float)this.fNbPages);
                    this.fStepX = (float)printer.getClientArea().width / z1 / z2;
                    this.fStepY = ch / (float)this.fNbPages;
                } else {
                    float z1 = (float)this.fSdView.getContentsWidth() / cw;
                    this.fStepX = (float)this.fSdView.getVisibleWidth() / z1;
                    this.fNbPages = Math.round(cw / this.fStepX);
                    if (this.fNbPages == 0) {
                        this.fNbPages = 1;
                    }
                    int pw = printer.getClientArea().width;
                    int ph = printer.getClientArea().height;
                    float z2 = (float)pw / ((float)this.fSdView.getContentsWidth() / (float)this.fNbPages);
                    this.fStepY = (float)ph / z1 / z2;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fNbPages = 0;
            this.fStepX = this.fStepY = (float)0;
            this.fZoomFactor = 0.0f;
        }
        this.sTX = this.fStepX * ((float)this.fSdView.getContentsWidth() / cw);
        this.sTY = this.fStepY * ((float)this.fSdView.getContentsHeight() / ch);
        float rat = 1.0f;
        if (this.fSdView.getVisibleWidth() > this.fSdView.getContentsWidth() && (this.fSetVPagesNumber.getSelection() || this.fSetHPagesNumber.getSelection())) {
            rat = (float)this.fSdView.getVisibleWidth() / (float)this.fSdView.getContentsWidth();
        }
        this.fZoomFactor = (float)this.fOverviewCanvas.getContentsWidth() / cw / this.fOverviewCanvas.getZoomFactor() * rat;
    }

    public int[] getPageList() {
        return Arrays.copyOf(this.fPagesList, this.fPagesList.length);
    }

    public void addToPagesList(int num) {
        int[] temp = new int[this.fPagesList.length + 1];
        System.arraycopy(this.fPagesList, 0, temp, 0, this.fPagesList.length);
        temp[temp.length - 1] = num;
        this.fPagesList = new int[temp.length];
        System.arraycopy(temp, 0, this.fPagesList, 0, temp.length);
    }

    public void removeFromPagesList(int num) {
        int pos = Arrays.binarySearch(this.fPagesList, num);
        int[] temp = new int[this.fPagesList.length - 1];
        System.arraycopy(this.fPagesList, 0, temp, 0, pos);
        System.arraycopy(this.fPagesList, pos + 1, temp, pos, this.fPagesList.length - pos - 1);
        this.fPagesList = new int[temp.length];
        System.arraycopy(temp, 0, this.fPagesList, 0, temp.length);
    }

    public int maxNumOfPages() {
        return this.getNbRow() * this.getNbLines();
    }

    public int getNbRow() {
        if (!this.fSetHPagesNumber.isDisposed()) {
            int cw = (int)((float)this.fOverviewCanvas.getContentsWidth() / this.fOverviewCanvas.getZoomValue());
            int row = 1;
            if (this.fStepX != 0.0f) {
                row = (int)((float)cw / this.fStepX);
                if (this.fSetHPagesNumber.getSelection()) {
                    row = Math.round((float)cw / this.fStepX);
                } else if ((float)cw % this.fStepX != 0.0f) {
                    ++row;
                }
            }
            this.fNbRows = row;
        }
        return this.fNbRows;
    }

    public int getNbLines() {
        if (!this.fSetVPagesNumber.isDisposed()) {
            int ch = (int)((float)this.fOverviewCanvas.getContentsHeight() / this.fOverviewCanvas.getZoomValue());
            int line = 1;
            if (this.fStepY != 0.0f) {
                line = (int)((float)ch / this.fStepY);
                if (this.fSetVPagesNumber.getSelection()) {
                    line = Math.round((float)ch / this.fStepY);
                } else if ((float)ch % this.fStepY != 0.0f) {
                    ++line;
                }
            }
            this.fNbLines = line;
        }
        return this.fNbLines;
    }

    public boolean printAll() {
        return this.fPrintAll;
    }

    public boolean printCurrent() {
        return this.fPrintCurrent;
    }

    public boolean printSelection() {
        return this.fPrintSelection;
    }

    public boolean printRange() {
        return this.fPrintRange;
    }

    public float getStepX() {
        return this.sTX;
    }

    public float getStepY() {
        return this.sTY;
    }

    public float getZoomFactor() {
        return this.fZoomFactor;
    }

    public PrinterData getPrinterData() {
        return this.fPrinterData;
    }

    public int getFrom() {
        return this.fFrom;
    }

    public int getTo() {
        return this.fTo;
    }

    protected void displayPageNum() {
        if (this.fPageNum > 0) {
            String message = MessageFormat.format(Messages.SequenceDiagram_Page, this.fPageNum);
            this.fCurrentSelection.setText(message);
            this.fCurrentSelection.getParent().layout();
        }
    }

    public Shell getShell() {
        return this.fShell;
    }

    public void setShell(Shell shell) {
        this.fShell = shell;
    }

    public void printButtonSelected() {
        PrinterData newPrinterData;
        PrintDialog printer = new PrintDialog(this.getShell());
        if (this.fAllPages.getSelection()) {
            printer.setScope(0);
        }
        if (this.fCurrentPage.getSelection()) {
            printer.setScope(2);
        }
        if (this.fPageList.getSelection()) {
            printer.setScope(2);
        }
        if (this.fPageRange.getSelection()) {
            printer.setScope(1);
            this.fFrom = Integer.valueOf(this.fFromPage.getText());
            this.fTo = Integer.valueOf(this.fToPage.getText());
            printer.setStartPage(this.fFrom);
            printer.setEndPage(this.fTo);
        }
        if ((newPrinterData = printer.open()) != null) {
            this.fPrinterData = newPrinterData;
        }
        this.updatePrinterStatus();
        if (printer.getScope() == 0) {
            this.fAllPages.setSelection(true);
            this.fCurrentPage.setSelection(false);
            this.fPageList.setSelection(false);
            this.fPageRange.setSelection(false);
            this.fHorPagesNum.setEnabled(false);
            this.fVertPagesNum.setEnabled(false);
        }
        if (printer.getScope() == 1) {
            this.fAllPages.setSelection(false);
            this.fCurrentPage.setSelection(false);
            this.fPageList.setSelection(false);
            this.fPageRange.setSelection(true);
            this.fFromPage.setEnabled(true);
            this.fToPage.setEnabled(true);
            this.fFromPage.setText(Integer.valueOf(printer.getStartPage()).toString());
            this.fToPage.setText(Integer.valueOf(printer.getEndPage()).toString());
        }
        this.computeStepXY();
        this.fOverviewCanvas.redraw();
    }

    public void setParentWizardPage(WizardPage parent) {
        this.fParentWizardPage = parent;
    }

    public void setParentDialog(SDPrintDialog parent) {
        this.fParentDialog = parent;
    }

    protected void updatePrinterStatus() {
        if (this.fParentWizardPage != null) {
            if (this.fPrinterData == null) {
                this.fParentWizardPage.setErrorMessage(Messages.SequenceDiagram_NoPrinterSelected);
                this.fParentWizardPage.setPageComplete(false);
            } else {
                this.fParentWizardPage.setErrorMessage(null);
                this.fParentWizardPage.setPageComplete(true);
            }
        } else if (this.fParentDialog != null) {
            if (this.fPrinterData == null) {
                this.fParentDialog.setErrorMessage(Messages.SequenceDiagram_NoPrinterSelected);
                this.fParentDialog.setPageComplete(false);
            } else {
                this.fParentDialog.setErrorMessage(null);
                this.fParentDialog.setPageComplete(true);
            }
        }
    }

    private class LocalSD
    extends SDWidget {
        public LocalSD(Composite c, int s) {
            super(c, s);
        }

        @Override
        public int getContentsHeight() {
            if (SDPrintDialogUI.this.fSdView.getContentsHeight() > SDPrintDialogUI.this.fSdView.getContentsHeight()) {
                return (int)((float)SDPrintDialogUI.this.fSdView.getVisibleHeight() / (float)SDPrintDialogUI.this.fTest / SDPrintDialogUI.this.fSdView.getZoomValue());
            }
            return super.getContentsHeight();
        }

        @Override
        public int getContentsWidth() {
            if (SDPrintDialogUI.this.fSdView.getVisibleWidth() > SDPrintDialogUI.this.fSdView.getContentsWidth()) {
                return (int)((float)SDPrintDialogUI.this.fSdView.getVisibleWidth() / (float)SDPrintDialogUI.this.fTest / SDPrintDialogUI.this.fSdView.getZoomValue());
            }
            return super.getContentsWidth();
        }

        @Override
        protected void contentsMouseHover(MouseEvent event) {
        }

        protected Image createPagesSelectionImages(Image img, int width, float stepX, int height, float stepY) {
            Image over = new Image((Device)super.getShell().getDisplay(), img.getImageData());
            int pageIndex = 0;
            while (pageIndex < SDPrintDialogUI.this.fPagesList.length) {
                int pageNum = SDPrintDialogUI.this.fPagesList[pageIndex];
                if (SDPrintDialogUI.this.getPagesForSelection() > 0 && pageNum > 0) {
                    int line = pageNum / SDPrintDialogUI.this.getNbRow();
                    int row = pageNum % SDPrintDialogUI.this.getNbRow();
                    if (row != 0) {
                        ++line;
                    } else {
                        row = SDPrintDialogUI.this.getNbRow();
                    }
                    Image toDel = over;
                    over = SDPrintDialogUI.this.fOverviewCanvas.isFocusControl() ? new Image((Device)super.getShell().getDisplay(), SDPrintDialogUI.this.drawRegionSelected(toDel, new Rectangle(this.contentsToViewX((int)((float)row * stepX * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue())), this.contentsToViewY((int)((float)line * stepY * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue())), (int)(stepX * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue()), (int)(stepY * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue())), new RGB(0, 0, 128))) : new Image((Device)super.getShell().getDisplay(), SDPrintDialogUI.this.drawRegionSelected(toDel, new Rectangle(this.contentsToViewX((int)((float)(--row) * stepX * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue())), this.contentsToViewY((int)((float)(--line) * stepY * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue())), (int)(stepX * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue()), (int)(stepY * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue())), new RGB(221, 208, 200)));
                    toDel.dispose();
                }
                ++pageIndex;
            }
            Arrays.sort(SDPrintDialogUI.this.fPagesList);
            int pos = Arrays.binarySearch(SDPrintDialogUI.this.fPagesList, SDPrintDialogUI.this.fPageNum);
            if (pos < 0 && SDPrintDialogUI.this.getPagesForSelection() > 0 && SDPrintDialogUI.this.fPageNum > 0) {
                int line = SDPrintDialogUI.this.fPageNum / SDPrintDialogUI.this.getNbRow();
                int row = SDPrintDialogUI.this.fPageNum % SDPrintDialogUI.this.getNbRow();
                if (row != 0) {
                    ++line;
                } else {
                    row = SDPrintDialogUI.this.getNbRow();
                }
                Image toDel = over;
                over = new Image((Device)super.getShell().getDisplay(), SDPrintDialogUI.this.drawRegionSelected(toDel, new Rectangle(this.contentsToViewX((int)((float)(--row) * stepX * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue())), this.contentsToViewY((int)((float)(--line) * stepY * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue())), (int)(stepX * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue()), (int)(stepY * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue())), new RGB(221, 208, 200)));
                toDel.dispose();
            }
            GC imGC2 = new GC((Drawable)over);
            imGC2.setBackground(Display.getDefault().getSystemColor(2));
            NGC imGC = new NGC(SDPrintDialogUI.this.fOverviewCanvas, imGC2);
            int i = 0;
            int x = 0;
            while (x <= width && stepX > 0.0f) {
                imGC.drawLine(x, 0, x, height);
                x = (int)((float)(++i) * stepX);
            }
            int j = 0;
            int y = 0;
            while (y <= height && stepY > 0.0f) {
                imGC.drawLine(0, y, width, y);
                y = (int)((float)(++j) * stepY);
            }
            imGC2.dispose();
            imGC.dispose();
            return over;
        }

        @Override
        protected void drawContents(GC gc, int clipx, int clipy, int clipw, int cliph) {
            Image dbuffer = this.getDrawBuffer();
            SDPrintDialogUI.this.computeStepXY();
            int lw = (int)((float)this.getContentsWidth() / this.getZoomValue());
            if (this.getContentsWidth() < this.getVisibleWidth()) {
                lw = (int)((float)this.getVisibleWidth() / this.getZoomValue());
            }
            int lh = (int)((float)this.getContentsHeight() / this.getZoomValue());
            if (this.getContentsHeight() < this.getVisibleHeight()) {
                lh = (int)((float)this.getVisibleHeight() / this.getZoomValue());
            }
            Image d = this.createPagesSelectionImages(dbuffer, lw, SDPrintDialogUI.this.fStepX, lh, SDPrintDialogUI.this.fStepY);
            if (!this.isEnabled()) {
                Image toDel = d;
                d = new Image((Device)super.getShell().getDisplay(), SDPrintDialogUI.this.drawRegionSelected(d, new Rectangle(0, 0, lw, lh), new RGB(221, 208, 200)));
                toDel.dispose();
            }
            Rectangle area = this.getClientArea();
            int w = d.getBounds().width;
            int h = d.getBounds().height;
            gc.drawImage(d, 0, 0, w, h, 0, 0, area.width, area.height);
            SDPrintDialogUI.this.fTotalPages.setText(Integer.valueOf(SDPrintDialogUI.this.maxNumOfPages()).toString());
            SDPrintDialogUI.this.displayPageNum();
            dbuffer.dispose();
            d.dispose();
            gc.dispose();
        }

        @Override
        protected void keyPressedEvent(KeyEvent e) {
            int row;
            int row2;
            int line;
            if (e.keyCode == 262144) {
                SDPrintDialogUI.this.fMultiSelection = true;
            }
            if (e.keyCode == 131072) {
                SDPrintDialogUI.this.fAreaSelection = true;
            }
            if (e.keyCode == 0x1000002) {
                if (SDPrintDialogUI.this.fPageNum + SDPrintDialogUI.this.getNbRow() <= SDPrintDialogUI.this.maxNumOfPages()) {
                    SDPrintDialogUI sDPrintDialogUI = SDPrintDialogUI.this;
                    sDPrintDialogUI.fPageNum = sDPrintDialogUI.fPageNum + SDPrintDialogUI.this.getNbRow();
                }
                line = SDPrintDialogUI.this.fPageNum / SDPrintDialogUI.this.getNbRow();
                row2 = SDPrintDialogUI.this.fPageNum % SDPrintDialogUI.this.getNbRow();
                if (row2 == 0) {
                    --line;
                }
                if ((float)(line + 1) * SDPrintDialogUI.this.fStepY > (float)(SDPrintDialogUI.this.fOverviewCanvas.getContentsY() + SDPrintDialogUI.this.fOverviewCanvas.getVisibleHeight()) / SDPrintDialogUI.this.fOverviewCanvas.getZoomValue()) {
                    SDPrintDialogUI.this.fOverviewCanvas.scrollBy(0, (int)(SDPrintDialogUI.this.fStepY * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue()));
                }
            }
            if (e.keyCode == 0x1000001) {
                if (SDPrintDialogUI.this.fPageNum - SDPrintDialogUI.this.getNbRow() > 0) {
                    SDPrintDialogUI sDPrintDialogUI = SDPrintDialogUI.this;
                    sDPrintDialogUI.fPageNum = sDPrintDialogUI.fPageNum - SDPrintDialogUI.this.getNbRow();
                }
                line = SDPrintDialogUI.this.fPageNum / SDPrintDialogUI.this.getNbRow();
                row2 = SDPrintDialogUI.this.fPageNum % SDPrintDialogUI.this.getNbRow();
                if (row2 == 0) {
                    --line;
                }
                if ((float)line * SDPrintDialogUI.this.fStepY <= (float)SDPrintDialogUI.this.fOverviewCanvas.getContentsY() / SDPrintDialogUI.this.fOverviewCanvas.getZoomValue()) {
                    SDPrintDialogUI.this.fOverviewCanvas.scrollBy(0, -((int)(SDPrintDialogUI.this.fStepY * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue())));
                }
            }
            if (e.keyCode == 0x1000003) {
                if ((SDPrintDialogUI.this.fPageNum - 2) / SDPrintDialogUI.this.getNbRow() == (SDPrintDialogUI.this.fPageNum - 1) / SDPrintDialogUI.this.getNbRow() && SDPrintDialogUI.this.fPageNum > 1) {
                    SDPrintDialogUI sDPrintDialogUI = SDPrintDialogUI.this;
                    sDPrintDialogUI.fPageNum = sDPrintDialogUI.fPageNum - 1;
                }
                if ((float)((row = SDPrintDialogUI.this.fPageNum % SDPrintDialogUI.this.getNbRow()) - 1) * SDPrintDialogUI.this.fStepX < (float)SDPrintDialogUI.this.fOverviewCanvas.getContentsX() / SDPrintDialogUI.this.fOverviewCanvas.getZoomValue()) {
                    SDPrintDialogUI.this.fOverviewCanvas.scrollBy(-((int)(SDPrintDialogUI.this.fStepX * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue())), 0);
                }
            }
            if (e.keyCode == 0x1000004) {
                if ((SDPrintDialogUI.this.fPageNum - 1) / SDPrintDialogUI.this.getNbRow() == SDPrintDialogUI.this.fPageNum / SDPrintDialogUI.this.getNbRow()) {
                    SDPrintDialogUI sDPrintDialogUI = SDPrintDialogUI.this;
                    sDPrintDialogUI.fPageNum = sDPrintDialogUI.fPageNum + 1;
                }
                if ((row = SDPrintDialogUI.this.fPageNum % SDPrintDialogUI.this.getNbRow()) == 0) {
                    row = SDPrintDialogUI.this.getNbRow();
                }
                if ((float)row * SDPrintDialogUI.this.fStepX > (float)(SDPrintDialogUI.this.fOverviewCanvas.getContentsX() + SDPrintDialogUI.this.fOverviewCanvas.getVisibleWidth()) / SDPrintDialogUI.this.fOverviewCanvas.getZoomValue()) {
                    SDPrintDialogUI.this.fOverviewCanvas.scrollBy((int)(SDPrintDialogUI.this.fStepX * SDPrintDialogUI.this.fOverviewCanvas.getZoomValue()), 0);
                }
            }
            if (e.keyCode == 32 && SDPrintDialogUI.this.fPageNum > -1) {
                Arrays.sort(SDPrintDialogUI.this.fPagesList);
                int pos = Arrays.binarySearch(SDPrintDialogUI.this.fPagesList, SDPrintDialogUI.this.fPageNum);
                if (pos < 0) {
                    SDPrintDialogUI.this.addToPagesList(SDPrintDialogUI.this.fPageNum);
                } else {
                    SDPrintDialogUI.this.removeFromPagesList(SDPrintDialogUI.this.fPageNum);
                }
            }
            if (!SDPrintDialogUI.this.fAreaSelection && !SDPrintDialogUI.this.fMultiSelection) {
                SDPrintDialogUI.this.fFirstPage = SDPrintDialogUI.this.fPageNum;
                SDPrintDialogUI.this.fPagesList = new int[1];
                ((SDPrintDialogUI)SDPrintDialogUI.this).fPagesList[0] = SDPrintDialogUI.this.fPageNum;
            } else if (SDPrintDialogUI.this.fPageNum != -1 && SDPrintDialogUI.this.fAreaSelection && SDPrintDialogUI.this.fFirstPage != -1) {
                int temp;
                SDPrintDialogUI.this.fPagesList = new int[0];
                int line1 = SDPrintDialogUI.this.fFirstPage / SDPrintDialogUI.this.getNbRow();
                int row1 = SDPrintDialogUI.this.fFirstPage % SDPrintDialogUI.this.getNbRow();
                if (row1 != 0) {
                    ++line1;
                } else {
                    row1 = SDPrintDialogUI.this.getNbRow();
                }
                int line2 = SDPrintDialogUI.this.fPageNum / SDPrintDialogUI.this.getNbRow();
                int row22 = SDPrintDialogUI.this.fPageNum % SDPrintDialogUI.this.getNbRow();
                if (row22 != 0) {
                    ++line2;
                } else {
                    row22 = SDPrintDialogUI.this.getNbRow();
                }
                if (line1 > line2) {
                    temp = line2;
                    line2 = line1;
                    line1 = temp;
                }
                if (row1 > row22) {
                    temp = row22;
                    row22 = row1;
                    row1 = temp;
                }
                int i = row1 - 1;
                while (i < row22) {
                    int j = line1 - 1;
                    while (j < line2) {
                        SDPrintDialogUI.this.addToPagesList(i + j * SDPrintDialogUI.this.getNbRow() + 1);
                        ++j;
                    }
                    ++i;
                }
            }
            SDPrintDialogUI.this.displayPageNum();
            SDPrintDialogUI.this.fOverviewCanvas.redraw();
        }

        @Override
        protected void keyReleasedEvent(KeyEvent e) {
            if (e.keyCode == 262144) {
                SDPrintDialogUI.this.fMultiSelection = false;
            }
            if (e.keyCode == 131072) {
                SDPrintDialogUI.this.fAreaSelection = false;
            }
        }

        @Override
        protected void contentsMouseDownEvent(MouseEvent event) {
            SDPrintDialogUI.this.computeStepXY();
            int x1 = (int)((float)event.x / SDPrintDialogUI.this.fOverviewCanvas.getZoomValue() / SDPrintDialogUI.this.fStepX);
            int x2 = (int)((float)event.y / SDPrintDialogUI.this.fOverviewCanvas.getZoomValue() / SDPrintDialogUI.this.fStepY);
            int oldPage = SDPrintDialogUI.this.fPageNum;
            SDPrintDialogUI.this.fPageNum = x1 + x2 * SDPrintDialogUI.this.getNbRow() + 1;
            if (SDPrintDialogUI.this.fPageNum > SDPrintDialogUI.this.maxNumOfPages()) {
                SDPrintDialogUI.this.fPageNum = oldPage;
                return;
            }
            if (!SDPrintDialogUI.this.fAreaSelection) {
                SDPrintDialogUI.this.fFirstPage = SDPrintDialogUI.this.fPageNum;
            }
            if (SDPrintDialogUI.this.fPageNum != -1 && SDPrintDialogUI.this.fMultiSelection) {
                Arrays.sort(SDPrintDialogUI.this.fPagesList);
                int pos = Arrays.binarySearch(SDPrintDialogUI.this.fPagesList, SDPrintDialogUI.this.fPageNum);
                if (pos < 0) {
                    SDPrintDialogUI.this.addToPagesList(SDPrintDialogUI.this.fPageNum);
                } else {
                    SDPrintDialogUI.this.removeFromPagesList(SDPrintDialogUI.this.fPageNum);
                }
            } else if (SDPrintDialogUI.this.fPageNum != -1 && SDPrintDialogUI.this.fAreaSelection && SDPrintDialogUI.this.fFirstPage != -1) {
                int temp;
                SDPrintDialogUI.this.fPagesList = new int[0];
                int line1 = SDPrintDialogUI.this.fFirstPage / SDPrintDialogUI.this.getNbRow();
                int row1 = SDPrintDialogUI.this.fFirstPage % SDPrintDialogUI.this.getNbRow();
                if (row1 != 0) {
                    ++line1;
                } else {
                    row1 = SDPrintDialogUI.this.getNbRow();
                }
                int line2 = SDPrintDialogUI.this.fPageNum / SDPrintDialogUI.this.getNbRow();
                int row2 = SDPrintDialogUI.this.fPageNum % SDPrintDialogUI.this.getNbRow();
                if (row2 != 0) {
                    ++line2;
                } else {
                    row2 = SDPrintDialogUI.this.getNbRow();
                }
                if (line1 > line2) {
                    temp = line2;
                    line2 = line1;
                    line1 = temp;
                }
                if (row1 > row2) {
                    temp = row2;
                    row2 = row1;
                    row1 = temp;
                }
                int i = row1 - 1;
                while (i < row2) {
                    int j = line1 - 1;
                    while (j < line2) {
                        SDPrintDialogUI.this.addToPagesList(i + j * SDPrintDialogUI.this.getNbRow() + 1);
                        ++j;
                    }
                    ++i;
                }
            } else {
                SDPrintDialogUI.this.fPagesList = new int[1];
                ((SDPrintDialogUI)SDPrintDialogUI.this).fPagesList[0] = SDPrintDialogUI.this.fPageNum;
            }
            if ((event.stateMask & 0x40000) != 0) {
                SDPrintDialogUI.this.fMultiSelection = true;
            }
            SDPrintDialogUI.this.displayPageNum();
            this.redraw();
        }

        @Override
        protected void contentsMouseMoveEvent(MouseEvent e) {
            SDPrintDialogUI.this.fToolTip.hideToolTip();
        }

        @Override
        public void resizeContents(int w, int h) {
            super.resizeContents(w, h);
        }
    }

    protected static class LocalTraverseListener
    implements TraverseListener {
        protected LocalTraverseListener() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16 || e.detail == 8) {
                e.doit = true;
            }
        }
    }
}

