/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd;

import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDWidget;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IColor;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IFont;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IImage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.impl.ColorImpl;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences.SDViewPref;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class NGC
implements IGC {
    private GC fContext;
    private SDWidget fView;
    private Font fTempFont = null;
    private IColor fGradientColor = null;
    private IColor fBackground = null;
    private IColor fForeground = null;
    private int fVisibleY;
    private int fVisibleX;
    private int yx;
    private int xx;
    private boolean fDrawWithFocus = false;
    private static int fVisibleScreenBounds = 0;

    public NGC(SDWidget scrollView, GC gc) {
        this.fContext = gc;
        this.fView = scrollView;
    }

    @Override
    public void setLineStyle(int style) {
        this.fContext.setLineStyle(style);
    }

    @Override
    public int getLineStyle() {
        return this.fContext.getLineStyle();
    }

    @Override
    public int getContentsX() {
        return Math.round((float)this.fView.getContentsX() / this.fView.getZoomValue());
    }

    @Override
    public int getContentsY() {
        return Math.round((float)this.fView.getContentsY() / this.fView.getZoomValue());
    }

    @Override
    public int getVisibleWidth() {
        return Math.round((float)this.fView.getVisibleWidth() / this.fView.getZoomValue());
    }

    @Override
    public int getVisibleHeight() {
        return Math.round((float)this.fView.getVisibleHeight() / this.fView.getZoomValue());
    }

    protected int getVisibleY() {
        return this.fVisibleY;
    }

    protected void setVisibleY(int visibleY) {
        this.fVisibleY = visibleY;
    }

    protected int getfVisibleX() {
        return this.fVisibleX;
    }

    protected void setVisibleX(int visibleX) {
        this.fVisibleX = visibleX;
    }

    protected int getYx() {
        return this.yx;
    }

    protected void setYx(int yx) {
        this.yx = yx;
    }

    protected int getXx() {
        return this.xx;
    }

    protected void setXx(int xx) {
        this.xx = xx;
    }

    @Override
    public int contentsToViewX(int x) {
        return this.fView.contentsToViewX(x);
    }

    @Override
    public int contentsToViewY(int y) {
        return this.fView.contentsToViewY(y);
    }

    protected byte code(int x, int y) {
        byte c = 0;
        this.fVisibleY = fVisibleScreenBounds;
        this.fVisibleX = fVisibleScreenBounds;
        this.yx = this.fView.getVisibleHeight() + fVisibleScreenBounds;
        this.xx = this.fView.getVisibleWidth() + fVisibleScreenBounds;
        if (y > this.yx) {
            c = (byte)(c | 1);
        } else if (y < this.fVisibleY) {
            c = (byte)(c | 2);
        }
        if (x > this.xx) {
            c = (byte)(c | 4);
        } else if (x < this.fVisibleX) {
            c = (byte)(c | 8);
        }
        return c;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        int localX1 = x1;
        int localY1 = y1;
        int localX2 = x2;
        int localY2 = y2;
        localX1 = Math.round((float)localX1 * this.fView.getZoomValue());
        localY1 = Math.round((float)localY1 * this.fView.getZoomValue());
        localX2 = Math.round((float)localX2 * this.fView.getZoomValue());
        localY2 = Math.round((float)localY2 * this.fView.getZoomValue());
        localX1 = this.fView.contentsToViewX(localX1);
        localY1 = this.fView.contentsToViewY(localY1);
        localX2 = this.fView.contentsToViewX(localX2);
        localY2 = this.fView.contentsToViewY(localY2);
        byte code1 = this.code(localX1, localY1);
        byte code2 = this.code(localX2, localY2);
        boolean draw = false;
        boolean end = false;
        int x = 0;
        int y = 0;
        do {
            byte codex;
            if (code1 == 0 && code2 == 0) {
                draw = true;
                end = true;
                continue;
            }
            if ((code1 & code2) != 0) {
                end = true;
                continue;
            }
            byte by = codex = code1 != 0 ? code1 : code2;
            if ((codex & 1) != 0) {
                x = localX1 + (localX2 - localX1) * (this.yx - localY1) / (localY2 - localY1);
                y = this.yx;
            } else if ((codex & 2) != 0) {
                x = localX1 + (localX2 - localX1) * (this.fVisibleY - localY1) / (localY2 - localY1);
                y = this.fVisibleY;
            } else if ((codex & 4) != 0) {
                y = localY1 + (localY2 - localY1) * (this.xx - localX1) / (localX2 - localX1);
                x = this.xx;
            } else if ((codex & 8) != 0) {
                y = localY1 + (localY2 - localY1) * (this.fVisibleX - localX1) / (localX2 - localX1);
                x = this.fVisibleX;
            }
            if (codex == code1) {
                localX1 = x;
                localY1 = y;
                code1 = this.code(localX1, localY1);
                continue;
            }
            localX2 = x;
            localY2 = y;
            code2 = this.code(localX2, localY2);
        } while (!end);
        if (draw) {
            this.fContext.drawLine(localX1, localY1, localX2, localY2);
        }
    }

    @Override
    public void drawRectangle(int x, int y, int width, int height) {
        int localX = x;
        int localY = y;
        int localWidth = width;
        int localHeight = height;
        localX = Math.round((float)localX * this.fView.getZoomValue());
        if (localY != this.getContentsY()) {
            localY = Math.round((float)localY * this.fView.getZoomValue());
            localY = this.fView.contentsToViewY(localY);
        } else {
            localY = 0;
        }
        localWidth = Math.round((float)localWidth * this.fView.getZoomValue());
        localHeight = Math.round((float)localHeight * this.fView.getZoomValue());
        localX = this.fView.contentsToViewX(localX);
        if (localX < -fVisibleScreenBounds) {
            localWidth = localWidth + localX + fVisibleScreenBounds;
            localX = -fVisibleScreenBounds;
        }
        if (localY < -fVisibleScreenBounds) {
            localHeight = localHeight + localY + fVisibleScreenBounds;
            localY = -fVisibleScreenBounds;
        }
        if (localWidth < -fVisibleScreenBounds && localX + localWidth < -fVisibleScreenBounds) {
            localWidth = -fVisibleScreenBounds;
        } else if (localWidth + localX > this.fView.getVisibleWidth() + fVisibleScreenBounds) {
            localWidth = this.fView.getVisibleWidth() + fVisibleScreenBounds - localX;
        }
        if (localHeight < -fVisibleScreenBounds && localY + localHeight < -fVisibleScreenBounds) {
            localHeight = -fVisibleScreenBounds;
        } else if (localHeight + localY > this.fView.getVisibleHeight() + fVisibleScreenBounds) {
            localHeight = this.fView.getVisibleHeight() + fVisibleScreenBounds - localY;
        }
        this.fContext.drawRectangle(localX, localY, localWidth, localHeight);
    }

    @Override
    public void drawFocus(int x, int y, int width, int height) {
        int localX = x;
        int localY = y;
        int localWidth = width;
        int localHeight = height;
        IColor bC = this.getBackground();
        IColor fC = this.getForeground();
        if (localWidth < 0) {
            localX += localWidth;
            localWidth = -localWidth;
        }
        if (localHeight < 0) {
            localY += localHeight;
            localHeight = -localHeight;
        }
        localX = Math.round((float)localX * this.fView.getZoomValue());
        localY = Math.round((float)localY * this.fView.getZoomValue());
        localWidth = Math.round((float)localWidth * this.fView.getZoomValue());
        localHeight = Math.round((float)localHeight * this.fView.getZoomValue());
        this.setForeground(SDViewPref.getInstance().getForeGroundColorSelection());
        this.setBackground(SDViewPref.getInstance().getBackGroundColorSelection());
        this.fContext.drawFocus(this.fView.contentsToViewX(localX - 1), this.fView.contentsToViewY(localY - 1), localWidth + 3, localHeight + 3);
        this.setBackground(bC);
        this.setForeground(fC);
    }

    @Override
    public void fillPolygon(int[] points) {
        int len = points.length / 2 * 2;
        int[] localPoint = new int[len];
        int i = 0;
        while (i < len) {
            localPoint[i] = this.fView.contentsToViewX(Math.round((float)points[i] * this.fView.getZoomValue()));
            localPoint[++i] = this.fView.contentsToViewY(Math.round((float)points[i] * this.fView.getZoomValue()));
            ++i;
        }
        if (this.validatePolygonHeight(localPoint) <= 0) {
            return;
        }
        this.fContext.fillPolygon(localPoint);
    }

    @Override
    public void drawPolygon(int[] points) {
        int len = points.length / 2 * 2;
        int[] localPoint = new int[len];
        int i = 0;
        while (i < len) {
            localPoint[i] = this.fView.contentsToViewX(Math.round((float)points[i] * this.fView.getZoomValue()));
            localPoint[++i] = this.fView.contentsToViewY(Math.round((float)points[i] * this.fView.getZoomValue()));
            ++i;
        }
        if (this.validatePolygonHeight(localPoint) <= 0) {
            return;
        }
        this.fContext.drawPolygon(localPoint);
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height) {
        int localX = x;
        int localY = y;
        int localWidth = width;
        int localHeight = height;
        localX = Math.round((float)localX * this.fView.getZoomValue());
        if (localY != this.getContentsY()) {
            localY = Math.round((float)localY * this.fView.getZoomValue());
            localY = this.fView.contentsToViewY(localY) + 1;
        } else {
            localY = 1;
        }
        localWidth = Math.round((float)localWidth * this.fView.getZoomValue()) - 1;
        localHeight = Math.round((float)localHeight * this.fView.getZoomValue()) - 1;
        localX = this.fView.contentsToViewX(localX) + 1;
        if (localX < -fVisibleScreenBounds) {
            localWidth = localWidth + localX + fVisibleScreenBounds;
            localX = -fVisibleScreenBounds;
        }
        if (localY < -fVisibleScreenBounds) {
            localHeight = localHeight + localY + fVisibleScreenBounds;
            localY = -fVisibleScreenBounds;
        }
        if (localWidth < -fVisibleScreenBounds && localX + localWidth < -fVisibleScreenBounds) {
            localWidth = -fVisibleScreenBounds;
        } else if (localWidth + localX > this.fView.getVisibleWidth() + fVisibleScreenBounds) {
            localWidth = this.fView.getVisibleWidth() + fVisibleScreenBounds - localX;
        }
        if (localHeight < -fVisibleScreenBounds && localY + localHeight < -fVisibleScreenBounds) {
            localHeight = -fVisibleScreenBounds;
        } else if (localHeight + localY > this.fView.getVisibleHeight() + fVisibleScreenBounds) {
            localHeight = this.fView.getVisibleHeight() + fVisibleScreenBounds - localY;
        }
        this.fContext.fillRectangle(localX, localY, localWidth, localHeight);
    }

    @Override
    public void fillGradientRectangle(int x, int y, int width, int height, boolean isVertical) {
        int localX = x;
        int localY = y;
        int localWidth = width;
        int localHeight = height;
        localX = Math.round((float)localX * this.fView.getZoomValue());
        localY = Math.round((float)localY * this.fView.getZoomValue());
        localWidth = Math.round((float)localWidth * this.fView.getZoomValue());
        localHeight = Math.round((float)localHeight * this.fView.getZoomValue());
        IColor tempColor = this.fForeground;
        this.setForeground(this.fGradientColor);
        localX = this.fView.contentsToViewX(localX);
        localY = this.fView.contentsToViewY(localY);
        if (localX < -fVisibleScreenBounds) {
            localWidth = localWidth + localX + fVisibleScreenBounds;
            localX = -fVisibleScreenBounds;
        }
        if (localY < -fVisibleScreenBounds) {
            localHeight = localHeight + localY + fVisibleScreenBounds;
            localY = -fVisibleScreenBounds;
        }
        if (localWidth < -fVisibleScreenBounds && localX + localWidth < -fVisibleScreenBounds) {
            localWidth = -fVisibleScreenBounds;
        } else if (localWidth + localX > this.fView.getVisibleWidth() + fVisibleScreenBounds) {
            localWidth = this.fView.getVisibleWidth() + fVisibleScreenBounds - localX;
        }
        if (localHeight < -fVisibleScreenBounds && localY + localHeight < -fVisibleScreenBounds) {
            localHeight = -fVisibleScreenBounds;
        } else if (localHeight + localY > this.fView.getVisibleHeight() + fVisibleScreenBounds) {
            localHeight = this.fView.getVisibleHeight() + fVisibleScreenBounds - localY;
        }
        if (isVertical) {
            this.fContext.fillGradientRectangle(localX, localY, localWidth, localHeight, isVertical);
        } else {
            this.fContext.fillGradientRectangle(localX + localWidth, localY, -localWidth, localHeight + 1, isVertical);
        }
        this.setForeground(tempColor);
    }

    @Override
    public int textExtent(String name) {
        return this.fContext.textExtent((String)name).x;
    }

    @Override
    public void drawText(String string, int x, int y, boolean isTrans) {
        int localX = x;
        int localY = y;
        localX = Math.round((float)localX * this.fView.getZoomValue());
        localY = Math.round((float)localY * this.fView.getZoomValue());
        this.fContext.drawText(string, this.fView.contentsToViewX(localX), this.fView.contentsToViewY(localY), isTrans);
        if (this.fDrawWithFocus) {
            Point r = this.fContext.textExtent(string);
            this.fContext.drawFocus(localX - 1, localY - 1, r.x + 2, r.y + 2);
        }
    }

    @Override
    public void drawText(String string, int x, int y) {
        int localX = x;
        int localY = y;
        localX = Math.round((float)localX * this.fView.getZoomValue());
        localY = Math.round((float)localY * this.fView.getZoomValue());
        this.fContext.drawText(string, this.fView.contentsToViewX(localX), this.fView.contentsToViewY(localY), true);
        if (this.fDrawWithFocus) {
            Point r = this.fContext.textExtent(string);
            this.fContext.drawFocus(localX - 1, localY - 1, r.x + 2, r.y + 2);
        }
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        int localX = x;
        int localY = y;
        int localWidth = width;
        int localHeight = height;
        localX = Math.round((float)localX * this.fView.getZoomValue());
        localY = Math.round((float)localY * this.fView.getZoomValue());
        localWidth = Math.round((float)localWidth * this.fView.getZoomValue());
        localHeight = Math.round((float)localHeight * this.fView.getZoomValue());
        this.fContext.fillOval(this.fView.contentsToViewX(localX), this.fView.contentsToViewY(localY), localWidth, localHeight);
    }

    @Override
    public IColor getBackground() {
        if (this.fBackground != null && this.fBackground.getColor() instanceof Color && !((Color)this.fBackground.getColor()).isDisposed()) {
            return this.fBackground;
        }
        return ColorImpl.getSystemColor(1);
    }

    @Override
    public IColor getForeground() {
        if (this.fForeground != null && this.fForeground.getColor() instanceof Color && !((Color)this.fForeground.getColor()).isDisposed()) {
            return this.fForeground;
        }
        return ColorImpl.getSystemColor(1);
    }

    @Override
    public void setBackground(IColor color) {
        if (color == null) {
            return;
        }
        if (color.getColor() instanceof Color) {
            this.fContext.setBackground((Color)color.getColor());
            this.fBackground = color;
        }
    }

    @Override
    public void setForeground(IColor color) {
        Color c;
        if (color == null) {
            return;
        }
        if (color.getColor() instanceof Color && !(c = (Color)color.getColor()).isDisposed()) {
            this.fContext.setForeground(c);
            this.fForeground = color;
        }
    }

    @Override
    public void setGradientColor(IColor color) {
        if (color == null) {
            return;
        }
        if (color.getColor() instanceof Color) {
            this.fGradientColor = color;
        }
    }

    @Override
    public void setLineWidth(int width) {
        if (this.fView.isPrinting()) {
            this.fContext.setLineWidth(width * 2);
        } else {
            this.fContext.setLineWidth(width);
        }
    }

    @Override
    public int getLineWidth() {
        return this.fContext.getLineWidth();
    }

    protected void localDrawText(String string, int x, int y, boolean isTransparent) {
        Point r = this.fContext.textExtent(string);
        if (!isTransparent) {
            this.fContext.fillRectangle(x, y, r.x, r.y);
        }
        this.fContext.drawText(string, x, y, isTransparent);
        if (this.fDrawWithFocus && string.length() > 1) {
            this.fContext.drawFocus(x - 1, y - 1, r.x + 2, r.y + 2);
        }
    }

    @Override
    public void drawTextTruncatedCentred(String name, int xValue, int yValue, int width, int height, boolean trans) {
        int localX = xValue;
        int localY = yValue;
        int localWidth = width;
        int localHeight = height;
        Point tx = this.fContext.textExtent(name);
        localX = Math.round((float)localX * this.fView.getZoomValue());
        int y = 0;
        if (localY != this.getContentsY()) {
            localY = Math.round((float)localY * this.fView.getZoomValue());
            y = this.fView.contentsToViewY(localY);
        }
        localWidth = Math.round((float)localWidth * this.fView.getZoomValue());
        localHeight = Math.round((float)localHeight * this.fView.getZoomValue());
        int x = this.fView.contentsToViewX(localX);
        if (tx.y > localHeight) {
            return;
        }
        if (y < -fVisibleScreenBounds) {
            localHeight = localHeight + y + fVisibleScreenBounds;
            y = -fVisibleScreenBounds;
        }
        if (localHeight < -fVisibleScreenBounds && y + localHeight < -fVisibleScreenBounds) {
            localHeight = -fVisibleScreenBounds;
        } else if (localHeight + y > this.fView.getVisibleHeight() + fVisibleScreenBounds) {
            localHeight = this.fView.getVisibleHeight() + fVisibleScreenBounds - y;
        }
        if (tx.x <= localWidth) {
            this.localDrawText(name, x + 1 + (localWidth - tx.x) / 2, y + 1 + (localHeight - tx.y) / 2, trans);
        } else {
            String nameToDisplay = name;
            int i = name.length() - 1;
            while (i >= 0 && this.fContext.textExtent((String)nameToDisplay).x >= localWidth) {
                nameToDisplay = name.substring(0, i);
                --i;
            }
            int dotCount = 0;
            int i2 = 1;
            while (i2 <= 3 && nameToDisplay.length() - i2 > 0) {
                ++dotCount;
                ++i2;
            }
            nameToDisplay = nameToDisplay.substring(0, nameToDisplay.length() - dotCount);
            StringBuffer buf = new StringBuffer(nameToDisplay);
            int i3 = 0;
            while (i3 < dotCount) {
                buf.append(".");
                ++i3;
            }
            nameToDisplay = buf.toString();
            this.localDrawText(nameToDisplay, x + 1 + (localWidth - this.fContext.textExtent((String)nameToDisplay).x) / 2, y + 1 + (localHeight - this.fContext.textExtent((String)nameToDisplay).y) / 2, trans);
        }
    }

    @Override
    public void drawTextTruncated(String name, int xValue, int yValue, int width, int height, boolean trans) {
        int localX = xValue;
        int localY = yValue;
        int localWidth = width;
        int localHeight = height;
        localX = Math.round((float)localX * this.fView.getZoomValue());
        localY = Math.round((float)localY * this.fView.getZoomValue());
        localWidth = Math.round((float)localWidth * this.fView.getZoomValue());
        localHeight = Math.round((float)localHeight * this.fView.getZoomValue());
        int x = this.fView.contentsToViewX(localX);
        int y = this.fView.contentsToViewY(localY);
        if (this.fContext.textExtent((String)name).x <= localWidth) {
            this.localDrawText(name, x + 1, y + 1 + localHeight, trans);
        } else {
            String nameToDisplay = name;
            int i = name.length() - 1;
            while (i >= 0 && this.fContext.textExtent((String)nameToDisplay).x >= localWidth) {
                nameToDisplay = name.substring(0, i);
                --i;
            }
            int dotCount = 0;
            int i2 = 1;
            while (i2 <= 3 && nameToDisplay.length() - i2 > 0) {
                ++dotCount;
                ++i2;
            }
            nameToDisplay = nameToDisplay.substring(0, nameToDisplay.length() - dotCount);
            StringBuffer buf = new StringBuffer(nameToDisplay);
            int i3 = 0;
            while (i3 < dotCount) {
                buf.append(".");
                ++i3;
            }
            nameToDisplay = buf.toString();
            this.localDrawText(nameToDisplay, x + 1, y + 1 + localHeight, trans);
        }
    }

    @Override
    public void drawImage(IImage image, int xValue, int yValue, int maxWith, int maxHeight) {
        int localX = xValue;
        int localY = yValue;
        Image img = null;
        if (image == null || !(image.getImage() instanceof Image)) {
            localX = Math.round((float)localX * this.fView.getZoomValue());
            localY = Math.round((float)localY * this.fView.getZoomValue());
            int x = this.fView.contentsToViewX(localX);
            int y = this.fView.contentsToViewY(localY);
            float tempZoom = this.fView.getZoomValue();
            int width = Math.round((float)maxWith * tempZoom);
            int height = Math.round((float)maxHeight * tempZoom);
            this.fContext.setBackground(this.fView.getDisplay().getSystemColor(3));
            this.fContext.fillRectangle(x, y, width, height);
            return;
        }
        img = (Image)image.getImage();
        localX = Math.round((float)localX * this.fView.getZoomValue());
        localY = Math.round((float)localY * this.fView.getZoomValue());
        int x = this.fView.contentsToViewX(localX);
        int y = this.fView.contentsToViewY(localY);
        Rectangle b = ((Image)image.getImage()).getBounds();
        int width = b.width;
        int height = b.height;
        if (width > maxWith) {
            width = maxWith;
        }
        if (height > maxHeight) {
            height = maxHeight;
        }
        float tempZoom = this.fView.getZoomValue();
        width = Math.round((float)width * tempZoom);
        height = Math.round((float)height * tempZoom);
        if (this.fView.isPrinting() && width > 0 && height > 0) {
            Image dbuffer = new Image((Device)this.fView.getDisplay(), width, height);
            GC tempgc = new GC((Drawable)dbuffer);
            tempgc.drawImage(img, 0, 0, b.width, b.height, 0, 0, width, height);
            Image dbuffer2 = new Image((Device)this.fView.getDisplay(), dbuffer.getImageData());
            this.fContext.drawImage(dbuffer2, x, y);
            tempgc.dispose();
            dbuffer.dispose();
            dbuffer2.dispose();
        } else {
            this.fContext.drawImage(img, 0, 0, b.width, b.height, x, y, width, height);
        }
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int endAngle) {
        int localX = x;
        int localY = y;
        int localWidth = width;
        int localHeight = height;
        localX = Math.round((float)localX * this.fView.getZoomValue());
        localY = Math.round((float)localY * this.fView.getZoomValue());
        localWidth = Math.round((float)localWidth * this.fView.getZoomValue());
        localHeight = Math.round((float)localHeight * this.fView.getZoomValue());
        if (localWidth == 0 || localHeight == 0 || endAngle == 0) {
            return;
        }
        this.fContext.drawArc(this.fView.contentsToViewX(localX), this.fView.contentsToViewY(localY), localWidth, localHeight, startAngle, endAngle);
    }

    @Override
    public void setFont(IFont font) {
        if (font.getFont() != null && ((Font)font.getFont()).getFontData().length > 0) {
            int h;
            FontData fontData = ((Font)font.getFont()).getFontData()[0];
            if ((SDViewPref.getInstance().fontLinked() || this.fView.isPrinting()) && (h = Math.round((float)fontData.getHeight() * this.fView.getZoomValue())) > 0) {
                fontData.setHeight(h);
            }
            if (this.fTempFont != null) {
                this.fTempFont.dispose();
            }
            this.fTempFont = new Font((Device)Display.getCurrent(), fontData);
            this.fContext.setFont(this.fTempFont);
        }
    }

    @Override
    public int getFontHeight(IFont font) {
        if (font.getFont() != null && font.getFont() instanceof Font && ((Font)font.getFont()).getFontData().length > 0) {
            Font toRestore = this.fContext.getFont();
            this.fContext.setFont((Font)font.getFont());
            int height = this.fContext.textExtent((String)"lp").y;
            this.fContext.setFont(toRestore);
            return height;
        }
        return 0;
    }

    protected int getCurrentFontHeight() {
        return this.fContext.textExtent((String)"lp").y;
    }

    @Override
    public int getFontWidth(IFont font) {
        if (font.getFont() != null && font.getFont() instanceof Font) {
            Font toRestore = this.fContext.getFont();
            this.fContext.setFont((Font)font.getFont());
            int width = this.fContext.getFontMetrics().getAverageCharWidth();
            this.fContext.setFont(toRestore);
            return width;
        }
        return 0;
    }

    public void dispose() {
        if (this.fTempFont != null) {
            this.fTempFont.dispose();
        }
        this.fTempFont = null;
        if (this.fContext != null) {
            this.fContext.dispose();
        }
        this.fContext = null;
    }

    @Override
    public float getZoom() {
        if (this.fView != null) {
            return this.fView.getZoomValue();
        }
        return 1.0f;
    }

    @Override
    public int getLineDotStyle() {
        return 3;
    }

    @Override
    public int getLineDashStyle() {
        return 2;
    }

    @Override
    public int getLineSolidStyle() {
        return 1;
    }

    @Override
    public IColor createColor(int r, int g, int b) {
        return new ColorImpl(Display.getDefault(), r, g, b);
    }

    @Override
    public void setDrawTextWithFocusStyle(boolean focus) {
        this.fDrawWithFocus = focus;
    }

    protected static int getVscreenBounds() {
        return fVisibleScreenBounds;
    }

    protected static void setVscreenBounds(int vBounds) {
        fVisibleScreenBounds = vBounds;
    }

    protected GC getGc() {
        return this.fContext;
    }

    protected SDWidget getSDWidget() {
        return this.fView;
    }

    protected IColor setGradientColor() {
        return this.fGradientColor;
    }

    private int validatePolygonHeight(int[] localPoint) {
        int i = 1;
        int max = 0;
        int min = Integer.MAX_VALUE;
        while (i < localPoint.length) {
            max = Math.abs(localPoint[i]) > Math.abs(max) ? localPoint[i] : max;
            min = Math.abs(localPoint[i]) < Math.abs(min) ? localPoint[i] : min;
            i += 2;
        }
        int height = max - min;
        if (min < -fVisibleScreenBounds) {
            height = height + min + fVisibleScreenBounds;
            min = -fVisibleScreenBounds;
        }
        if (height < -fVisibleScreenBounds && min + height < -fVisibleScreenBounds) {
            height = -fVisibleScreenBounds;
        } else if (height + min > this.fView.getVisibleHeight() + fVisibleScreenBounds) {
            height = this.fView.getVisibleHeight() + fVisibleScreenBounds - min;
        }
        return height;
    }
}

