/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.statesystem;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.statesystem.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TmfStateSystemExplorer
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.ssview";
    private static final String emptyString = "";
    private static final int ATTRIBUTE_NAME_COL = 0;
    private static final int QUARK_COL = 1;
    private static final int VALUE_COL = 2;
    private static final int START_TIME_COL = 3;
    private static final int END_TIME_COL = 4;
    private static final int ATTRIBUTE_FULLPATH_COL = 5;
    private ITmfTrace fTrace;
    private Tree fTree;
    private volatile long fCurrentTimestamp = -1L;

    public TmfStateSystemExplorer() {
        super(ID);
    }

    public void createPartControl(Composite parent) {
        this.fTree = new Tree(parent, 0);
        TreeColumn nameCol = new TreeColumn(this.fTree, 0, 0);
        TreeColumn quarkCol = new TreeColumn(this.fTree, 0, 1);
        TreeColumn valueCol = new TreeColumn(this.fTree, 0, 2);
        TreeColumn startCol = new TreeColumn(this.fTree, 0, 3);
        TreeColumn endCol = new TreeColumn(this.fTree, 0, 4);
        TreeColumn pathCol = new TreeColumn(this.fTree, 0, 5);
        nameCol.setText(Messages.TreeNodeColumnLabel);
        quarkCol.setText(Messages.QuarkColumnLabel);
        valueCol.setText(Messages.ValueColumnLabel);
        startCol.setText(Messages.StartTimeColumLabel);
        endCol.setText(Messages.EndTimeColumLabel);
        pathCol.setText(Messages.AttributePathColumnLabel);
        this.fTree.setItemCount(0);
        this.fTree.setHeaderVisible(true);
        nameCol.pack();
        valueCol.pack();
        this.fTree.addListener(17, new Listener(){

            public void handleEvent(Event e) {
                TreeItem item = (TreeItem)e.item;
                item.setExpanded(true);
                TmfStateSystemExplorer.this.updateTable();
            }
        });
        ITmfTrace trace = this.getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
    }

    private synchronized void createTable() {
        if (this.fTrace == null) {
            return;
        }
        this.fTree.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TmfStateSystemExplorer.this.fTree.setItemCount(0);
            }
        });
        ITmfTrace[] iTmfTraceArray = TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace);
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            final ITmfTrace currentTrace = iTmfTraceArray[n2];
            final Map sss = currentTrace.getStateSystems();
            final LinkedHashMap<String, List> fullStates = new LinkedHashMap<String, List>();
            for (Map.Entry entry : sss.entrySet()) {
                String ssName = (String)entry.getKey();
                ITmfStateSystem ss = (ITmfStateSystem)entry.getValue();
                ss.waitUntilBuilt();
                long startTime = ss.getStartTime();
                try {
                    fullStates.put(ssName, ss.queryFullState(startTime));
                }
                catch (TimeRangeException timeRangeException) {
                    throw new RuntimeException();
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {
                    return;
                }
            }
            this.fTree.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TreeItem traceRoot = new TreeItem(TmfStateSystemExplorer.this.fTree, 0);
                    traceRoot.setText(0, currentTrace.getName());
                    for (Map.Entry entry : sss.entrySet()) {
                        String ssName = (String)entry.getKey();
                        ITmfStateSystem ss = (ITmfStateSystem)entry.getValue();
                        List fullState = (List)fullStates.get(ssName);
                        TreeItem item = new TreeItem(traceRoot, 0);
                        item.setText(0, ssName);
                        TmfStateSystemExplorer.this.addChildren(ss, fullState, -1, item);
                    }
                    TreeItem[] treeItemArray = TmfStateSystemExplorer.this.fTree.getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        item.setExpanded(true);
                        ++n2;
                    }
                    TmfStateSystemExplorer.this.packColumns();
                }
            });
            ++n2;
        }
    }

    private void addChildren(ITmfStateSystem ss, List<ITmfStateInterval> fullState, int rootQuark, TreeItem root) {
        try {
            Iterator iterator = ss.getSubAttributes(rootQuark, false).iterator();
            while (iterator.hasNext()) {
                int quark = (Integer)iterator.next();
                TreeItem subItem = new TreeItem(root, 0);
                subItem.setText(0, ss.getAttributeName(quark));
                subItem.setText(1, String.valueOf(quark));
                subItem.setText(5, ss.getFullAttributePath(quark));
                ITmfStateInterval interval = fullState.get(quark);
                TmfStateSystemExplorer.populateColumns(subItem, interval);
                this.addChildren(ss, fullState, quark, subItem);
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new RuntimeException();
        }
    }

    private synchronized void updateTable() {
        ITmfTrace[] traces = TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace);
        long ts = this.fCurrentTimestamp;
        int traceNb = 0;
        while (traceNb < traces.length) {
            Map sss = traces[traceNb].getStateSystems();
            int ssNb = 0;
            for (Map.Entry entry : sss.entrySet()) {
                final ITmfStateSystem ss = (ITmfStateSystem)entry.getValue();
                final int traceNb1 = traceNb;
                final int ssNb1 = ssNb;
                ts = ts == -1L ? ss.getStartTime() : ts;
                try {
                    final List fullState = ss.queryFullState(ts);
                    this.fTree.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeItem traceItem = TmfStateSystemExplorer.this.fTree.getItem(traceNb1);
                            TreeItem item = traceItem.getItem(ssNb1);
                            item.setText(2, TmfStateSystemExplorer.emptyString);
                            TmfStateSystemExplorer.this.updateChildren(ss, fullState, -1, item);
                        }
                    });
                }
                catch (TimeRangeException timeRangeException) {
                    this.fTree.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeItem traceItem = TmfStateSystemExplorer.this.fTree.getItem(traceNb1);
                            TreeItem item = traceItem.getItem(ssNb1);
                            TmfStateSystemExplorer.this.markOutOfRange(item);
                        }
                    });
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {
                    return;
                }
                ++ssNb;
            }
            ++traceNb;
        }
    }

    private void updateChildren(ITmfStateSystem ss, List<ITmfStateInterval> state, int root_quark, TreeItem root) {
        try {
            TreeItem[] treeItemArray = root.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                int quark = ss.getQuarkRelative(root_quark, new String[]{item.getText(0)});
                ITmfStateInterval interval = state.get(quark);
                TmfStateSystemExplorer.populateColumns(item, interval);
                this.updateChildren(ss, state, quark, item);
                ++n2;
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new RuntimeException();
        }
    }

    private static void populateColumns(TreeItem item, ITmfStateInterval interval) {
        try {
            ITmfStateValue state = interval.getStateValue();
            switch (state.getType()) {
                case INTEGER: {
                    item.setText(2, String.valueOf(state.unboxInt()));
                    break;
                }
                case LONG: {
                    item.setText(2, String.valueOf(state.unboxLong()));
                    break;
                }
                case STRING: {
                    item.setText(2, state.unboxStr());
                    break;
                }
                default: {
                    item.setText(2, emptyString);
                }
            }
            TmfTimestamp startTime = new TmfTimestamp(interval.getStartTime(), -9);
            item.setText(3, startTime.toString());
            TmfTimestamp endTime = new TmfTimestamp(interval.getEndTime(), -9);
            item.setText(4, endTime.toString());
        }
        catch (StateValueTypeException stateValueTypeException) {
            throw new RuntimeException();
        }
    }

    private void markOutOfRange(TreeItem root) {
        root.setText(2, Messages.OutOfRangeMsg);
        root.setText(3, emptyString);
        root.setText(4, emptyString);
        TreeItem[] treeItemArray = root.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.markOutOfRange(item);
            ++n2;
        }
    }

    private void packColumns() {
        TreeColumn[] treeColumnArray = this.fTree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.fTrace = signal.getTrace();
        this.loadTrace();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        if (trace != this.fTrace) {
            this.fTrace = trace;
            this.loadTrace();
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            this.fTrace = null;
            this.fTree.setItemCount(0);
        }
    }

    @TmfSignalHandler
    public void currentTimeUpdated(final TmfTimeSynchSignal signal) {
        Thread thread = new Thread("State system visualizer update"){

            @Override
            public void run() {
                ITmfTimestamp currentTime = signal.getCurrentTime().normalize(0L, -9);
                TmfStateSystemExplorer.this.fCurrentTimestamp = currentTime.getValue();
                TmfStateSystemExplorer.this.updateTable();
            }
        };
        thread.start();
    }

    private void loadTrace() {
        Thread thread = new Thread("State system visualizer construction"){

            @Override
            public void run() {
                TmfStateSystemExplorer.this.createTable();
            }
        };
        thread.start();
    }
}

