/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import org.eclipse.linuxtools.tmf.ui.views.histogram.Histogram;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramView;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramZoom;
import org.eclipse.swt.widgets.Composite;

public class TimeRangeHistogram
extends Histogram {
    private HistogramZoom fZoom = new HistogramZoom(this, this.getStartTime(), this.getTimeLimit());

    public TimeRangeHistogram(HistogramView view, Composite parent) {
        super(view, parent);
        this.addMouseWheelListener(this.fZoom);
    }

    @Override
    public void updateTimeRange(long startTime, long endTime) {
        ((HistogramView)this.fParentView).updateTimeRange(startTime, endTime);
    }

    @Override
    public synchronized void clear() {
        if (this.fZoom != null) {
            this.fZoom.setFullRange(0L, 0L);
            this.fZoom.setNewRange(0L, 0L);
        }
        super.clear();
    }

    public synchronized void setTimeRange(long startTime, long duration) {
        this.fZoom.setNewRange(startTime, duration);
        if (this.getDataModel().getNbEvents() == 0L) {
            this.getDataModel().setTimeRange(startTime, startTime + duration);
        }
    }

    public void setFullRange(long startTime, long endTime) {
        long currentFirstEvent = this.getStartTime();
        this.fZoom.setFullRange(currentFirstEvent == 0L ? startTime : currentFirstEvent, endTime);
    }
}

