/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import org.eclipse.linuxtools.tmf.ui.views.histogram.Histogram;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramView;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramZoom;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class FullTraceHistogram
extends Histogram
implements MouseMoveListener {
    private final Color fTimeRangeColor = new Color((Device)Display.getCurrent(), 255, 128, 0);
    private final HistogramZoom fZoom = new HistogramZoom(this, this.getStartTime(), this.getTimeLimit());
    private long fRangeStartTime = 0L;
    private long fRangeDuration;
    private boolean fMouseDown;
    private int fStartPosition;

    public FullTraceHistogram(HistogramView view, Composite parent) {
        super(view, parent);
        this.addMouseWheelListener(this.fZoom);
        this.fCanvas.addMouseMoveListener((MouseMoveListener)this);
    }

    @Override
    public void dispose() {
        this.fTimeRangeColor.dispose();
        super.dispose();
    }

    @Override
    public void clear() {
        this.fRangeStartTime = 0L;
        this.fRangeDuration = 0L;
        if (this.fZoom != null) {
            this.fZoom.setFullRange(0L, 0L);
            this.fZoom.setNewRange(0L, 0L);
        }
        super.clear();
    }

    public void setFullRange(long startTime, long endTime) {
        this.fZoom.setFullRange(startTime, endTime);
    }

    public void setTimeRange(long startTime, long duration) {
        this.fRangeStartTime = startTime;
        this.fRangeDuration = duration;
        this.fZoom.setNewRange(this.fRangeStartTime, this.fRangeDuration);
        this.fDataModel.complete();
    }

    @Override
    public void updateTimeRange(long startTime, long endTime) {
        ((HistogramView)this.fParentView).updateTimeRange(startTime, endTime);
    }

    @Override
    public void mouseDown(MouseEvent event) {
        this.fMouseDown = true;
        this.fStartPosition = event.x;
    }

    @Override
    public void mouseUp(MouseEvent event) {
        if (this.fMouseDown) {
            this.fMouseDown = false;
            if (event.x == this.fStartPosition) {
                super.mouseDown(event);
                return;
            }
            ((HistogramView)this.fParentView).updateTimeRange(this.fRangeStartTime, this.fRangeStartTime + this.fRangeDuration);
        }
    }

    public void mouseMove(MouseEvent event) {
        if (this.fMouseDown) {
            long newEnd;
            int nbBuckets = event.x - this.fStartPosition;
            long delta = (long)nbBuckets * this.fScaledData.fBucketDuration;
            long newStart = this.fZoom.getStartTime() + delta;
            if (newStart < this.getStartTime()) {
                newStart = this.getStartTime();
            }
            if ((newEnd = newStart + this.fZoom.getDuration()) > this.getEndTime()) {
                newEnd = this.getEndTime();
                newStart = newEnd - this.fZoom.getDuration();
            }
            this.fRangeStartTime = newStart;
            this.fDataModel.complete();
        }
    }

    @Override
    public void paintControl(PaintEvent event) {
        super.paintControl(event);
        Image image = (Image)this.fCanvas.getData("double-buffer-image");
        assert (image != null);
        Image rangeRectangleImage = new Image(image.getDevice(), image, 0);
        GC rangeWindowGC = new GC((Drawable)rangeRectangleImage);
        if (this.fScaledData != null && this.fRangeStartTime != 0L) {
            this.drawTimeRangeWindow(rangeWindowGC);
        }
        event.gc.drawImage(rangeRectangleImage, 0, 0);
        rangeWindowGC.dispose();
        rangeRectangleImage.dispose();
    }

    private void drawTimeRangeWindow(GC imageGC) {
        long bucketSpan = Math.max(this.fScaledData.fBucketDuration, 1L);
        int rangeWidth = (int)(this.fRangeDuration / bucketSpan);
        int left = (int)((this.fRangeStartTime - this.fDataModel.getFirstBucketTime()) / bucketSpan);
        int right = left + rangeWidth;
        int center = (left + right) / 2;
        int height = this.fCanvas.getSize().y;
        imageGC.setForeground(this.fTimeRangeColor);
        imageGC.setLineWidth(1);
        imageGC.setLineStyle(1);
        imageGC.drawRoundRectangle(left, 0, rangeWidth, height - 1, 15, 15);
        imageGC.setBackground(this.fTimeRangeColor);
        imageGC.setAlpha(35);
        imageGC.fillRoundRectangle(left + 1, 1, rangeWidth - 1, height - 2, 15, 15);
        imageGC.setAlpha(255);
        imageGC.setForeground(this.fTimeRangeColor);
        imageGC.setLineWidth(1);
        imageGC.setLineStyle(1);
        int chHalfWidth = (rangeWidth < 60 ? rangeWidth * 2 / 3 : 40) / 2;
        imageGC.drawLine(center - chHalfWidth, height / 2, center + chHalfWidth, height / 2);
        imageGC.drawLine(center, height / 2 - chHalfWidth, center, height / 2 + chHalfWidth);
    }

    public HistogramZoom getZoom() {
        return this.fZoom;
    }
}

