/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.linuxtools.tmf.core.component.ITmfComponent;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.linuxtools.tmf.ui.views.PinTmfViewAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.ViewPart;

public abstract class TmfView
extends ViewPart
implements ITmfComponent {
    private final String fName;
    protected PinTmfViewAction fPinAction;
    protected final TmfTraceManager fTraceManager;

    public TmfView(String viewName) {
        this.fName = viewName;
        this.fTraceManager = TmfTraceManager.getInstance();
        TmfSignalManager.register((Object)((Object)this));
    }

    public void dispose() {
        TmfSignalManager.deregister((Object)((Object)this));
        super.dispose();
    }

    public String getName() {
        return this.fName;
    }

    public void broadcast(TmfSignal signal) {
        TmfSignalManager.dispatchSignal((TmfSignal)signal);
    }

    public boolean isPinned() {
        return this.fPinAction != null && this.fPinAction.isChecked();
    }

    protected void contributePinActionToToolBar() {
        if (this.fPinAction == null) {
            this.fPinAction = new PinTmfViewAction();
            IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
            toolBarManager.add((IContributionItem)new Separator("additions"));
            toolBarManager.add((IAction)this.fPinAction);
        }
    }

    public ITmfTrace getActiveTrace() {
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (editor instanceof ITmfTraceEditor) {
            ITmfTrace trace = ((ITmfTraceEditor)editor).getTrace();
            return trace;
        }
        return null;
    }
}

