/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.properties;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.linuxtools.tmf.ui.properties.TmfTimePreferences;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TmfTimestampFormatPage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener,
IPropertyChangeListener {
    private static final String[][] fDateTimeFormats = new String[][]{{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss"}, {"yy-MM-dd HH:mm:ss", "yy-MM-dd HH:mm:ss"}, {"MM-dd HH:mm:ss", "MM-dd HH:mm:ss"}, {"dd HH:mm:ss", "dd HH:mm:ss"}, {"DDD HH:mm:ss", "DDD HH:mm:ss"}, {"HH:mm:ss", "HH:mm:ss"}, {"mm:ss", "mm:ss"}, {"ss", "ss"}, {"TTT (secs in epoch)", "TTT"}, {"(none)", ""}};
    private static final String[][] fSubSecondFormats = new String[][]{{"SSS (ms)", "SSS"}, {"SSS CCC (\u00b5s)", "SSS CCC"}, {"SSS CCC NNN (ns)", "SSS CCC NNN"}};
    private static final String[][] fDateTimeDelimiters = new String[][]{{"(none)", ""}, {"  (space)", " "}, {", (comma)", ","}, {"- (dash)", "-"}, {"_ (underline)", "_"}, {": (colon)", ":"}, {"; (semicolon)", ";"}, {"/ (slash)", "/"}, {"\" (dbl-quote)", "\""}};
    private static final String[][] fSubSecondDelimiters = new String[][]{{"(none)", ""}, {"  (space)", " "}, {", (comma)", ","}, {"- (dash)", "-"}, {"_ (underline)", "_"}, {": (colon)", ":"}, {"; (semicolon)", ";"}, {"/ (slash)", "/"}, {"\" (dbl-quote)", "\""}, {". (period)", "."}};
    private Composite fPage;
    private IPreferenceStore fPreferenceStore = TmfTimePreferences.getPreferenceStore();
    private TmfTimePreferences fTimePreference = TmfTimePreferences.getInstance();
    private Composite fExampleSection;
    private Text fPatternDisplay;
    private Text fExampleDisplay;
    private String fTimePattern;
    private RadioGroupFieldEditor fDateTimeFields;
    private RadioGroupFieldEditor fSSecFields;
    private RadioGroupFieldEditor fDateFieldDelim;
    private RadioGroupFieldEditor fTimeFieldDelim;
    private RadioGroupFieldEditor fSSecFieldDelim;
    private String fProperty;
    private String fChangedProperty;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.fPage = new Composite(parent, 0);
        this.fPage.setLayout((Layout)new GridLayout());
        this.fPage.setLayoutData((Object)new GridData(1808));
        this.fExampleSection = new Composite(this.fPage, 0);
        this.fExampleSection.setLayout((Layout)new GridLayout(2, false));
        this.fExampleSection.setLayoutData((Object)new GridData(1808));
        Label patternLabel = new Label(this.fExampleSection, 256);
        patternLabel.setText("Current Format: ");
        this.fPatternDisplay = new Text(this.fExampleSection, 2056);
        this.fPatternDisplay.setLayoutData((Object)new GridData(768));
        Label exampleLabel = new Label(this.fExampleSection, 0);
        exampleLabel.setText("Sample Display: ");
        this.fExampleDisplay = new Text(this.fExampleSection, 2056);
        this.fExampleDisplay.setLayoutData((Object)new GridData(768));
        Label separator = new Label(this.fPage, 290);
        separator.setLayoutData((Object)new GridData(784));
        this.fDateTimeFields = new RadioGroupFieldEditor("org.eclipse.linuxtools.tmf.ui.prefs.time.format.datime", "Date and Time format", 3, fDateTimeFormats, this.fPage, true);
        this.fDateTimeFields.setPreferenceStore(this.fPreferenceStore);
        this.fDateTimeFields.load();
        this.fDateTimeFields.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fSSecFields = new RadioGroupFieldEditor("org.eclipse.linuxtools.tmf.ui.prefs.time.format.subsec", "Sub-second format", 3, fSubSecondFormats, this.fPage, true);
        this.fSSecFields.setPreferenceStore(this.fPreferenceStore);
        this.fSSecFields.load();
        this.fSSecFields.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fDateFieldDelim = new RadioGroupFieldEditor("org.eclipse.linuxtools.tmf.ui.prefs.time.format.date.delimiter", "Date delimiter", 5, fDateTimeDelimiters, this.fPage, true);
        this.fDateFieldDelim.setPreferenceStore(this.fPreferenceStore);
        this.fDateFieldDelim.load();
        this.fDateFieldDelim.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fTimeFieldDelim = new RadioGroupFieldEditor("org.eclipse.linuxtools.tmf.ui.prefs.time.format.time.delimiter", "Time delimiter", 5, fDateTimeDelimiters, this.fPage, true);
        this.fTimeFieldDelim.setPreferenceStore(this.fPreferenceStore);
        this.fTimeFieldDelim.load();
        this.fTimeFieldDelim.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fSSecFieldDelim = new RadioGroupFieldEditor("org.eclipse.linuxtools.tmf.ui.prefs.time.format.ssec.delimiter", "Sub-Second Delimiter", 5, fSubSecondDelimiters, this.fPage, true);
        this.fSSecFieldDelim.setPreferenceStore(this.fPreferenceStore);
        this.fSSecFieldDelim.load();
        this.fSSecFieldDelim.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fTimePreference.initPatterns();
        this.refresh();
        return this.fPage;
    }

    protected void performDefaults() {
        this.fDateTimeFields.loadDefault();
        this.fSSecFields.loadDefault();
        this.fDateFieldDelim.loadDefault();
        this.fTimeFieldDelim.loadDefault();
        this.fSSecFieldDelim.loadDefault();
        this.fTimePreference.setDefaults();
        this.fTimePattern = TmfTimePreferences.getTimePattern();
        this.displayExample();
    }

    protected void performApply() {
        this.fDateTimeFields.store();
        this.fSSecFields.store();
        this.fDateFieldDelim.store();
        this.fTimeFieldDelim.store();
        this.fSSecFieldDelim.store();
        TmfTimePreferences.setTimePattern(this.fTimePattern);
        this.displayExample();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        Object value = event.getNewValue();
        if (source instanceof RadioGroupFieldEditor && value instanceof String && (!value.equals(this.fChangedProperty) || source != this.fProperty)) {
            this.fProperty = ((RadioGroupFieldEditor)source).getPreferenceName();
            this.fChangedProperty = (String)value;
            this.refresh();
        }
    }

    private void refresh() {
        this.updatePatterns();
        this.displayExample();
    }

    void updatePatterns() {
        if ("org.eclipse.linuxtools.tmf.ui.prefs.time.format.datime".equals(this.fProperty)) {
            this.fTimePreference.setDateTimeFormat(this.fChangedProperty);
        } else if ("org.eclipse.linuxtools.tmf.ui.prefs.time.format.subsec".equals(this.fProperty)) {
            this.fTimePreference.setSSecFormat(this.fChangedProperty);
        } else if ("org.eclipse.linuxtools.tmf.ui.prefs.time.format.date.delimiter".equals(this.fProperty)) {
            this.fTimePreference.setDateFieldSep(this.fChangedProperty);
        } else if ("org.eclipse.linuxtools.tmf.ui.prefs.time.format.time.delimiter".equals(this.fProperty)) {
            this.fTimePreference.setTimeFieldSep(this.fChangedProperty);
        } else if ("org.eclipse.linuxtools.tmf.ui.prefs.time.format.ssec.delimiter".equals(this.fProperty)) {
            this.fTimePreference.setSSecFieldSep(this.fChangedProperty);
        }
        this.fTimePreference.updatePatterns();
        this.fTimePattern = TmfTimePreferences.getTimePattern();
    }

    private void displayExample() {
        long ts = 1332170682500677380L;
        this.fPatternDisplay.setText(this.fTimePattern);
        this.fPatternDisplay.redraw();
        this.fExampleDisplay.setText(new TmfTimestampFormat(this.fTimePattern).format(ts));
        this.fExampleDisplay.redraw();
    }
}

