/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.BatchImportTraceWizard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardResourceImportPage;

abstract class AbstractImportTraceWizardPage
extends WizardResourceImportPage {
    protected static final String BATCH_IMPORT_WIZARD_PAGE = "BatchImportWizardPage";
    protected IFolder fTargetFolder;
    protected IProject fProject;
    private BatchImportTraceWizard fBatchImportTraceWizard;

    protected AbstractImportTraceWizardPage(String name, IStructuredSelection selection) {
        super(name, selection);
    }

    public AbstractImportTraceWizardPage(IWorkbench workbench, IStructuredSelection selection) {
        this(BATCH_IMPORT_WIZARD_PAGE, selection);
        this.setTitle(null);
        this.setDescription(null);
        IFolder traceFolder = null;
        Object element = selection.getFirstElement();
        if (element instanceof TmfTraceFolder) {
            TmfTraceFolder tmfTraceFolder = (TmfTraceFolder)element;
            this.fProject = tmfTraceFolder.getProject().getResource();
            traceFolder = tmfTraceFolder.getResource();
        } else if (element instanceof IProject) {
            IProject project = (IProject)element;
            try {
                if (project.hasNature("org.eclipse.linuxtools.tmf.project.nature")) {
                    traceFolder = (IFolder)project.findMember("Traces");
                }
            }
            catch (CoreException coreException) {}
        }
        if (traceFolder != null) {
            this.fTargetFolder = traceFolder;
            String path = traceFolder.getFullPath().toOSString();
            this.setContainerFieldValue(path);
        }
    }

    public BatchImportTraceWizard getBatchWizard() {
        return this.fBatchImportTraceWizard;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setFont(parent.getFont());
        GridData layoutData = new GridData();
        parent.getShell().setLayoutData((Object)layoutData);
        parent.getShell().redraw();
        this.setControl((Control)composite);
        parent.getShell().setMinimumSize(new Point(525, 400));
        this.fBatchImportTraceWizard = (BatchImportTraceWizard)this.getWizard();
    }

    protected void createSourceGroup(Composite parent) {
    }

    protected ITreeContentProvider getFileProvider() {
        return null;
    }

    protected ITreeContentProvider getFolderProvider() {
        return null;
    }
}

