/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statevalue;

import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.IntegerStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.LongStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.NullStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.StringStateValue;

public abstract class TmfStateValue
implements ITmfStateValue {
    private static TmfStateValue nullValue = new NullStateValue();

    protected abstract Object getValue();

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TmfStateValue)) {
            return false;
        }
        if (this.getType() != ((TmfStateValue)other).getType()) {
            return false;
        }
        if (this.isNull()) {
            return true;
        }
        return this.getValue().equals(((TmfStateValue)other).getValue());
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.getValue().hashCode();
    }

    public static final TmfStateValue nullValue() {
        return nullValue;
    }

    public static TmfStateValue newValueInt(int intValue) {
        if (intValue == -1) {
            return TmfStateValue.nullValue();
        }
        return new IntegerStateValue(intValue);
    }

    public static TmfStateValue newValueString(String strValue) {
        if (strValue == null) {
            return TmfStateValue.nullValue();
        }
        return new StringStateValue(strValue);
    }

    public static TmfStateValue newValueLong(long longValue) {
        if (longValue == -1L) {
            return TmfStateValue.nullValue();
        }
        return new LongStateValue(longValue);
    }

    @Override
    public int unboxInt() throws StateValueTypeException {
        if (this.isNull()) {
            return -1;
        }
        if (this.getType() != ITmfStateValue.Type.INTEGER) {
            throw new StateValueTypeException();
        }
        return (Integer)this.getValue();
    }

    @Override
    public String unboxStr() throws StateValueTypeException {
        if (this.isNull()) {
            return "nullValue";
        }
        if (this.getType() != ITmfStateValue.Type.STRING) {
            throw new StateValueTypeException();
        }
        return (String)this.getValue();
    }

    @Override
    public long unboxLong() throws StateValueTypeException {
        if (this.isNull()) {
            return -1L;
        }
        if (this.getType() != ITmfStateValue.Type.LONG) {
            throw new StateValueTypeException();
        }
        return (Long)this.getValue();
    }
}

