/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.signal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.internal.tmf.core.TmfCoreTracer;
import org.eclipse.linuxtools.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalTracer;
import org.eclipse.linuxtools.tmf.core.signal.TmfStartSynchSignal;

public class TmfSignalManager {
    private static Map<Object, Method[]> fListeners = new HashMap<Object, Method[]>();
    private static Map<Object, Method[]> fVIPListeners = new HashMap<Object, Method[]>();
    private static boolean fTraceIsActive = false;
    private static TmfSignalTracer fSignalTracer;
    static int fSignalId;

    static {
        if (fTraceIsActive) {
            fSignalTracer = TmfSignalTracer.getInstance();
            TmfSignalManager.register(fSignalTracer);
        }
        fSignalId = 0;
    }

    public static synchronized void register(Object listener) {
        TmfSignalManager.deregister(listener);
        Method[] methods = TmfSignalManager.getSignalHandlerMethods(listener);
        if (methods.length > 0) {
            fListeners.put(listener, methods);
        }
    }

    public static synchronized void registerVIP(Object listener) {
        TmfSignalManager.deregister(listener);
        Method[] methods = TmfSignalManager.getSignalHandlerMethods(listener);
        if (methods.length > 0) {
            fVIPListeners.put(listener, methods);
        }
    }

    public static synchronized void deregister(Object listener) {
        fVIPListeners.remove(listener);
        fListeners.remove(listener);
    }

    private static Method[] getSignalHandlerMethods(Object listener) {
        Method[] methods;
        ArrayList<Method> handlers = new ArrayList<Method>();
        Method[] methodArray = methods = listener.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(TmfSignalHandler.class)) {
                handlers.add(method);
            }
            ++n2;
        }
        return handlers.toArray(new Method[handlers.size()]);
    }

    public static synchronized void dispatchSignal(TmfSignal signal) {
        int signalId = fSignalId++;
        TmfSignalManager.sendSignal(new TmfStartSynchSignal(signalId));
        signal.setReference(signalId);
        TmfSignalManager.sendSignal(signal);
        TmfSignalManager.sendSignal(new TmfEndSynchSignal(signalId));
    }

    private static void sendSignal(TmfSignal signal) {
        TmfSignalManager.sendSignal(fVIPListeners, signal);
        TmfSignalManager.sendSignal(fListeners, signal);
    }

    private static void sendSignal(Map<Object, Method[]> listeners, TmfSignal signal) {
        if (TmfCoreTracer.isSignalTraced()) {
            TmfCoreTracer.traceSignal(signal, "(start)");
        }
        Class<?> signalClass = signal.getClass();
        HashMap targets = new HashMap();
        targets.clear();
        for (Map.Entry<Object, Method[]> entry : listeners.entrySet()) {
            ArrayList<Method> matchingMethods = new ArrayList<Method>();
            Method[] methodArray = entry.getValue();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getParameterTypes()[0].isAssignableFrom(signalClass)) {
                    matchingMethods.add(method);
                }
                ++n2;
            }
            if (matchingMethods.isEmpty()) continue;
            targets.put(entry.getKey(), matchingMethods);
        }
        for (Map.Entry<Object, Object> entry : targets.entrySet()) {
            for (Method method : (List)entry.getValue()) {
                try {
                    method.invoke(entry.getKey(), signal);
                    if (!TmfCoreTracer.isSignalTraced()) continue;
                    Object key = entry.getKey();
                    String hash = String.format("%1$08X", entry.getKey().hashCode());
                    String target = "[" + hash + "] " + key.getClass().getSimpleName() + ":" + method.getName();
                    TmfCoreTracer.traceSignal(signal, target);
                }
                catch (IllegalArgumentException e) {
                    Activator.logError("Exception handling signal " + signal + " in method " + method, e);
                }
                catch (IllegalAccessException e) {
                    Activator.logError("Exception handling signal " + signal + " in method " + method, e);
                }
                catch (InvocationTargetException e) {
                    Activator.logError("Exception handling signal " + signal + " in method " + method, e);
                }
            }
        }
        if (TmfCoreTracer.isSignalTraced()) {
            TmfCoreTracer.traceSignal(signal, "(end)");
        }
    }
}

