/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.event.lookup;

import org.eclipse.linuxtools.tmf.core.event.lookup.ITmfCallsite;

public class TmfCallsite
implements ITmfCallsite {
    private final String fFileName;
    private final String fFunctionName;
    private final long fLineNumber;

    public TmfCallsite(String fileName, String functionName, long lineNumber) {
        if (fileName == null) {
            throw new IllegalArgumentException();
        }
        this.fFileName = fileName;
        this.fFunctionName = functionName;
        this.fLineNumber = lineNumber;
    }

    public TmfCallsite(ITmfCallsite other) {
        if (other == null || other.getFileName() == null) {
            throw new IllegalArgumentException();
        }
        this.fFileName = other.getFileName();
        this.fFunctionName = other.getFunctionName();
        this.fLineNumber = other.getLineNumber();
    }

    @Override
    public String getFileName() {
        return this.fFileName;
    }

    @Override
    public String getFunctionName() {
        return this.fFunctionName;
    }

    @Override
    public long getLineNumber() {
        return this.fLineNumber;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fFileName.hashCode();
        result = 31 * result + (this.fFunctionName == null ? 0 : this.fFunctionName.hashCode());
        result = 31 * result + (int)(this.fLineNumber ^ this.fLineNumber >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfCallsite other = (TmfCallsite)obj;
        if (!this.fFileName.equals(other.fFileName)) {
            return false;
        }
        if (this.fFunctionName == null ? other.fFunctionName != null : !this.fFunctionName.equals(other.fFunctionName)) {
            return false;
        }
        return this.fLineNumber == other.fLineNumber;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.fFileName).append(':');
        builder.append(Long.toString(this.fLineNumber));
        if (this.fFunctionName != null) {
            builder.append(' ');
            builder.append(this.fFunctionName).append("()");
        }
        return builder.toString();
    }
}

