/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.ctf.core.trace.CTFTraceReader;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfIterator;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfIteratorManager;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfLocation;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfLocationInfo;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfContext;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.Messages;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTraceProperties;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;

public class CtfTmfTrace
extends TmfTrace
implements ITmfEventParser,
ITmfTraceProperties {
    protected static final int DEFAULT_CACHE_SIZE = 50000;
    private CTFTrace fTrace;

    @Override
    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> eventType) throws TmfTraceException {
        this.setCacheSize();
        super.initTrace(resource, path, eventType);
        try {
            this.fTrace = new CTFTrace(path);
            CtfIteratorManager.addTrace(this);
            CtfTmfContext ctx = (CtfTmfContext)this.seekEvent(0L);
            CtfTmfEvent event = this.getNext(ctx);
            if (ctx.getLocation().equals(CtfIterator.NULL_LOCATION) || ctx.getCurrentEvent() == null) {
                this.setStartTime(TmfTimestamp.BIG_BANG);
            } else {
                ITmfTimestamp curTime = event.getTimestamp();
                this.setStartTime(curTime);
                this.setEndTime(curTime);
            }
        }
        catch (CTFReaderException e) {
            throw new TmfTraceException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized void dispose() {
        CtfIteratorManager.removeTrace(this);
        if (this.fTrace != null) {
            this.fTrace.dispose();
            this.fTrace = null;
        }
        super.dispose();
    }

    @Override
    public IStatus validate(IProject project, String path) {
        IStatus validTrace = Status.OK_STATUS;
        try {
            CTFTrace temp = new CTFTrace(path);
            if (!temp.majortIsSet()) {
                validTrace = new Status(4, "org.eclipse.linuxtools.tmf.core", Messages.CtfTmfTrace_MajorNotSet);
            } else {
                CTFTraceReader ctfTraceReader = new CTFTraceReader(temp);
                if (!ctfTraceReader.hasMoreEvents()) {
                    validTrace = new Status(4, "org.eclipse.linuxtools.tmf.core", Messages.CtfTmfTrace_NoEvent);
                }
                ctfTraceReader.dispose();
            }
            temp.dispose();
        }
        catch (CTFReaderException e) {
            validTrace = new Status(4, "org.eclipse.linuxtools.tmf.core", String.valueOf(Messages.CtfTmfTrace_ReadingError) + ": " + e.toString());
        }
        return validTrace;
    }

    @Override
    public ITmfLocation getCurrentLocation() {
        return null;
    }

    @Override
    public double getLocationRatio(ITmfLocation location) {
        CtfLocation curLocation = (CtfLocation)location;
        CtfTmfContext context = new CtfTmfContext(this);
        context.setLocation(curLocation);
        context.seek(curLocation.getLocationInfo());
        CtfLocationInfo currentTime = (CtfLocationInfo)context.getLocation().getLocationInfo();
        long startTime = CtfTmfTrace.getIterator(this, context).getStartTime();
        long endTime = CtfTmfTrace.getIterator(this, context).getEndTime();
        return ((double)currentTime.getTimestamp() - (double)startTime) / (double)(endTime - startTime);
    }

    @Override
    public synchronized ITmfContext seekEvent(ITmfLocation location) {
        CtfTmfEvent event;
        CtfLocation currentLocation = (CtfLocation)location;
        CtfTmfContext context = new CtfTmfContext(this);
        if (this.fTrace == null) {
            context.setLocation(null);
            context.setRank(-1L);
            return context;
        }
        if (currentLocation == null) {
            currentLocation = new CtfLocation(new CtfLocationInfo(0L, 0L));
            context.setRank(0L);
        }
        if (currentLocation.getLocationInfo() == CtfLocation.INVALID_LOCATION) {
            currentLocation = new CtfLocation(this.getEndTime().getValue() + 1L, 0L);
        }
        context.setLocation(currentLocation);
        if (location == null && (event = CtfTmfTrace.getIterator(this, context).getCurrentEvent()) != null) {
            currentLocation = new CtfLocation(event.getTimestamp().getValue(), 0L);
        }
        if (context.getRank() != 0L) {
            context.setRank(-1L);
        }
        return context;
    }

    @Override
    public synchronized ITmfContext seekEvent(double ratio) {
        CtfTmfContext context = new CtfTmfContext(this);
        if (this.fTrace == null) {
            context.setLocation(null);
            context.setRank(-1L);
            return context;
        }
        long end = this.getEndTime().getValue();
        long start = this.getStartTime().getValue();
        long diff = end - start;
        long ratioTs = Math.round((double)diff * ratio) + start;
        context.seek(ratioTs);
        context.setRank(-1L);
        return context;
    }

    @Override
    public synchronized CtfTmfEvent getNext(ITmfContext context) {
        if (this.fTrace == null) {
            return null;
        }
        CtfTmfEvent event = null;
        if (context instanceof CtfTmfContext) {
            if (context.getLocation() == null || CtfLocation.INVALID_LOCATION.equals(context.getLocation().getLocationInfo())) {
                return null;
            }
            CtfTmfContext ctfContext = (CtfTmfContext)context;
            event = ctfContext.getCurrentEvent();
            if (event != null) {
                this.updateAttributes(context, event.getTimestamp());
                ctfContext.advance();
                ctfContext.increaseRank();
            }
        }
        return event;
    }

    public CTFTrace getCTFTrace() {
        return this.fTrace;
    }

    @Override
    public Map<String, String> getTraceProperties() {
        return Collections.unmodifiableMap(this.fTrace.getEnvironment());
    }

    public long getOffset() {
        if (this.fTrace != null) {
            return this.fTrace.getOffset();
        }
        return 0L;
    }

    @Override
    public CtfTmfEvent parseEvent(ITmfContext context) {
        CtfTmfEvent event = null;
        if (context instanceof CtfTmfContext) {
            ITmfContext tmpContext = this.seekEvent(context.getLocation());
            event = this.getNext(tmpContext);
        }
        return event;
    }

    protected void setCacheSize() {
        this.setCacheSize(50000);
    }

    private static CtfIterator getIterator(CtfTmfTrace trace, CtfTmfContext context) {
        return CtfIteratorManager.getIterator(trace, context);
    }

    public CtfIterator createIterator() {
        return new CtfIterator(this);
    }
}

