/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.linuxtools.ctf.core.event.CTFCallsite;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfCallsite;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEventField;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEventType;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTimestamp;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTrace;
import org.eclipse.linuxtools.tmf.core.event.ITmfCustomAttributes;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventType;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;
import org.eclipse.linuxtools.tmf.core.event.lookup.ITmfModelLookup;
import org.eclipse.linuxtools.tmf.core.event.lookup.ITmfSourceLookup;

public final class CtfTmfEvent
extends TmfEvent
implements ITmfSourceLookup,
ITmfModelLookup,
ITmfCustomAttributes {
    static final String NO_STREAM = "No stream";
    private static final String EMPTY_CTF_EVENT_NAME = "Empty CTF event";
    private final int sourceCPU;
    private final long typeId;
    private final String eventName;
    private final IEventDeclaration fDeclaration;

    CtfTmfEvent(CtfTmfTrace trace, long rank, CtfTmfTimestamp timestamp, ITmfEventField content, String fileName, int cpu, IEventDeclaration declaration) {
        super(trace, rank, timestamp, String.valueOf(cpu), null, content, fileName);
        this.fDeclaration = declaration;
        this.sourceCPU = cpu;
        this.typeId = declaration.getId();
        this.eventName = declaration.getName();
    }

    public CtfTmfEvent() {
        super(null, -1L, new CtfTmfTimestamp(-1L), null, null, new TmfEventField("", null, new CtfTmfEventField[0]), NO_STREAM);
        this.sourceCPU = -1;
        this.typeId = -1L;
        this.eventName = EMPTY_CTF_EVENT_NAME;
        this.fDeclaration = null;
    }

    public int getCPU() {
        return this.sourceCPU;
    }

    public long getID() {
        return this.typeId;
    }

    public String getEventName() {
        return this.eventName;
    }

    @Override
    public CtfTmfTrace getTrace() {
        return (CtfTmfTrace)super.getTrace();
    }

    @Override
    public ITmfEventType getType() {
        CtfTmfEventType ctfTmfEventType = CtfTmfEventType.get(this.eventName);
        if (ctfTmfEventType == null) {
            ctfTmfEventType = new CtfTmfEventType(this.getEventName(), this.getContent());
        }
        return ctfTmfEventType;
    }

    @Override
    public Set<String> listCustomAttributes() {
        if (this.fDeclaration == null) {
            return new HashSet<String>();
        }
        return this.fDeclaration.getCustomAttributes();
    }

    @Override
    public String getCustomAttribute(String name) {
        if (this.fDeclaration == null) {
            return null;
        }
        return this.fDeclaration.getCustomAttribute(name);
    }

    @Override
    public CtfTmfCallsite getCallsite() {
        ITmfEventField ipField;
        CTFCallsite callsite = null;
        if (this.getTrace() == null) {
            return null;
        }
        if (this.getContent() != null && (ipField = this.getContent().getField("context._ip")) != null && ipField.getValue() instanceof Long) {
            long ip = (Long)ipField.getValue();
            callsite = this.getTrace().getCTFTrace().getCallsite(this.eventName, ip);
        }
        if (callsite == null) {
            callsite = this.getTrace().getCTFTrace().getCallsite(this.eventName);
        }
        if (callsite != null) {
            return new CtfTmfCallsite(callsite);
        }
        return null;
    }

    @Override
    public String getModelUri() {
        return this.getCustomAttribute("model.emf.uri");
    }
}

