/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.trace;

import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.TmfContext;

public class TmfExperimentContext
extends TmfContext {
    public static final int NO_TRACE = -1;
    private ITmfContext[] fContexts;
    private ITmfEvent[] fEvents;
    private int fLastTraceRead;

    public TmfExperimentContext(int nbTraces) {
        this.fContexts = new ITmfContext[nbTraces];
        this.fEvents = new ITmfEvent[nbTraces];
        this.fLastTraceRead = -1;
    }

    @Override
    public void dispose() {
        ITmfContext[] iTmfContextArray = this.fContexts;
        int n = this.fContexts.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfContext context = iTmfContextArray[n2];
            context.dispose();
            ++n2;
        }
        super.dispose();
    }

    public ITmfContext[] getContexts() {
        return this.fContexts;
    }

    public ITmfEvent[] getEvents() {
        return this.fEvents;
    }

    public int getLastTrace() {
        return this.fLastTraceRead;
    }

    public void setLastTrace(int newIndex) {
        this.fLastTraceRead = newIndex;
    }

    @Override
    public int hashCode() {
        int result = 17;
        int i = 0;
        while (i < this.fContexts.length) {
            result = 37 * result + this.fContexts[i].hashCode();
            ++i;
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof TmfExperimentContext)) {
            return false;
        }
        TmfExperimentContext o = (TmfExperimentContext)other;
        boolean isEqual = true;
        int i = 0;
        while (isEqual && i < this.fContexts.length) {
            isEqual &= this.fContexts[i].equals(o.fContexts[i]);
            ++i;
        }
        return isEqual;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TmfExperimentContext [\n");
        sb.append("\tfLocation=" + this.getLocation() + ", fRank=" + this.getRank() + "\n");
        sb.append("\tfContexts=[");
        int i = 0;
        while (i < this.fContexts.length) {
            sb.append("(" + this.fContexts[i].getLocation() + "," + this.fContexts[i].getRank() + (i < this.fContexts.length - 1 ? ")," : ")]\n"));
            ++i;
        }
        sb.append("\tfEvents=[");
        i = 0;
        while (i < this.fEvents.length) {
            ITmfEvent event = this.fEvents[i];
            sb.append((event != null ? this.fEvents[i].getTimestamp() : "(null)") + (i < this.fEvents.length - 1 ? "," : "]\n"));
            ++i;
        }
        sb.append("\tfLastTraceRead=" + this.fLastTraceRead + "\n");
        sb.append("]");
        return sb.toString();
    }
}

