/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem.backends;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.IStateHistoryBackend;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.interval.TmfIntervalEndComparator;
import org.eclipse.linuxtools.tmf.core.interval.TmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;

public class InMemoryBackend
implements IStateHistoryBackend {
    private static final Comparator<ITmfStateInterval> END_COMPARATOR = new TmfIntervalEndComparator();
    private final List<ITmfStateInterval> intervals;
    private final long startTime;
    private long latestTime;

    public InMemoryBackend(long startTime) {
        this.startTime = startTime;
        this.latestTime = startTime;
        this.intervals = new ArrayList<ITmfStateInterval>();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.latestTime;
    }

    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, ITmfStateValue value) throws TimeRangeException {
        if (stateStartTime > stateEndTime || stateStartTime < this.startTime) {
            throw new TimeRangeException();
        }
        TmfStateInterval interval = new TmfStateInterval(stateStartTime, stateEndTime, quark, value);
        if (stateEndTime > this.latestTime) {
            this.latestTime = stateEndTime;
        }
        this.intervals.add(interval);
    }

    @Override
    public void doQuery(List<ITmfStateInterval> currentStateInfo, long t) throws TimeRangeException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException();
        }
        int i = InMemoryBackend.binarySearchEndTime(this.intervals, t);
        while (i < this.intervals.size()) {
            ITmfStateInterval entry = this.intervals.get(i);
            if (entry.getStartTime() <= t) {
                currentStateInfo.set(entry.getAttribute(), entry);
            }
            ++i;
        }
    }

    @Override
    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException, AttributeNotFoundException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException();
        }
        int i = InMemoryBackend.binarySearchEndTime(this.intervals, t);
        while (i < this.intervals.size()) {
            ITmfStateInterval entry = this.intervals.get(i);
            if (entry.getStartTime() <= t && entry.getAttribute() == attributeQuark) {
                return entry;
            }
            ++i;
        }
        throw new AttributeNotFoundException();
    }

    @Override
    public boolean checkValidTime(long t) {
        return t >= this.startTime && t <= this.latestTime;
    }

    @Override
    public void finishedBuilding(long endTime) throws TimeRangeException {
    }

    @Override
    public FileInputStream supplyAttributeTreeReader() {
        return null;
    }

    @Override
    public File supplyAttributeTreeWriterFile() {
        return null;
    }

    @Override
    public long supplyAttributeTreeWriterFilePosition() {
        return -1L;
    }

    @Override
    public void removeFiles() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void debugPrint(PrintWriter writer) {
        writer.println(this.intervals.toString());
    }

    private static int binarySearchEndTime(List<ITmfStateInterval> list, long time) {
        TmfStateInterval dummyInterval = new TmfStateInterval(-1L, time, -1, null);
        int mid = Collections.binarySearch(list, dummyInterval, END_COMPARATOR);
        if (mid < 0) {
            mid = -mid;
        }
        while (mid > 0 && list.get(mid).getEndTime() == list.get(mid - 1).getEndTime()) {
            --mid;
        }
        return mid;
    }
}

