/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.request;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.linuxtools.internal.tmf.core.TmfCoreTracer;
import org.eclipse.linuxtools.internal.tmf.core.component.TmfEventThread;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;

public class TmfRequestExecutor
implements Executor {
    private final ExecutorService fExecutor = Executors.newFixedThreadPool(2);
    private final String fExecutorName;
    private final Queue<TmfEventThread> fHighPriorityTasks = new ArrayBlockingQueue<TmfEventThread>(100);
    private final Queue<TmfEventThread> fLowPriorityTasks = new ArrayBlockingQueue<TmfEventThread>(100);
    private TmfEventThread fActiveTask;
    private TmfEventThread fSuspendedTask;

    public TmfRequestExecutor() {
        String canonicalName = this.fExecutor.getClass().getCanonicalName();
        this.fExecutorName = canonicalName.substring(canonicalName.lastIndexOf(46) + 1);
        if (TmfCoreTracer.isComponentTraced()) {
            TmfCoreTracer.trace(this.fExecutor + " created");
        }
    }

    @Deprecated
    public TmfRequestExecutor(ExecutorService executor) {
        this();
    }

    @Deprecated
    public synchronized int getNbPendingRequests() {
        return this.fHighPriorityTasks.size() + this.fLowPriorityTasks.size();
    }

    public synchronized boolean isShutdown() {
        return this.fExecutor.isShutdown();
    }

    public synchronized boolean isTerminated() {
        return this.fExecutor.isTerminated();
    }

    @Override
    public synchronized void execute(final Runnable command) {
        if (!(command instanceof TmfEventThread)) {
            return;
        }
        TmfEventThread thread = (TmfEventThread)command;
        TmfEventThread wrapper = new TmfEventThread(thread){

            @Override
            public void run() {
                try {
                    command.run();
                }
                finally {
                    TmfRequestExecutor.this.scheduleNext();
                }
            }
        };
        ITmfDataRequest.ExecutionType priority = thread.getExecType();
        (priority == ITmfDataRequest.ExecutionType.FOREGROUND ? this.fHighPriorityTasks : this.fLowPriorityTasks).offer(wrapper);
        if (this.fActiveTask == null) {
            this.scheduleNext();
        } else if (priority == ITmfDataRequest.ExecutionType.FOREGROUND && priority != this.fActiveTask.getExecType()) {
            this.fActiveTask.getThread().suspend();
            this.fSuspendedTask = this.fActiveTask;
            this.scheduleNext();
        }
    }

    protected synchronized void scheduleNext() {
        if (!this.isShutdown()) {
            this.fActiveTask = this.fHighPriorityTasks.poll();
            if (this.fActiveTask != null) {
                this.fExecutor.execute(this.fActiveTask);
            } else if (this.fSuspendedTask != null) {
                this.fActiveTask = this.fSuspendedTask;
                this.fSuspendedTask = null;
                this.fActiveTask.getThread().resume();
            } else {
                this.fActiveTask = this.fLowPriorityTasks.poll();
                if (this.fActiveTask != null) {
                    this.fExecutor.execute(this.fActiveTask);
                }
            }
        }
    }

    public synchronized void stop() {
        if (this.fActiveTask != null) {
            this.fActiveTask.cancel();
        }
        while ((this.fActiveTask = this.fHighPriorityTasks.poll()) != null) {
            this.fActiveTask.cancel();
        }
        this.fExecutor.shutdown();
        if (TmfCoreTracer.isComponentTraced()) {
            TmfCoreTracer.trace(this.fExecutor + " terminated");
        }
    }

    public String toString() {
        return "[TmfRequestExecutor(" + this.fExecutorName + ")]";
    }
}

