/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.tmf.core.Activator;
import org.eclipse.linuxtools.tmf.core.component.ITmfComponent;
import org.eclipse.linuxtools.tmf.core.component.ITmfDataProvider;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;

public class TmfCoreTracer {
    private static final String PLUGIN_ID = "org.eclipse.linuxtools.tmf.core";
    private static final String COMPONENT_TRACE_KEY = "org.eclipse.linuxtools.tmf.core/component";
    private static final String REQUEST_TRACE_KEY = "org.eclipse.linuxtools.tmf.core/request";
    private static final String SIGNAL_TRACE_KEY = "org.eclipse.linuxtools.tmf.core/signal";
    private static final String EVENT_TRACE_KEY = "org.eclipse.linuxtools.tmf.core/event";
    private static final String TRACE_FILE_NAME = "TmfTrace.log";
    static Boolean COMPONENT_CLASS_ENABLED = Boolean.FALSE;
    static Boolean REQUEST_CLASS_ENABLED = Boolean.FALSE;
    static Boolean SIGNAL_CLASS_ENABLED = Boolean.FALSE;
    static Boolean EVENT_CLASS_ENABLED = Boolean.FALSE;
    private static BufferedWriter fTraceFile;

    public static void init() {
        boolean isTracing = false;
        String traceKey = Platform.getDebugOption((String)COMPONENT_TRACE_KEY);
        if (traceKey != null) {
            COMPONENT_CLASS_ENABLED = (boolean)Boolean.valueOf(traceKey);
            isTracing |= COMPONENT_CLASS_ENABLED.booleanValue();
        }
        if ((traceKey = Platform.getDebugOption((String)REQUEST_TRACE_KEY)) != null) {
            REQUEST_CLASS_ENABLED = (boolean)Boolean.valueOf(traceKey);
            isTracing |= REQUEST_CLASS_ENABLED.booleanValue();
        }
        if ((traceKey = Platform.getDebugOption((String)SIGNAL_TRACE_KEY)) != null) {
            SIGNAL_CLASS_ENABLED = (boolean)Boolean.valueOf(traceKey);
            isTracing |= SIGNAL_CLASS_ENABLED.booleanValue();
        }
        if ((traceKey = Platform.getDebugOption((String)EVENT_TRACE_KEY)) != null) {
            EVENT_CLASS_ENABLED = (boolean)Boolean.valueOf(traceKey);
            isTracing |= EVENT_CLASS_ENABLED.booleanValue();
        }
        if (isTracing) {
            try {
                fTraceFile = new BufferedWriter(new FileWriter(TRACE_FILE_NAME));
            }
            catch (IOException e) {
                Activator.logError("Error opening log file TmfTrace.log", e);
                fTraceFile = null;
            }
        }
    }

    public static void stop() {
        if (fTraceFile != null) {
            try {
                fTraceFile.close();
                fTraceFile = null;
            }
            catch (IOException e) {
                Activator.logError("Error closing log file", e);
            }
        }
    }

    public static boolean isComponentTraced() {
        return COMPONENT_CLASS_ENABLED;
    }

    public static boolean isRequestTraced() {
        return REQUEST_CLASS_ENABLED;
    }

    public static boolean isSignalTraced() {
        return SIGNAL_CLASS_ENABLED;
    }

    public static boolean isEventTraced() {
        return EVENT_CLASS_ENABLED;
    }

    public static synchronized void trace(String msg) {
        long currentTime = System.currentTimeMillis();
        StringBuilder message = new StringBuilder("[");
        message.append(currentTime / 1000L);
        message.append(".");
        message.append(String.format("%1$03d", currentTime % 1000L));
        message.append("] ");
        message.append("[TID=");
        message.append(String.format("%1$03d", Thread.currentThread().getId()));
        message.append("] ");
        message.append(msg);
        if (fTraceFile != null) {
            try {
                fTraceFile.write(message.toString());
                fTraceFile.newLine();
                fTraceFile.flush();
            }
            catch (IOException e) {
                Activator.logError("Error writing to log file", e);
            }
        }
    }

    public static void traceComponent(ITmfComponent component, String msg) {
        if (COMPONENT_CLASS_ENABLED.booleanValue()) {
            String message = "[CMP] Cmp=" + component.getName() + " " + msg;
            TmfCoreTracer.trace(message);
        }
    }

    public static void traceRequest(ITmfDataRequest request, String msg) {
        if (REQUEST_CLASS_ENABLED.booleanValue()) {
            String message = "[REQ] Req=" + request.getRequestId() + " " + msg;
            TmfCoreTracer.trace(message);
        }
    }

    public static void traceSignal(TmfSignal signal, String msg) {
        if (SIGNAL_CLASS_ENABLED.booleanValue()) {
            String message = "[SIG] Sig=" + signal.getClass().getSimpleName() + " Target=" + msg;
            TmfCoreTracer.trace(message);
        }
    }

    public static void traceEvent(ITmfDataProvider provider, ITmfDataRequest request, ITmfEvent event) {
        if (EVENT_CLASS_ENABLED.booleanValue()) {
            String message = "[EVT] Provider=" + provider.toString() + ", Req=" + request.getRequestId() + ", Event=" + event.getTimestamp();
            TmfCoreTracer.trace(message);
        }
    }
}

