/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.dataviewers.charts.actions;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.dataviewers.charts.Activator;
import org.eclipse.linuxtools.internal.dataviewers.charts.Messages;
import org.eclipse.linuxtools.internal.dataviewers.charts.view.ChartView;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.swtchart.Chart;

public class SaveChartAction
extends Action {
    private static final String TAG_SECTION_CHARTS_SAVEACTION_STATE = "charts_saveasimg_section";
    private static final String TAG_IMG_FILE_NAME = "IMG_FILE_NAME";
    private static final String TAG_IMG_FILTER_PATH = "IMG_FILTER_PATH";
    private static final String EXT_JPG = "*.jpg";
    private static final String EXT_JPEG = "*.jpeg";
    private static final String EXT_PNG = "*.png";
    private static final String EXT_GIF = "*.gif";
    private static final String[] saveAsImageExt = new String[]{"*.png", "*.gif", "*.jpg", "*.jpeg", "*.*"};
    private static final String[] saveAsImageExtNames = new String[]{"PNG (*.png)", "GIF (*.gif)", "JPEG (*.jpg)", "JPEG (*.jpeg)", Messages.ChartConstants_ALL_FILES};
    private final FileDialog dialog;
    private final Shell shell;
    private Chart cm;

    public SaveChartAction(Shell shell, ChartView cview) {
        super(String.valueOf(Messages.ChartConstants_SAVE_CHART_AS) + "...", Activator.getImageDescriptor("icons/save_chart.gif"));
        this.setEnabled(false);
        this.shell = shell;
        this.dialog = new FileDialog(shell, 8192);
        this.dialog.setFilterExtensions(saveAsImageExt);
        this.dialog.setFilterNames(saveAsImageExtNames);
        this.dialog.setText(Messages.ChartConstants_SAVE_CHART_DIALOG_TEXT);
        this.restoreState();
    }

    public void setChart(Chart chart) {
        if (chart != null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
        this.cm = chart;
    }

    public void run() {
        String path = this.dialog.open();
        if (path == null) {
            return;
        }
        final File file = new File(path);
        if (file.exists()) {
            boolean overwrite = MessageDialog.openQuestion((Shell)this.shell, (String)Messages.ChartConstants_CONFIRM_OVERWRITE_TITLE, (String)Messages.ChartConstants_CONFIRM_OVERWRITE_MSG);
            if (overwrite) {
                file.delete();
            } else {
                return;
            }
        }
        final String ext = this.dialog.getFilterNames()[this.dialog.getFilterIndex()];
        UIJob saveAsImage = new UIJob(String.valueOf(Messages.ChartConstants_SAVE_CHART_AS) + " " + file.getName()){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                int extention = SaveChartAction.EXT_GIF.equals(ext) ? 2 : (SaveChartAction.EXT_JPEG.equals(ext) || SaveChartAction.EXT_JPG.equals(ext) ? 4 : 5);
                try {
                    monitor.beginTask(String.valueOf(Messages.ChartConstants_SAVE_CHART_AS) + " " + file.getName() + "...", -1);
                    file.createNewFile();
                    SaveChartAction.this.generateImageFile(file, extention);
                    return Status.OK_STATUS;
                }
                catch (IOException e) {
                    return new Status(4, "org.eclipse.linuxtools.dataviewers.charts", String.valueOf(Messages.ChartConstants_ERROR_SAVING_CHART) + " (" + file.getAbsolutePath() + "):\n" + e.getMessage(), (Throwable)e);
                }
            }
        };
        saveAsImage.setUser(true);
        saveAsImage.schedule();
        this.saveState();
    }

    protected void restoreState() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(TAG_SECTION_CHARTS_SAVEACTION_STATE);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(TAG_SECTION_CHARTS_SAVEACTION_STATE);
            return;
        }
        this.dialog.setFileName(settings.get(TAG_IMG_FILE_NAME));
        this.dialog.setFilterPath(settings.get(TAG_IMG_FILTER_PATH));
    }

    protected void saveState() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(TAG_SECTION_CHARTS_SAVEACTION_STATE);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(TAG_SECTION_CHARTS_SAVEACTION_STATE);
        }
        settings.put(TAG_IMG_FILE_NAME, this.dialog.getFileName());
        settings.put(TAG_IMG_FILTER_PATH, this.dialog.getFilterPath());
    }

    protected void generateImageFile(File file, int extention) {
        Display dsp = Display.getCurrent();
        GC gc = new GC((Drawable)this.cm);
        Image img = new Image((Device)dsp, this.cm.getSize().x, this.cm.getSize().y);
        gc.copyArea(img, 0, 0);
        gc.dispose();
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{img.getImageData()};
        imageLoader.save(file.getAbsolutePath(), extention);
    }
}

