/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;

public class TaskList
implements ITaskList,
ITransferList {
    private static String DEFAULT_HANDLE_PREFIX = "handle-";
    private static ILock lock = Job.getJobManager().newLock();
    private Map<String, AbstractTaskCategory> categories;
    private final Set<ITaskListChangeListener> changeListeners = new CopyOnWriteArraySet<ITaskListChangeListener>();
    private UncategorizedTaskContainer defaultCategory;
    private int maxLocalTaskId;
    private Map<String, RepositoryQuery> queries;
    private Map<String, UnmatchedTaskContainer> unmatchedMap;
    private Map<String, UnsubmittedTaskContainer> unsubmittedTasksMap;
    private Map<String, AbstractTask> tasks;
    private Set<TaskContainerDelta> delta;
    private int nextHandle = 1;

    public TaskList() {
        this.reset();
    }

    @Override
    public void addCategory(TaskCategory category) {
        Assert.isNotNull((Object)category);
        try {
            this.lock();
            if (this.categories.containsKey(category.getHandleIdentifier())) {
                throw new IllegalArgumentException("Handle " + category.getHandleIdentifier() + " already exists in task list");
            }
            this.categories.put(category.getHandleIdentifier(), category);
            this.delta.add(new TaskContainerDelta(category, TaskContainerDelta.Kind.ADDED));
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void addChangeListener(ITaskListChangeListener listener) {
        this.changeListeners.add(listener);
    }

    private void addToUnmatched(AbstractTask task, Set<TaskContainerDelta> delta) {
        if (!task.getParentContainers().isEmpty()) {
            return;
        }
        AbstractTaskContainer orphans = this.getUnmatchedContainer(task.getRepositoryUrl());
        if (orphans != null) {
            task.addParentContainer(orphans);
            orphans.internalAddChild(task);
            delta.add(new TaskContainerDelta(task, orphans, TaskContainerDelta.Kind.ADDED));
        }
    }

    @Override
    public void addQuery(RepositoryQuery query) throws IllegalArgumentException {
        Assert.isNotNull((Object)query);
        try {
            this.lock();
            if (this.queries.containsKey(query.getHandleIdentifier())) {
                throw new IllegalArgumentException("Handle " + query.getHandleIdentifier() + " already exists in task list");
            }
            this.queries.put(query.getHandleIdentifier(), query);
            this.delta.add(new TaskContainerDelta(query, TaskContainerDelta.Kind.ADDED));
        }
        finally {
            this.unlock();
        }
    }

    public boolean addTaskIfAbsent(ITask task) {
        if (this.getTask(task.getRepositoryUrl(), task.getTaskId()) == null) {
            this.addTask(task, this.getDefaultCategory());
            return true;
        }
        return false;
    }

    @Override
    public void addTask(ITask task) {
        this.addTask(task, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean addTask(ITask itask, AbstractTaskContainer container) {
        task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        Assert.isLegal((boolean)(container instanceof UnmatchedTaskContainer == false));
        try {
            this.lock();
            task = this.getOrCreateTask(task);
            if (task.getSynchronizationState() == ITask.SynchronizationState.OUTGOING_NEW && (repositoryUrl = task.getAttribute("outgoingNewRepositoryUrl")) != null) {
                container = this.getUnsubmittedContainer(repositoryUrl);
            }
            if ((container = container == null ? this.getUnmatchedContainer(task.getRepositoryUrl()) : this.getValidElement(container)) instanceof UnsubmittedTaskContainer && container.isEmpty()) {
                this.delta.add(new TaskContainerDelta(container, TaskContainerDelta.Kind.ROOT));
            }
            if (container == null || task.equals(container) || task.getParentContainers().contains(container)) {
                return false;
            }
            if (task.contains(container.getHandleIdentifier())) ** continue;
            if (task instanceof LocalTask && task.getParentContainers().size() > 0) {
                for (AbstractTaskContainer parent : task.getParentContainers()) {
                    this.removeFromContainerInternal(parent, task, this.delta);
                }
            } else if (container instanceof AbstractTaskCategory && (tempCat = TaskCategory.getParentTaskCategory(task)) != null) {
                this.removeFromContainerInternal(tempCat, task, this.delta);
            }
            this.removeFromUnmatched(task, this.delta);
            task.addParentContainer(container);
            container.internalAddChild(task);
            this.delta.add(new TaskContainerDelta(task, container, TaskContainerDelta.Kind.ADDED));
        }
        finally {
            this.unlock();
        }
        return true;
    }

    public void addUnmatchedContainer(UnmatchedTaskContainer orphanedTasksContainer) {
        this.unmatchedMap.put(orphanedTasksContainer.getRepositoryUrl(), orphanedTasksContainer);
        this.unsubmittedTasksMap.put(orphanedTasksContainer.getRepositoryUrl(), new UnsubmittedTaskContainer(orphanedTasksContainer.getConnectorKind(), orphanedTasksContainer.getRepositoryUrl()));
    }

    @Override
    public void deleteCategory(AbstractTaskCategory category) {
        try {
            this.lock();
            this.categories.remove(category.getHandleIdentifier());
            for (ITask task : category.getChildren()) {
                ((AbstractTask)task).removeParentContainer(category);
                this.addToUnmatched((AbstractTask)task, this.delta);
            }
            this.delta.add(new TaskContainerDelta(category, TaskContainerDelta.Kind.REMOVED));
            this.delta.add(new TaskContainerDelta(category, TaskContainerDelta.Kind.DELETED));
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void deleteQuery(RepositoryQuery query) {
        try {
            this.lock();
            this.queries.remove(query.getHandleIdentifier());
            for (ITask task : query.getChildren()) {
                ((AbstractTask)task).removeParentContainer(query);
                this.addToUnmatched((AbstractTask)task, this.delta);
            }
            this.delta.add(new TaskContainerDelta(query, TaskContainerDelta.Kind.REMOVED));
            this.delta.add(new TaskContainerDelta(query, TaskContainerDelta.Kind.DELETED));
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void deleteTask(ITask itask) {
        Assert.isNotNull((Object)itask);
        AbstractTask task = (AbstractTask)itask;
        try {
            this.lock();
            for (AbstractTaskContainer container : task.getParentContainers()) {
                this.removeFromContainerInternal(container, task, this.delta);
            }
            for (ITask child : task.getChildren()) {
                this.removeFromContainerInternal(task, child, this.delta);
                this.addToUnmatched((AbstractTask)child, this.delta);
            }
            this.tasks.remove(task.getHandleIdentifier());
            this.delta.add(new TaskContainerDelta(task, TaskContainerDelta.Kind.REMOVED));
            this.delta.add(new TaskContainerDelta(task, TaskContainerDelta.Kind.DELETED));
        }
        finally {
            this.unlock();
        }
    }

    private void fireDelta(HashSet<TaskContainerDelta> deltasToFire) {
        for (ITaskListChangeListener listener : this.changeListeners) {
            try {
                listener.containersChanged(Collections.unmodifiableSet(deltasToFire));
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Notification failed for: " + listener, t));
            }
        }
    }

    @Override
    public Collection<AbstractTask> getAllTasks() {
        return Collections.unmodifiableCollection(this.tasks.values());
    }

    @Override
    public Set<AbstractTaskCategory> getCategories() {
        return Collections.unmodifiableSet(new HashSet<AbstractTaskCategory>(this.categories.values()));
    }

    public Set<ITaskListChangeListener> getChangeListeners() {
        return Collections.unmodifiableSet(this.changeListeners);
    }

    @Override
    public AbstractTaskCategory getContainerForHandle(String categoryHandle) {
        Assert.isNotNull((Object)categoryHandle);
        for (AbstractTaskCategory cat : this.categories.values()) {
            if (!cat.getHandleIdentifier().equals(categoryHandle)) continue;
            return cat;
        }
        return null;
    }

    public AbstractTaskCategory getDefaultCategory() {
        return this.defaultCategory;
    }

    public int getLastLocalTaskId() {
        return this.maxLocalTaskId;
    }

    public int getNextLocalTaskId() {
        try {
            this.lock();
            int n = ++this.maxLocalTaskId;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    private AbstractTask getOrCreateTask(AbstractTask taskListElement) {
        AbstractTask task = this.tasks.get(taskListElement.getHandleIdentifier());
        if (task == null) {
            this.tasks.put(taskListElement.getHandleIdentifier(), taskListElement);
            task = taskListElement;
            if (task instanceof LocalTask) {
                try {
                    int taskId = Integer.parseInt(task.getTaskId());
                    this.maxLocalTaskId = Math.max(this.maxLocalTaskId, taskId);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return task;
    }

    @Override
    public Set<RepositoryQuery> getQueries() {
        return Collections.unmodifiableSet(new HashSet<RepositoryQuery>(this.queries.values()));
    }

    public Set<RepositoryQuery> getRepositoryQueries(String repositoryUrl) {
        Assert.isNotNull((Object)repositoryUrl);
        HashSet<RepositoryQuery> repositoryQueries = new HashSet<RepositoryQuery>();
        for (RepositoryQuery query : this.queries.values()) {
            if (!query.getRepositoryUrl().equals(repositoryUrl)) continue;
            repositoryQueries.add(query);
        }
        return repositoryQueries;
    }

    public Set<AbstractTaskContainer> getRootElements() {
        HashSet<AbstractTaskContainer> roots = new HashSet<AbstractTaskContainer>();
        roots.add(this.defaultCategory);
        for (AbstractTaskCategory cat : this.categories.values()) {
            roots.add(cat);
        }
        for (RepositoryQuery query : this.queries.values()) {
            roots.add(query);
        }
        for (UnmatchedTaskContainer orphanContainer : this.unmatchedMap.values()) {
            roots.add(orphanContainer);
        }
        for (UnsubmittedTaskContainer unsubmitedTaskContainer : this.unsubmittedTasksMap.values()) {
            roots.add(unsubmitedTaskContainer);
        }
        return roots;
    }

    @Override
    public AbstractTask getTask(String handleIdentifier) {
        if (handleIdentifier == null) {
            return null;
        }
        return this.tasks.get(handleIdentifier);
    }

    @Override
    public ITask getTask(String repositoryUrl, String taskId) {
        if (!RepositoryTaskHandleUtil.isValidTaskId(taskId)) {
            return null;
        }
        String handle = RepositoryTaskHandleUtil.getHandle(repositoryUrl, taskId);
        return this.getTask(handle);
    }

    public AbstractTask getTaskByKey(String repositoryUrl, String taskKey) {
        for (AbstractTask task : this.tasks.values()) {
            String currentTaskKey = task.getTaskKey();
            if (currentTaskKey == null || !currentTaskKey.equals(taskKey) || !task.getRepositoryUrl().equals(repositoryUrl)) continue;
            return task;
        }
        return null;
    }

    public Set<AbstractTaskCategory> getTaskCategories() {
        HashSet<AbstractTaskCategory> containers = new HashSet<AbstractTaskCategory>();
        for (AbstractTaskCategory container : this.categories.values()) {
            if (!(container instanceof TaskCategory)) continue;
            containers.add(container);
        }
        return containers;
    }

    public Set<ITask> getTasks(String repositoryUrl) {
        HashSet<ITask> repositoryTasks = new HashSet<ITask>();
        if (repositoryUrl != null) {
            for (ITask iTask : this.tasks.values()) {
                if (!iTask.getRepositoryUrl().equals(repositoryUrl)) continue;
                repositoryTasks.add(iTask);
            }
        }
        return repositoryTasks;
    }

    public AbstractTaskContainer getUnmatchedContainer(String repositoryUrl) {
        if ("local".equals(repositoryUrl)) {
            return this.defaultCategory;
        }
        UnmatchedTaskContainer unmatched = this.unmatchedMap.get(repositoryUrl);
        if (unmatched == null) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Failed to find unmatched container for repository \"" + repositoryUrl + "\""));
        }
        return unmatched;
    }

    public Set<UnmatchedTaskContainer> getUnmatchedContainers() {
        return Collections.unmodifiableSet(new HashSet<UnmatchedTaskContainer>(this.unmatchedMap.values()));
    }

    private AbstractTaskContainer getValidElement(IRepositoryElement taskListElement) {
        AbstractTaskContainer result = null;
        if (taskListElement instanceof ITask) {
            result = this.tasks.get(taskListElement.getHandleIdentifier());
        } else if (taskListElement instanceof UncategorizedTaskContainer) {
            result = this.defaultCategory;
        } else if (taskListElement instanceof UnmatchedTaskContainer) {
            result = this.unmatchedMap.get(((UnmatchedTaskContainer)taskListElement).getRepositoryUrl());
        } else if (taskListElement instanceof UnsubmittedTaskContainer) {
            result = this.unsubmittedTasksMap.get(((UnsubmittedTaskContainer)taskListElement).getRepositoryUrl());
        } else if (taskListElement instanceof TaskCategory) {
            result = this.categories.get(taskListElement.getHandleIdentifier());
        } else if (taskListElement instanceof IRepositoryQuery) {
            result = this.queries.get(taskListElement.getHandleIdentifier());
        }
        if (result == null) {
            throw new IllegalArgumentException("Element " + taskListElement.getHandleIdentifier() + " does not exist in the task list.");
        }
        return result;
    }

    public void notifyElementsChanged(Set<? extends IRepositoryElement> elements) {
        HashSet<TaskContainerDelta> deltas = new HashSet<TaskContainerDelta>();
        if (elements == null) {
            deltas.add(new TaskContainerDelta(null, TaskContainerDelta.Kind.ROOT));
        } else {
            for (IRepositoryElement iRepositoryElement : elements) {
                deltas.add(new TaskContainerDelta(iRepositoryElement, TaskContainerDelta.Kind.CONTENT));
            }
        }
        this.fireDelta(deltas);
    }

    public void notifySynchronizationStateChanged(Set<? extends IRepositoryElement> elements) {
        HashSet<TaskContainerDelta> taskChangeDeltas = new HashSet<TaskContainerDelta>();
        for (IRepositoryElement iRepositoryElement : elements) {
            TaskContainerDelta delta = new TaskContainerDelta(iRepositoryElement, TaskContainerDelta.Kind.CONTENT);
            delta.setTransient(true);
            taskChangeDeltas.add(delta);
        }
        this.fireDelta(taskChangeDeltas);
    }

    @Override
    public void notifySynchronizationStateChanged(IRepositoryElement element) {
        this.notifySynchronizationStateChanged(Collections.singleton(element));
    }

    @Override
    public void notifyElementChanged(IRepositoryElement element) {
        this.notifyElementsChanged(Collections.singleton(element));
    }

    public void refactorRepositoryUrl(String oldRepositoryUrl, String newRepositoryUrl) {
        Assert.isNotNull((Object)oldRepositoryUrl);
        Assert.isNotNull((Object)newRepositoryUrl);
        try {
            this.lock();
            for (AbstractTask task : this.tasks.values()) {
                if (oldRepositoryUrl.equals(RepositoryTaskHandleUtil.getRepositoryUrl(task.getHandleIdentifier()))) {
                    this.tasks.remove(task.getHandleIdentifier());
                    task.setRepositoryUrl(newRepositoryUrl);
                    this.tasks.put(task.getHandleIdentifier(), task);
                    String taskUrl = task.getUrl();
                    if (taskUrl != null && taskUrl.startsWith(oldRepositoryUrl)) {
                        task.setUrl(String.valueOf(newRepositoryUrl) + taskUrl.substring(oldRepositoryUrl.length()));
                    }
                }
                if (!oldRepositoryUrl.equals(task.getAttribute("outgoingNewRepositoryUrl"))) continue;
                task.setAttribute("outgoingNewRepositoryUrl", newRepositoryUrl);
            }
            for (RepositoryQuery query : this.queries.values()) {
                if (!query.getRepositoryUrl().equals(oldRepositoryUrl)) continue;
                query.setRepositoryUrl(newRepositoryUrl);
                this.delta.add(new TaskContainerDelta(query, TaskContainerDelta.Kind.CONTENT));
            }
            for (UnmatchedTaskContainer unmatched : this.unmatchedMap.values()) {
                if (!unmatched.getRepositoryUrl().equals(oldRepositoryUrl)) continue;
                this.unmatchedMap.remove(oldRepositoryUrl);
                unmatched.setRepositoryUrl(newRepositoryUrl);
                this.unmatchedMap.put(newRepositoryUrl, unmatched);
                this.delta.add(new TaskContainerDelta(unmatched, TaskContainerDelta.Kind.CONTENT));
            }
            for (UnsubmittedTaskContainer unsubmitted : this.unsubmittedTasksMap.values()) {
                if (!unsubmitted.getRepositoryUrl().equals(oldRepositoryUrl)) continue;
                this.unsubmittedTasksMap.remove(oldRepositoryUrl);
                unsubmitted.setRepositoryUrl(newRepositoryUrl);
                this.unsubmittedTasksMap.put(newRepositoryUrl, unsubmitted);
                this.delta.add(new TaskContainerDelta(unsubmitted, TaskContainerDelta.Kind.CONTENT));
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void removeChangeListener(ITaskListChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    @Override
    public void removeFromContainer(AbstractTaskContainer container, ITask task) {
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)task);
        this.removeFromContainer(container, Collections.singleton(task));
    }

    public void removeFromContainer(AbstractTaskContainer container, Set<ITask> tasks) {
        Assert.isNotNull((Object)container);
        Assert.isNotNull(tasks);
        try {
            this.lock();
            for (ITask task : tasks) {
                this.removeFromContainerInternal(container, task, this.delta);
                this.addToUnmatched((AbstractTask)task, this.delta);
            }
        }
        finally {
            this.unlock();
        }
    }

    private void removeFromContainerInternal(AbstractTaskContainer container, ITask task, Set<TaskContainerDelta> delta) {
        assert (container.getChildren().contains(task));
        container.internalRemoveChild(task);
        ((AbstractTask)task).removeParentContainer(container);
        delta.add(new TaskContainerDelta(task, container, TaskContainerDelta.Kind.REMOVED));
    }

    private void removeFromUnmatched(AbstractTask task, Set<TaskContainerDelta> delta) {
        AbstractTaskContainer orphans = this.getUnmatchedContainer(task.getRepositoryUrl());
        if (orphans != null && orphans.internalRemoveChild(task)) {
            delta.add(new TaskContainerDelta(task, orphans, TaskContainerDelta.Kind.REMOVED));
            task.removeParentContainer(orphans);
        }
    }

    @Deprecated
    public void renameContainer(AbstractTaskContainer container, String newDescription) {
        Assert.isLegal((!(container instanceof ITask) ? 1 : 0) != 0);
        Assert.isLegal((!(container instanceof UnmatchedTaskContainer) ? 1 : 0) != 0);
        try {
            this.lock();
            if (container instanceof TaskCategory) {
                ((TaskCategory)container).setSummary(newDescription);
            } else if (container instanceof RepositoryQuery) {
                ((RepositoryQuery)container).setSummary(newDescription);
            }
            this.delta.add(new TaskContainerDelta(container, TaskContainerDelta.Kind.CONTENT));
        }
        finally {
            this.unlock();
        }
    }

    public void reset() {
        try {
            this.lock();
            this.tasks = new ConcurrentHashMap<String, AbstractTask>();
            this.unmatchedMap = new ConcurrentHashMap<String, UnmatchedTaskContainer>();
            this.unsubmittedTasksMap = new ConcurrentHashMap<String, UnsubmittedTaskContainer>();
            this.categories = new ConcurrentHashMap<String, AbstractTaskCategory>();
            this.queries = new ConcurrentHashMap<String, RepositoryQuery>();
            this.defaultCategory = new UncategorizedTaskContainer();
            this.maxLocalTaskId = 0;
            this.categories.put(this.defaultCategory.getHandleIdentifier(), this.defaultCategory);
        }
        finally {
            this.unlock();
        }
    }

    public void run(ITaskListRunnable runnable) throws CoreException {
        this.run(runnable, null);
    }

    public void run(ITaskListRunnable runnable, IProgressMonitor monitor) throws CoreException {
        this.run(runnable, monitor, false);
    }

    public void run(ITaskListRunnable runnable, IProgressMonitor monitor, boolean ignoreInterrupts) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            this.lock(monitor, ignoreInterrupts);
            runnable.execute(monitor);
        }
        finally {
            this.unlock();
        }
    }

    private void lock() {
        lock.acquire();
        if (lock.getDepth() == 1) {
            this.delta = new HashSet<TaskContainerDelta>();
        }
    }

    private void lock(IProgressMonitor monitor, boolean ignoreInterrupts) throws CoreException {
        while (!monitor.isCanceled()) {
            try {
                if (!lock.acquire(3000L)) continue;
                if (lock.getDepth() == 1) {
                    this.delta = new HashSet<TaskContainerDelta>();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                if (!ignoreInterrupts) break;
                Thread.interrupted();
            }
        }
        throw new OperationCanceledException();
    }

    private void unlock() {
        HashSet<TaskContainerDelta> toFire = null;
        try {
            if (lock.getDepth() == 1) {
                toFire = new HashSet<TaskContainerDelta>(this.delta);
            }
        }
        finally {
            lock.release();
        }
        if (toFire != null && toFire.size() > 0) {
            this.fireDelta(toFire);
        }
    }

    public static ISchedulingRule getSchedulingRule() {
        return ITasksCoreConstants.TASKLIST_SCHEDULING_RULE;
    }

    public String getUniqueHandleIdentifier() {
        try {
            this.lock();
            while (this.nextHandle < Integer.MAX_VALUE) {
                String handle = String.valueOf(DEFAULT_HANDLE_PREFIX) + this.nextHandle;
                ++this.nextHandle;
                if (this.categories.containsKey(handle) || this.queries.containsKey(handle) || this.unmatchedMap.containsKey(handle) || this.tasks.containsKey(handle)) continue;
                String string = handle;
                return string;
            }
            throw new RuntimeException("No more unique handles for task list");
        }
        finally {
            this.unlock();
        }
    }

    public UnsubmittedTaskContainer getUnsubmittedContainer(String repositoryUrl) {
        return this.unsubmittedTasksMap.get(repositoryUrl);
    }
}

