/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gdbtrace.ui.views.project.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.gdbtrace.core.trace.GdbTrace;
import org.eclipse.linuxtools.internal.gdbtrace.ui.views.project.dialogs.SelectTraceExecutableDialog;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class SelectTraceExecutableHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        SelectTraceExecutableDialog dialog = new SelectTraceExecutableDialog(shell);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return null;
        }
        IPath tracedExecutable = dialog.getExecutablePath();
        if (selection instanceof IStructuredSelection) {
            for (Object o : ((IStructuredSelection)selection).toList()) {
                TmfTraceElement traceElement = (TmfTraceElement)o;
                IResource resource = traceElement.getResource();
                try {
                    resource.setPersistentProperty(GdbTrace.EXEC_KEY, tracedExecutable.toString());
                }
                catch (CoreException e) {
                    MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    mb.setText(((Object)((Object)e)).getClass().getName());
                    mb.setMessage(e.getMessage());
                    mb.open();
                }
            }
        }
        return null;
    }
}

