/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.process.SystemtapProcessFactory;
import org.eclipse.linuxtools.systemtap.structures.runnable.Command;
import org.eclipse.linuxtools.systemtap.structures.runnable.StreamGobbler;
import org.eclipse.linuxtools.systemtap.ui.consolelog.Messages;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ScpExec
extends Command {
    private Channel channel;
    private String command = "";
    public static final int INPUT_STREAM = 1;

    public ScpExec(String[] cmds) {
        super(cmds, null);
        String[] stringArray = cmds;
        int n = cmds.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            this.command = String.valueOf(this.command) + " " + cmd;
            ++n2;
        }
    }

    protected IStatus init() {
        String user = ConsoleLogPlugin.getDefault().getPreferenceStore().getString("scpuser");
        String host = ConsoleLogPlugin.getDefault().getPreferenceStore().getString("host");
        String password = ConsoleLogPlugin.getDefault().getPreferenceStore().getString("scppassword");
        try {
            this.channel = SystemtapProcessFactory.execRemote((String[])new String[]{this.command}, (OutputStream)System.out, (OutputStream)System.err, (String)user, (String)host, (String)password);
            this.errorGobbler = new StreamGobbler(this.channel.getExtInputStream());
            this.inputGobbler = new StreamGobbler(this.channel.getInputStream());
            this.transferListeners();
            return Status.OK_STATUS;
        }
        catch (JSchException e) {
            Status status = new Status(4, "org.eclipse.linuxtools.systemtap.ui.consolelog", Messages.ScpExec_FileTransferFailed, (Throwable)e);
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ScpExec_Error, (String)e.getMessage(), (IStatus)status);
            return status;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.linuxtools.systemtap.ui.consolelog", Messages.ScpExec_FileTransferFailed, (Throwable)e);
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ScpExec_Error, (String)e.getMessage(), (IStatus)status);
            return status;
        }
    }

    public void run() {
        try {
            this.channel.connect();
            this.errorGobbler.start();
            this.inputGobbler.start();
            while (!this.stopped) {
                if (!this.channel.isClosed() && this.channel.getExitStatus() == -1) continue;
                this.stop();
                break;
            }
        }
        catch (JSchException e) {
            ExceptionErrorDialog.openError((String)Messages.ScpExec_errorConnectingToServer, (Exception)((Object)e));
        }
    }

    public synchronized void stop() {
        if (!this.stopped) {
            this.channel.disconnect();
        }
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuilder sb = new StringBuilder();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
        }
        return b;
    }
}

