/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.IDbgpRawListener;
import org.eclipse.dltk.dbgp.IDbgpRawPacket;
import org.eclipse.dltk.dbgp.internal.DbgpTermination;
import org.eclipse.dltk.dbgp.internal.IDbgpDebugingEngine;
import org.eclipse.dltk.dbgp.internal.IDbgpTerminationListener;
import org.eclipse.dltk.dbgp.internal.packets.DbgpNotifyPacket;
import org.eclipse.dltk.dbgp.internal.packets.DbgpPacketReceiver;
import org.eclipse.dltk.dbgp.internal.packets.DbgpPacketSender;
import org.eclipse.dltk.dbgp.internal.packets.DbgpResponsePacket;
import org.eclipse.dltk.dbgp.internal.packets.DbgpStreamPacket;
import org.eclipse.dltk.dbgp.internal.packets.IDbgpRawLogger;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;

public class DbgpDebugingEngine
extends DbgpTermination
implements IDbgpDebugingEngine,
IDbgpTerminationListener {
    private final Socket socket;
    private final DbgpPacketReceiver receiver;
    private final DbgpPacketSender sender;
    private final Object terminatedLock = new Object();
    private boolean terminated = false;
    private final int id;
    private static int lastId = 0;
    private static final Object idLock = new Object();
    private final ListenerList listeners = new ListenerList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbgpDebugingEngine(Socket socket) throws IOException {
        this.socket = socket;
        Object object = idLock;
        synchronized (object) {
            this.id = ++lastId;
        }
        this.receiver = new DbgpPacketReceiver(new BufferedInputStream(socket.getInputStream()));
        this.receiver.setLogger(new IDbgpRawLogger(){

            public void log(IDbgpRawPacket output) {
                DbgpDebugingEngine.this.firePacketReceived(output);
            }
        });
        this.receiver.addTerminationListener(this);
        this.receiver.start();
        this.sender = new DbgpPacketSender(new BufferedOutputStream(socket.getOutputStream()));
        this.sender.setLogger(new IDbgpRawLogger(){

            public void log(IDbgpRawPacket output) {
                DbgpDebugingEngine.this.firePacketSent(output);
            }
        });
        DebugEventHelper.fireExtendedEvent(this, 5);
    }

    public DbgpStreamPacket getStreamPacket() throws IOException, InterruptedException {
        return this.receiver.getStreamPacket();
    }

    public DbgpNotifyPacket getNotifyPacket() throws IOException, InterruptedException {
        return this.receiver.getNotifyPacket();
    }

    public DbgpResponsePacket getResponsePacket(int transactionId, int timeout) throws IOException, InterruptedException {
        return this.receiver.getResponsePacket(transactionId, timeout);
    }

    public void sendCommand(DbgpRequest command) throws IOException {
        this.sender.sendCommand(command);
    }

    public void requestTermination() {
        block2: {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTerminated() throws InterruptedException {
        Object object = this.terminatedLock;
        synchronized (object) {
            if (this.terminated) {
                return;
            }
            this.receiver.waitTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectTerminated(Object object, Exception e) {
        Object object2 = this.terminatedLock;
        synchronized (object2) {
            if (this.terminated) {
                return;
            }
            this.receiver.removeTerminationListener(this);
            try {
                this.receiver.waitTerminated();
            }
            catch (InterruptedException interruptedException) {}
            this.terminated = true;
        }
        this.fireObjectTerminated(e);
    }

    protected void firePacketReceived(IDbgpRawPacket content) {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IDbgpRawListener)list[i]).dbgpPacketReceived(this.id, content);
            ++i;
        }
    }

    protected void firePacketSent(IDbgpRawPacket content) {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IDbgpRawListener)list[i]).dbgpPacketSent(this.id, content);
            ++i;
        }
    }

    public void addRawListener(IDbgpRawListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeRawListenr(IDbgpRawListener listener) {
        this.listeners.remove((Object)listener);
    }
}

