/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.event.metadata.exceptions;

import java.lang.reflect.Field;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.RecognitionException;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.parser.CTFLexer;

public class CtfAntlrException
extends CTFReaderException {
    private static final long serialVersionUID = -7078624493350073777L;
    private int fErrorLine = -1;
    private String fFile = "";
    private String fExpectingName = "";
    private int fExpectedValue = -1;
    private String fActualName = "";
    private int fActualValue = -1;

    public CtfAntlrException(RecognitionException e) {
        super((Exception)((Object)e));
        this.fErrorLine = e.line;
        this.fFile = "metadata";
    }

    public CtfAntlrException(MismatchedTokenException e) {
        super((Exception)((Object)e));
        this.fErrorLine = e.line;
        this.fFile = "metadata";
        this.parseMismatchedException(e);
    }

    private void parseMismatchedException(MismatchedTokenException m) {
        Field[] fieldArray = CTFLexer.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            f.setAccessible(true);
            try {
                String name = f.getName();
                boolean isInt = f.getType().isPrimitive();
                if (isInt) {
                    int value = (Integer)f.get(null);
                    if (value == m.expecting) {
                        this.fExpectingName = name;
                        this.fExpectedValue = value;
                    }
                    if (value == m.c) {
                        this.fActualName = name;
                        this.fActualValue = value;
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (!this.fExpectingName.isEmpty() && !this.fActualName.isEmpty()) {
                return;
            }
            ++n2;
        }
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (this.fErrorLine == -1) {
            return message;
        }
        String expected = "" + this.fExpectedValue;
        String actual = "" + this.fActualValue;
        String newMessage = message.replaceAll(expected, this.fExpectingName);
        newMessage = newMessage.replaceAll(actual, this.fActualName);
        return String.valueOf(newMessage) + " at " + this.fFile + ":" + this.fErrorLine;
    }
}

