/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.views;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.ProbeAliasAction;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.BrowserView;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class ProbeAliasBrowserView
extends BrowserView {
    public static final String ID = "org.eclipse.linuxtools.internal.systemtap.ui.ide.views.ProbeAliasBrowserView";
    private ProbeAliasAction doubleClickAction;
    private Menu menu;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        TapsetLibrary.init();
        TapsetLibrary.addProbeListener(new BrowserView.ViewUpdater());
        this.refresh();
        this.makeActions();
    }

    @Override
    public void refresh() {
        TreeNode probes = TapsetLibrary.getProbes();
        if (probes != null) {
            this.viewer.setInput((Object)TapsetLibrary.getProbes());
        }
    }

    private void makeActions() {
        this.doubleClickAction = new ProbeAliasAction(this.getSite().getWorkbenchWindow(), this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this.doubleClickAction);
        Control control = this.viewer.getControl();
        MenuManager manager = new MenuManager("probePopup");
        manager.add((IContributionItem)new Separator("additions"));
        Menu menu = manager.createContextMenu(control);
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.viewer);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.viewer != null) {
            this.viewer.removeDoubleClickListener((IDoubleClickListener)this.doubleClickAction);
        }
        if (this.doubleClickAction != null) {
            this.doubleClickAction.dispose();
        }
        this.doubleClickAction = null;
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }
}

