/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPAutoEditStrategy;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPColorConstants;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPCompletionProcessor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPElementScanner;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPReconcilingStrategy;
import org.eclipse.linuxtools.systemtap.ui.editor.ColorManager;
import org.eclipse.linuxtools.systemtap.ui.editor.DoubleClickStrategy;

public class STPConfiguration
extends SourceViewerConfiguration {
    private STPElementScanner scanner;
    private ColorManager colorManager;
    private STPEditor editor;
    private DoubleClickStrategy doubleClickStrategy;
    private STPCompletionProcessor processor;

    public STPConfiguration(ColorManager colorManager, STPEditor editor) {
        this.colorManager = colorManager;
        this.editor = editor;
        this.processor = new STPCompletionProcessor();
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__stp_comment", "__stp_string", "__stp_probe"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.processor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.processor, "__stp_probe");
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    protected STPElementScanner getSTPScanner() {
        if (this.scanner == null) {
            this.scanner = new STPElementScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(STPColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        STPReconcilingStrategy strategy = new STPReconcilingStrategy();
        strategy.setEditor(this.editor);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        return reconciler;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new DoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getSTPScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSTPScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__stp_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__stp_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSTPScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__stp_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__stp_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSTPScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__stp_keyword");
        reconciler.setRepairer((IPresentationRepairer)dr, "__stp_keyword");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSTPScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__stp_conditional");
        reconciler.setRepairer((IPresentationRepairer)dr, "__stp_conditional");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSTPScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__stp_probe");
        reconciler.setRepairer((IPresentationRepairer)dr, "__stp_probe");
        return reconciler;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new STPAutoEditStrategy()};
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.processor;
    }
}

