/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.actions;

import java.util.LinkedList;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPerspective;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.RunScriptHandler;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.GraphData;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.listeners.IGobblerListener;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ChartStreamDaemon2;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditor;
import org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class RunScriptChartHandler
extends RunScriptHandler {
    private IDataSet dataSet;
    private IDataSetParser parser;
    private LinkedList<GraphData> graphs;

    public RunScriptChartHandler(IDataSetParser parser, IDataSet dataSet, LinkedList<GraphData> graphs) {
        this.parser = parser;
        this.dataSet = dataSet;
        this.graphs = graphs;
    }

    @Override
    protected void scriptConsoleInitialized(ScriptConsole console) {
        console.getCommand().addInputStreamListener((IGobblerListener)new ChartStreamDaemon2(console, this.dataSet, this.parser));
        try {
            IWorkbenchPage p = PlatformUI.getWorkbench().showPerspective(IDEPerspective.ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            GraphSelectorEditor ivp = (GraphSelectorEditor)p.openEditor((IEditorInput)new GraphSelectorEditorInput(), "org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditor");
            String name = console.getName();
            ivp.createScriptSet(name.substring(name.lastIndexOf(47) + 1), this.dataSet);
            for (GraphData graph : this.graphs) {
                ivp.getActiveDisplaySet().addGraph(graph);
            }
        }
        catch (WorkbenchException we) {
            ExceptionErrorDialog.openError((String)Messages.RunScriptChartAction_couldNotSwitchToGraphicPerspective, (Exception)((Object)we));
        }
    }
}

