/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.actions;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDESessionSettings;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.TreeExpandCollapseAction;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.KernelBrowserView;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class KernelSourceAction
extends Action
implements ISelectionListener,
IDoubleClickListener {
    private static final String CDT_EDITOR_ID = "org.eclipse.cdt.ui.editor.CEditor";
    private final IWorkbenchWindow window;
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.ide.KBAction";
    private KernelBrowserView viewer;
    private IStructuredSelection selection;
    private TreeExpandCollapseAction expandAction;

    public KernelSourceAction(IWorkbenchWindow window, KernelBrowserView browser) {
        this.window = window;
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setText(Localization.getString("KernelSourceAction.Insert"));
        this.setToolTipText(Localization.getString("KernelSourceAction.InsertSelectedFunction"));
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
        this.viewer = browser;
        this.expandAction = new TreeExpandCollapseAction(this.viewer);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection incoming) {
        if (incoming instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)incoming;
            this.setEnabled(this.selection.size() == 1);
        } else {
            this.setEnabled(false);
        }
    }

    public void dispose() {
        this.window.getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    private IEditorInput createEditorInput(IFileStore fs) {
        FileStoreEditorInput input = new FileStoreEditorInput(fs);
        return input;
    }

    public void run() {
        IWorkbench wb = PlatformUI.getWorkbench();
        ISelection incoming = this.viewer.getViewer().getSelection();
        IStructuredSelection selection = (IStructuredSelection)incoming;
        Object o = selection.getFirstElement();
        if (o instanceof TreeNode) {
            TreeNode t = (TreeNode)o;
            if (t.isClickable()) {
                IFileStore fs = (IFileStore)t.getData();
                if (fs != null) {
                    IEditorInput input = this.createEditorInput(fs);
                    try {
                        IEditorPart editor = wb.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                        if (editor instanceof STPEditor) {
                            IDESessionSettings.setActiveSTPEditor((STPEditor)editor);
                        }
                        wb.getActiveWorkbenchWindow().getActivePage().openEditor(input, CDT_EDITOR_ID);
                    }
                    catch (PartInitException e) {
                        ExceptionErrorDialog.openError((String)Messages.TempFileAction_errorDialogTitle, (Exception)((Object)e));
                    }
                }
            } else {
                this.expandAction.run();
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        this.run();
    }
}

