/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.formatter;

import com.naef.jnlua.LuaRuntimeException;
import com.naef.jnlua.LuaState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.koneki.ldt.core.internal.Activator;
import org.eclipse.koneki.ldt.core.internal.formatter.Messages;
import org.eclipse.koneki.ldt.metalua.AbstractMetaLuaModule;

public final class LuaFormatterModule
extends AbstractMetaLuaModule {
    public static final String FORMATTER_PATH = "/script/external";
    public static final String FORMATTER_LIB_NAME = "luaformatter";
    public static final String INDENTATION_FUNTION = "indentcode";
    private LuaState lua = null;

    public String indent(String source, String delimiter, boolean indentInTable, String tabulation) {
        if (this.lua == null) {
            this.lua = this.loadLuaModule();
        }
        this.pushLuaModule(this.lua);
        this.lua.getField(-1, INDENTATION_FUNTION);
        this.lua.pushString(source);
        this.lua.pushString(delimiter);
        this.lua.pushBoolean(indentInTable);
        this.lua.pushString(tabulation);
        try {
            this.lua.call(4, 1);
        }
        catch (LuaRuntimeException e) {
            Activator.logWarning(Messages.LuaSourceFormatIndentationError, e);
            return source;
        }
        String formattedCode = this.lua.toString(-1);
        return formattedCode;
    }

    public String indent(String source, String delimiter, boolean indentInTable, int tabSize, int indentationSize) {
        if (this.lua == null) {
            this.lua = this.loadLuaModule();
        }
        this.pushLuaModule(this.lua);
        this.lua.getField(-1, INDENTATION_FUNTION);
        this.lua.pushString(source);
        this.lua.pushString(delimiter);
        this.lua.pushBoolean(indentInTable);
        this.lua.pushInteger(tabSize);
        this.lua.pushInteger(indentationSize);
        try {
            this.lua.call(5, 1);
        }
        catch (LuaRuntimeException e) {
            Activator.logWarning(Messages.LuaSourceFormatIndentationError, e);
            return source;
        }
        String formattedCode = this.lua.toString(-1);
        return formattedCode;
    }

    protected List<String> getLuaSourcePaths() {
        ArrayList<String> sourcepaths = new ArrayList<String>();
        sourcepaths.add(FORMATTER_PATH);
        return sourcepaths;
    }

    protected List<String> getLuacSourcePaths() {
        return null;
    }

    protected String getPluginID() {
        return "org.eclipse.koneki.ldt";
    }

    protected String getModuleName() {
        return FORMATTER_LIB_NAME;
    }

    protected List<String> getMetaLuaSourcePaths() {
        return Collections.emptyList();
    }

    protected List<String> getMetaLuaFileToCompile() {
        return Collections.emptyList();
    }
}

