/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceSessionState;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.IImportDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.ImportFileInfo;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.TraceControlDialogFactory;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.BaseControlViewHandler;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.CommandParameter;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionComponent;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ImportHandler
extends BaseControlViewHandler {
    protected CommandParameter fParam;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        this.fLock.lock();
        try {
            CommandParameter param = this.fParam.clone();
            final IImportDialog dialog = TraceControlDialogFactory.getInstance().getImportDialog();
            dialog.setSession(param.getSession());
            if (dialog.open() != 0 || param.getSession().isStreamedTrace()) {
                return null;
            }
            Job job = new Job(Messages.TraceControl_ImportJob){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        List<ImportFileInfo> traces = dialog.getTracePathes();
                        IProject project = dialog.getProject();
                        for (ImportFileInfo remoteFile : traces) {
                            ImportHandler.downloadTrace(remoteFile, project);
                        }
                    }
                    catch (ExecutionException e) {
                        return new Status(4, "org.eclipse.linuxtools.lttng2.ui", Messages.TraceControl_ImportFailure, (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        TraceSessionComponent session = null;
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceSessionComponent tmpSession;
                if (!(element instanceof TraceSessionComponent) || (tmpSession = (TraceSessionComponent)element).getSessionState() != TraceSessionState.INACTIVE || tmpSession.isDestroyed()) continue;
                session = tmpSession;
            }
        }
        boolean isEnabled = session != null;
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new CommandParameter(session);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }

    private static void downloadTrace(ImportFileInfo trace, IProject project) throws ExecutionException {
        try {
            IRemoteFileSubSystem fsss = trace.getImportFile().getParentRemoteFileSubSystem();
            IFolder traceFolder = project.getFolder("Traces");
            if (!traceFolder.exists()) {
                throw new ExecutionException(String.valueOf(Messages.TraceControl_ImportDialogInvalidTracingProject) + " (" + "Traces" + ")");
            }
            String traceName = trace.getLocalTraceName();
            IFolder folder = traceFolder.getFolder(traceName);
            if (folder.exists()) {
                if (!trace.isOverwrite()) {
                    throw new ExecutionException(String.valueOf(Messages.TraceControl_ImportDialogTraceAlreadyExistError) + ": " + traceName);
                }
            } else {
                folder.create(true, true, null);
            }
            IRemoteFile[] sources = fsss.list(trace.getImportFile(), 1, (IProgressMonitor)new NullProgressMonitor());
            String[] destinations = new String[sources.length];
            String[] encodings = new String[sources.length];
            int i = 0;
            while (i < sources.length) {
                destinations[i] = folder.getLocation().addTrailingSeparator().append(sources[i].getName()).toString();
                encodings[i] = null;
                ++i;
            }
            fsss.downloadMultiple(sources, destinations, encodings, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SystemMessageException e) {
            throw new ExecutionException(e.toString(), (Throwable)e);
        }
        catch (CoreException e) {
            throw new ExecutionException(e.toString(), (Throwable)e);
        }
    }
}

