/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.view.fields;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractPercentageDrawerField;
import org.eclipse.linuxtools.dataviewers.charts.provider.IChartField;
import org.eclipse.linuxtools.internal.gprof.Messages;
import org.eclipse.linuxtools.internal.gprof.view.histogram.TreeElement;

public class RatioProfField
extends AbstractPercentageDrawerField
implements IChartField {
    public static final NumberFormat nf = new DecimalFormat("##0.0#");

    public float getPercentage(Object obj) {
        TreeElement e = (TreeElement)obj;
        int SamplesSum = e.getRoot().getSamples();
        if (SamplesSum == 0) {
            return 0.0f;
        }
        return 100.0f * (float)e.getSamples() / (float)e.getRoot().getSamples();
    }

    public int compare(Object obj1, Object obj2) {
        TreeElement e1 = (TreeElement)obj1;
        TreeElement e2 = (TreeElement)obj2;
        int s1 = e1.getSamples();
        int s2 = e2.getSamples();
        return s1 - s2;
    }

    public String getColumnHeaderText() {
        return Messages.RatioProfField_TIME_PERCENTAGE;
    }

    public NumberFormat getNumberFormat() {
        return nf;
    }

    public boolean isSettedNumberFormat() {
        return true;
    }

    public Number getNumber(Object obj) {
        float f = this.getPercentage(obj);
        return new Float(f);
    }
}

