/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.parser;

import java.io.DataInput;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.linuxtools.internal.gprof.Messages;
import org.eclipse.linuxtools.internal.gprof.parser.GmonDecoder;
import org.eclipse.linuxtools.internal.gprof.symbolManager.Bucket;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistRoot;

public class HistogramDecoder {
    private static final int GMON_HDRSIZE_BSD44 = 12;
    private static final int GMON_HDRSIZE_BSD44_32 = 32;
    private static final int GMON_HDRSIZE_BSD44_64 = 40;
    private static final int GMON_HDRSIZE_OLDBSD_32 = 12;
    private static final int GMON_HDRSIZE_OLDBSD_64 = 20;
    protected final GmonDecoder decoder;
    protected long lowpc;
    protected long highpc;
    protected int prof_rate;
    protected String dimen;
    protected char dimen_abbrev;
    protected boolean initialized = false;
    protected int[] hist_sample;
    protected double total_time;
    protected long bucketSize;

    public HistogramDecoder(GmonDecoder decoder) {
        this.decoder = decoder;
    }

    protected long readAddress(DataInput stream) throws IOException {
        long ret = (long)stream.readInt() & 0xFFFFFFFFL;
        return ret;
    }

    public boolean hasValues() {
        return this.hist_sample != null && this.hist_sample.length > 0;
    }

    public void decodeHeader(DataInput stream) throws IOException {
        long lowpc = this.readAddress(stream);
        long highpc = this.readAddress(stream);
        int hist_num_bins = stream.readInt();
        int prof_rate = stream.readInt();
        byte[] bytes = new byte[15];
        stream.readFully(bytes);
        byte b = stream.readByte();
        if (!this.isCompatible(lowpc, highpc, prof_rate, hist_num_bins)) {
            throw new RuntimeException(Messages.HistogramDecoder_INCOMPATIBLE_HIST_HEADER_ERROR_MSG);
        }
        this.lowpc = lowpc;
        this.highpc = highpc;
        this.prof_rate = prof_rate;
        this.hist_sample = new int[hist_num_bins];
        this.dimen = new String(bytes);
        this.dimen_abbrev = (char)b;
        long temp = highpc - lowpc;
        this.bucketSize = Math.round((double)temp / (double)hist_num_bins);
    }

    public void decodeOldHeader(DataInput stream) throws IOException {
        int header_size;
        long low_pc = this.readAddress(stream);
        long high_pc = this.readAddress(stream);
        int ncnt = stream.readInt();
        int version = stream.readInt();
        int profrate = 0;
        if (version == 333945) {
            profrate = stream.readInt();
            stream.skipBytes(12);
            header_size = this.decoder._32_bit_platform ? 32 : 40;
        } else {
            header_size = this.decoder._32_bit_platform ? 12 : 20;
        }
        int samp_bytes = ncnt - header_size;
        int hist_num_bins = samp_bytes / 2;
        if (!this.isCompatible(low_pc, high_pc, profrate, hist_num_bins)) {
            throw new RuntimeException(Messages.HistogramDecoder_INCOMPATIBLE_HIST_HEADER_ERROR_MSG);
        }
        this.lowpc = low_pc;
        this.highpc = high_pc;
        this.prof_rate = profrate;
        this.hist_sample = new int[hist_num_bins];
        this.dimen = "s";
        this.dimen_abbrev = (char)115;
        long temp = this.highpc - this.lowpc;
        this.bucketSize = Math.round((double)temp / (double)hist_num_bins);
    }

    public boolean isCompatible(long lowpc, long highpc, int profrate, int sample_count) {
        if (!this.initialized) {
            return true;
        }
        return this.lowpc == lowpc && this.highpc == highpc && this.prof_rate == profrate && this.hist_sample.length == sample_count;
    }

    public void decodeHistRecord(DataInput stream) throws IOException {
        int i = 0;
        while (i < this.hist_sample.length) {
            short _rv = stream.readShort();
            if (_rv != 0) {
                int hist_size = _rv & 0xFFFF;
                int n = i;
                this.hist_sample[n] = this.hist_sample[n] + hist_size;
            }
            ++i;
        }
    }

    public void printHistHeader(PrintStream ps) {
        ps.println(" \nHistogram Header : \n");
        ps.print("  Base pc address of sample buffer = 0x");
        ps.println(Long.toHexString(this.lowpc));
        ps.print("  Max pc address of sampled buffer = 0x");
        ps.println(Long.toHexString(this.highpc));
        ps.print("  Number of histogram samples      = ");
        ps.println(this.hist_sample.length);
        ps.print("  Profiling clock rate             = ");
        ps.println(this.prof_rate);
        ps.print("  Physical dimension abreviation : 's' for \"seconds\"  'm' for \"milliseconds\" = ");
        ps.println(this.dimen_abbrev);
    }

    public void printHistRecords(PrintStream ps) {
        ps.println();
        ps.println(" ==  HISTOGRAM RECORDS  == ");
        ps.println(" ========================= ");
        this.printHistHeader(ps);
    }

    public void AssignSamplesSymbol() {
        if (this.hist_sample == null || this.hist_sample.length == 0) {
            return;
        }
        IBinaryParser.ISymbol[] symblist = this.decoder.getProgram().getSymbols();
        int j = 1;
        int i = 0;
        while (i < this.hist_sample.length) {
            int ccnt = this.hist_sample[i];
            if (ccnt != 0) {
                long pcl = this.lowpc + this.bucketSize * (long)i;
                long pch = pcl + this.bucketSize;
                this.total_time += (double)ccnt;
                long svalue1 = symblist[j - 1].getAddress().getValue().longValue();
                --j;
                while (j < symblist.length - 1) {
                    long start_addr;
                    long end_addr;
                    long overlap;
                    long svalue0 = svalue1;
                    svalue1 = symblist[j + 1].getAddress().getValue().longValue();
                    if (pch < svalue0) break;
                    if (pcl < svalue1 && (overlap = (end_addr = pch < svalue1 ? pch : svalue1) - (start_addr = pcl > svalue0 ? pcl : svalue0)) > 0L) {
                        IBinaryParser.ISymbol symbol = symblist[j];
                        int time = (int)(overlap * (long)ccnt / this.bucketSize);
                        Bucket bck = new Bucket(start_addr, end_addr, time);
                        this.addBucket(bck, symbol);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addBucket(Bucket b, IBinaryParser.ISymbol s) {
        HistRoot root = this.decoder.getRootNode();
        root.addBucket(b, s, this.decoder.getProgram());
    }

    public int getProf_rate() {
        return this.prof_rate;
    }

    public char getTimeDimension() {
        return this.dimen_abbrev;
    }

    public long getBucketSize() {
        return this.bucketSize;
    }
}

