/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.parser;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.internal.gprof.Messages;
import org.eclipse.linuxtools.internal.gprof.parser.CallGraphDecoder;
import org.eclipse.linuxtools.internal.gprof.parser.CallGraphDecoder_64;
import org.eclipse.linuxtools.internal.gprof.parser.HistogramDecoder;
import org.eclipse.linuxtools.internal.gprof.parser.HistogramDecoder_64;
import org.eclipse.linuxtools.internal.gprof.utils.LEDataInputStream;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistRoot;

public class GmonDecoder {
    public static final int VPF_GMON_RECORD_TYPE_HISTOGRAM = 0;
    public static final int VPF_GMON_RECORD_TYPE_CALLGRAPH = 1;
    public static final int VPF_GMON_RECORD_TYPE_UNKNOWN = -1;
    public static final int GMONVERSION = 333945;
    private String cookie;
    private int gmon_version;
    private byte[] spare;
    private final IBinaryParser.IBinaryObject program;
    final boolean _32_bit_platform;
    private HistogramDecoder histo;
    private CallGraphDecoder callGraph;
    private final PrintStream ps;
    private final HistRoot rootNode = new HistRoot(this);
    private String file;
    private int tag = -1;
    private final HashMap<IBinaryParser.ISymbol, String> filenames = new HashMap();
    private final IProject project;
    private boolean shouldDump = false;

    public GmonDecoder(IBinaryParser.IBinaryObject program, IProject project) {
        this(program, null, project);
    }

    public GmonDecoder(IBinaryParser.IBinaryObject program, PrintStream ps, IProject project) {
        this.program = program;
        this.ps = ps;
        this.project = project;
        program.getBinaryParser().getFormat();
        String cpu = program.getCPU();
        if ("x86_64".equals(cpu) || "ppc64".equals(cpu)) {
            this.histo = new HistogramDecoder_64(this);
            this.callGraph = new CallGraphDecoder_64(this);
            this._32_bit_platform = false;
        } else {
            this._32_bit_platform = true;
            this.histo = new HistogramDecoder(this);
            this.callGraph = new CallGraphDecoder(this);
        }
    }

    public void read(String file) throws IOException {
        this.file = file;
        DataInputStream beStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        if (this.program.isLittleEndian()) {
            LEDataInputStream leStream = new LEDataInputStream(beStream);
            leStream.mark(1000);
            boolean gmonType = this.readHeader(leStream);
            if (gmonType) {
                this.ReadGmonContent(leStream);
            } else {
                leStream.reset();
                this.histo.decodeOldHeader(leStream);
                this.histo.decodeHistRecord(leStream);
                try {
                    while (true) {
                        this.callGraph.decodeCallGraphRecord(leStream, true);
                    }
                }
                catch (EOFException eOFException) {
                    this.callGraph.populate(this.rootNode);
                    this.histo.AssignSamplesSymbol();
                }
            }
            leStream.close();
        } else {
            beStream.mark(1000);
            boolean gmonType = this.readHeader(beStream);
            if (gmonType) {
                this.ReadGmonContent(beStream);
            } else {
                beStream.reset();
                this.histo.decodeOldHeader(beStream);
                this.histo.decodeHistRecord(beStream);
                try {
                    while (true) {
                        this.callGraph.decodeCallGraphRecord(beStream, true);
                    }
                }
                catch (EOFException eOFException) {
                    this.callGraph.populate(this.rootNode);
                    this.histo.AssignSamplesSymbol();
                }
            }
            beStream.close();
        }
    }

    public boolean readHeader(DataInput stream) throws IOException {
        byte[] _cookie = new byte[4];
        stream.readFully(_cookie);
        this.cookie = new String(_cookie);
        this.gmon_version = stream.readInt();
        this.spare = new byte[12];
        stream.readFully(this.spare);
        return "gmon".equals(this.cookie);
    }

    public void ReadGmonContent(DataInput stream) throws IOException {
        while (true) {
            this.tag = -1;
            try {
                this.tag = stream.readByte();
            }
            catch (EOFException eOFException) {
                break;
            }
            switch (this.tag) {
                case 0: {
                    this.histo.decodeHeader(stream);
                    this.histo.decodeHistRecord(stream);
                    break;
                }
                case 1: {
                    this.callGraph.decodeCallGraphRecord(stream, false);
                    break;
                }
                default: {
                    throw new IOException(Messages.GmonDecoder_BAD_TAG_ERROR);
                }
            }
            if (!this.shouldDump) continue;
            this.dumpGmonResult(this.ps == null ? System.out : this.ps);
        }
        this.callGraph.populate(this.rootNode);
        this.histo.AssignSamplesSymbol();
    }

    public void dumpGmonResult(PrintStream ps) {
        ps.println("-- gmon Results --");
        ps.println("cookie " + this.cookie);
        ps.println("gmon_version " + this.gmon_version);
        ps.println("tag " + this.tag);
        switch (this.tag) {
            case 0: {
                this.histo.printHistHeader(ps);
                this.histo.printHistRecords(ps);
                break;
            }
        }
    }

    public HistogramDecoder getHistogramDecoder() {
        return this.histo;
    }

    public CallGraphDecoder getCallGraphDecoder() {
        return this.callGraph;
    }

    public IBinaryParser.IBinaryObject getProgram() {
        return this.program;
    }

    public HistRoot getRootNode() {
        return this.rootNode;
    }

    public int getGmonVersion() {
        return this.gmon_version;
    }

    public String getGmonFile() {
        return this.file;
    }

    public String getFileName(IBinaryParser.ISymbol s) {
        String ret = this.filenames.get(s);
        if (ret == null) {
            ret = STSymbolManager.sharedInstance.getFilename(s, this.project);
            if (ret == null) {
                ret = "??";
            }
            this.filenames.put(s, ret);
        }
        return ret;
    }

    public void setShouldDump(boolean shouldDump) {
        this.shouldDump = shouldDump;
    }

    public IProject getProject() {
        return this.project;
    }
}

