/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.cache.SignedAsBlobJarFile;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.security.EnhancedJarVerifier;
import com.sun.deploy.security.JarAsBLOBVerifier;
import com.sun.deploy.security.SimpleJarVerifier;
import com.sun.deploy.util.BlackList;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import sun.misc.JavaUtilJarAccess;
import sun.misc.SharedSecrets;

public abstract class JarVerifier {
    protected File jarFile;
    protected File nativePath;
    protected URL jarLocation;
    protected String jarVersion;
    protected boolean hasSingleCodeSource = false;
    protected boolean hasOnlySignedEntries = false;
    protected boolean hasMissingSignedEntries = false;
    protected Manifest manifest;
    protected Map signerMapCert = new HashMap();
    protected Map codeSourceCertCache = new HashMap();
    protected int[] singleSignerIndicesCert;
    protected List signerCerts = new ArrayList();
    protected Map signerMap = new HashMap();
    protected Map codeSourceCache = new HashMap();
    protected List signersCS = new ArrayList();
    protected int[] singleSignerIndicesCS;
    private static boolean TEST_INJECT_HAS_UNSIGNED = false;

    protected JarVerifier(URL uRL, String string, File file, File file2) {
        this.jarFile = file;
        this.nativePath = file2;
        this.jarLocation = uRL;
        this.jarVersion = string;
    }

    public URL getJarLocation() {
        return this.jarLocation;
    }

    public String getJarVersion() {
        return this.jarVersion;
    }

    public abstract void validate(DownloadDelegate var1) throws IOException, JARSigningException;

    public Manifest getManifest() {
        return this.manifest;
    }

    public Map getSignerMapCert() {
        return this.signerMapCert;
    }

    public Map getCodeSourceCertCache() {
        return this.codeSourceCertCache;
    }

    public Map getSignerMap() {
        return this.signerMap;
    }

    public Map getCodeSourceCache() {
        return this.codeSourceCache;
    }

    public List getSignerCerts() {
        return this.signerCerts;
    }

    public List getSignersCS() {
        return this.signersCS;
    }

    public int[] getSingleSignerIndicesCert() {
        return this.singleSignerIndicesCert;
    }

    public int[] getSingleSignerIndicesCS() {
        return this.singleSignerIndicesCS;
    }

    public boolean hasOnlySignedEntries() {
        if (TEST_INJECT_HAS_UNSIGNED) {
            return false;
        }
        return this.hasOnlySignedEntries;
    }

    public boolean hasSingleCodeSource() {
        return this.hasSingleCodeSource;
    }

    public boolean hasMissingSignedEntries() {
        return this.hasMissingSignedEntries;
    }

    public static JarVerifier create(URL uRL, String string, File file, File file2) {
        JarVerifier jarVerifier = JarAsBLOBVerifier.create(uRL, string, file, file2);
        if (jarVerifier == null && (jarVerifier = EnhancedJarVerifier.create(uRL, string, file, file2)) == null) {
            jarVerifier = SimpleJarVerifier.create(uRL, string, file, file2);
        }
        return jarVerifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readAndMaybeSaveStreamTo(InputStream inputStream, boolean bl, String string, File file) throws IOException {
        FilterOutputStream filterOutputStream = null;
        byte[] byArray = new byte[16384];
        try {
            int n;
            File file2;
            if (bl && file != null && (file2 = new File(file, string).getCanonicalFile()).getParentFile().equals(file)) {
                file2.getParentFile().mkdirs();
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            }
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                if (filterOutputStream == null) continue;
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
                filterOutputStream = null;
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    protected void processCertificates(JarFile jarFile, JarEntry jarEntry, String string) throws MalformedURLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Certificate[] certificateArray = null;
        if (this.hasSingleCodeSource) {
            this.signerMapCert.put(string, this.singleSignerIndicesCert);
        } else {
            Object object;
            if (jarEntry != null) {
                certificateArray = jarEntry.getCertificates();
            } else {
                object = null;
                JavaUtilJarAccess javaUtilJarAccess = SharedSecrets.javaUtilJarAccess();
                object = javaUtilJarAccess.getCodeSource(jarFile, this.jarLocation, string);
                Certificate[] certificateArray2 = certificateArray = object != null ? ((CodeSource)object).getCertificates() : null;
            }
            if (certificateArray != null && certificateArray.length > 0) {
                int n;
                object = new int[certificateArray.length];
                for (int i = 0; i < certificateArray.length; ++i) {
                    n = this.signerCerts.indexOf(certificateArray[i]);
                    if (n == -1) {
                        n = this.signerCerts.size();
                        this.signerCerts.add(certificateArray[i]);
                    }
                    object[i] = n;
                }
                String string2 = String.valueOf(((Object)object).length);
                for (n = 0; n < ((Object)object).length; ++n) {
                    string2 = string2 + " " + (int)object[n];
                }
                int[] nArray = (int[])hashMap.get(string2);
                if (nArray == null) {
                    hashMap.put(string2, object);
                    CodeSource codeSource = new CodeSource(this.jarLocation, certificateArray);
                    this.codeSourceCertCache.put(object, codeSource);
                } else {
                    object = nArray;
                }
                this.signerMapCert.put(string, object);
            }
        }
    }

    protected void processSigners(JarFile jarFile, JarEntry jarEntry, String string) throws MalformedURLException {
        if (!Config.isJavaVersionAtLeast15()) {
            return;
        }
        CodeSigner[] codeSignerArray = null;
        HashMap<String, JavaUtilJarAccess> hashMap = new HashMap<String, JavaUtilJarAccess>();
        if (this.hasSingleCodeSource) {
            this.signerMap.put(string, this.singleSignerIndicesCS);
        } else {
            Object object;
            if (jarEntry != null) {
                codeSignerArray = jarEntry.getCodeSigners();
            } else {
                object = SharedSecrets.javaUtilJarAccess();
                CodeSource codeSource = object.getCodeSource(jarFile, this.jarLocation, string);
                CodeSigner[] codeSignerArray2 = codeSignerArray = codeSource != null ? codeSource.getCodeSigners() : null;
            }
            if (codeSignerArray != null && codeSignerArray.length > 0) {
                int n;
                object = new int[codeSignerArray.length];
                for (int i = 0; i < codeSignerArray.length; ++i) {
                    n = this.signersCS.indexOf(codeSignerArray[i]);
                    if (n == -1) {
                        n = this.signersCS.size();
                        this.signersCS.add(codeSignerArray[i]);
                    }
                    object[i] = (JavaUtilJarAccess)n;
                }
                String string2 = String.valueOf(((JavaUtilJarAccess)object).length);
                for (n = 0; n < ((JavaUtilJarAccess)object).length; ++n) {
                    string2 = string2 + " " + (int)object[n];
                }
                int[] nArray = (int[])hashMap.get(string2);
                if (nArray == null) {
                    hashMap.put(string2, (JavaUtilJarAccess)object);
                    CodeSource codeSource = new CodeSource(this.jarLocation, codeSignerArray);
                    this.codeSourceCache.put(object, codeSource);
                } else {
                    object = nArray;
                }
                this.signerMap.put(string, object);
            }
        }
    }

    protected void authenticateJarEntry(JarFile jarFile, JarEntry jarEntry) throws IOException, JARSigningException {
        if (jarEntry == null) {
            return;
        }
        String string = jarEntry.getName();
        boolean bl = this.nativePath != null && string.indexOf("/") == -1 && string.indexOf("\\") == -1;
        try {
            JarVerifier.readAndMaybeSaveStreamTo(jarFile.getInputStream(jarEntry), bl, string, this.nativePath);
        }
        catch (SecurityException securityException) {
            throw new JARSigningException(this.jarLocation, this.jarVersion, 2, securityException);
        }
    }

    public static JarFile getValidatedJarFile(File file, URL uRL, URL uRL2, String string, DownloadDelegate downloadDelegate) throws IOException {
        boolean bl = false;
        JarVerifier jarVerifier = JarVerifier.create(uRL2, string, file, null);
        JarFile jarFile = new JarFile(file);
        if (downloadDelegate != null) {
            downloadDelegate.validating(uRL, 0, jarFile.size());
        }
        try {
            jarVerifier.validate(downloadDelegate);
            if (jarVerifier instanceof JarAsBLOBVerifier) {
                jarFile = new SignedAsBlobJarFile(file, (JarAsBLOBVerifier)jarVerifier);
            }
            if (BlackList.getInstance().checkJarFile(jarFile)) {
                JarFile jarFile2 = null;
                return jarFile2;
            }
            bl = true;
        }
        catch (ZipException zipException) {
            throw new JARSigningException(uRL, string, 2, zipException);
        }
        catch (SecurityException securityException) {
            throw new JARSigningException(uRL, string, 2, securityException);
        }
        finally {
            if (!bl) {
                jarFile.close();
                DownloadEngine.clearTemporaryResourceMaps(uRL);
            }
        }
        return bl ? jarFile : null;
    }
}

