/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.annotatedsourceeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.IAnnotationProvider;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.IEditorInputWithAnnotations;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.ISTAnnotationColumn;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.STAnnotatedSourceEditorActivator;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.STChangeRulerColumn;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.STContributedRulerColumn;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.STOverviewRuler;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.rulers.IContributedRulerColumn;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;
import org.eclipse.ui.texteditor.rulers.RulerColumnRegistry;

public class STAnnotatedCSourceEditor
extends CEditor
implements LineBackgroundListener {
    public static final String ST_RULER = "STRuler";
    private STColumnSupport fColumnSupport;
    private STContributedRulerColumn fColumn;
    private IAnnotationProvider fAnnotationProvider;
    private STChangeRulerColumn fSTChangeRulerColumn;

    public void createPartControl(Composite parent) {
        ISourceViewer sv;
        super.createPartControl(parent);
        if (this.fAnnotationProvider == null) {
            return;
        }
        STColumnSupport columnSupport = this.getSTColumnSupport();
        RulerColumnRegistry registry = RulerColumnRegistry.getDefault();
        RulerColumnDescriptor abstractSTColumnDescriptor = registry.getColumnDescriptor("org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.column");
        columnSupport.addSTColumn((CompositeRuler)this.getVerticalRuler(), abstractSTColumnDescriptor, this.fAnnotationProvider.getColumn());
        CompositeRuler vr = (CompositeRuler)super.getVerticalRuler();
        Iterator iter = vr.getDecoratorIterator();
        while (iter.hasNext()) {
            STContributedRulerColumn fSTColumn;
            IVerticalRulerColumn column = (IVerticalRulerColumn)iter.next();
            if (!(column instanceof STContributedRulerColumn) || !(fSTColumn = (STContributedRulerColumn)column).isShowingSTRuler()) continue;
            ToolTipSupport.enableFor(fSTColumn);
        }
        this.showLinesColored();
        if (this.getSourceViewer() != null && (sv = this.getSourceViewer()).getTextWidget() != null) {
            sv.getTextWidget().addLineBackgroundListener((LineBackgroundListener)this);
        }
    }

    private STColumnSupport getSTColumnSupport() {
        if (this.fColumnSupport == null) {
            this.fColumnSupport = new STColumnSupport(this, RulerColumnRegistry.getDefault());
        }
        return this.fColumnSupport;
    }

    protected STChangeRulerColumn createSTRulerColumn(ISTAnnotationColumn annotationColumn) {
        this.fSTChangeRulerColumn = new STChangeRulerColumn(this.getSharedColors(), annotationColumn);
        this.fSTChangeRulerColumn.setHover((IAnnotationHover)this.createChangeHover());
        this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        return this.fSTChangeRulerColumn;
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        if (this.fAnnotationProvider != null) {
            StyledTextContent c = (StyledTextContent)event.data;
            int line = c.getLineAtOffset(event.lineOffset);
            event.lineBackground = this.fAnnotationProvider.getColor(line);
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (input != null && input instanceof IEditorInputWithAnnotations) {
            this.fAnnotationProvider = ((IEditorInputWithAnnotations)input).createAnnotationProvider();
        }
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        return new STOverviewRuler(this.getAnnotationAccess(), 12, sharedColors);
    }

    private void showLinesColored() {
        STOverviewRuler or = (STOverviewRuler)this.getOverviewRuler();
        IAnnotationModel am = or.getModel();
        IDocument doc = this.getSourceViewer().getDocument();
        int lines = doc.getNumberOfLines();
        int i = 0;
        while (i < lines) {
            try {
                Color color = this.fAnnotationProvider.getColor(i);
                int r = color.getRed();
                int g = color.getGreen();
                int b = color.getBlue();
                if (r != 255 || g != 255 || b != 255) {
                    int offset = doc.getLineOffset(i);
                    String type = "org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.coloredLines";
                    Annotation annotation = new Annotation(type, true, "");
                    or.setAnnotationColor(annotation, color);
                    am.addAnnotation(annotation, new Position(offset));
                }
            }
            catch (BadLocationException e) {
                Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.annotatedsourceeditor", 4, e.getMessage(), (Throwable)e);
                STAnnotatedSourceEditorActivator.getDefault().getLog().log((IStatus)s);
            }
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fAnnotationProvider != null) {
            this.fAnnotationProvider.dispose();
        }
    }

    protected class STColumnSupport
    extends AbstractTextEditor.ColumnSupport {
        private final STAnnotatedCSourceEditor fEditor;
        private final RulerColumnRegistry fRegistry;
        private final ArrayList<ISTAnnotationColumn> fColumns;

        public STColumnSupport(STAnnotatedCSourceEditor editor, RulerColumnRegistry registry) {
            super((AbstractTextEditor)editor, registry);
            this.fEditor = editor;
            this.fRegistry = registry;
            this.fColumns = new ArrayList();
        }

        private int computeIndex(CompositeRuler ruler, RulerColumnDescriptor descriptor) {
            int index = 0;
            List all = this.fRegistry.getColumnDescriptors();
            int newPos = all.indexOf(descriptor);
            Iterator it = ruler.getDecoratorIterator();
            while (it.hasNext()) {
                RulerColumnDescriptor rcd;
                IVerticalRulerColumn column = (IVerticalRulerColumn)it.next();
                if (column instanceof IContributedRulerColumn ? (rcd = ((IContributedRulerColumn)column).getDescriptor()) != null && all.indexOf(rcd) > newPos : "org.eclipse.jface.text.source.projection.ProjectionRulerColumn".equals(column.getClass().getName())) break;
                ++index;
            }
            return index;
        }

        public void addSTColumn(final CompositeRuler ruler, final RulerColumnDescriptor descriptor, final ISTAnnotationColumn annotationColumn) {
            final int idx = this.computeIndex(ruler, descriptor);
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    IContributedRulerColumn column = descriptor.createColumn((ITextEditor)STColumnSupport.this.fEditor);
                    STColumnSupport.this.fColumns.add(annotationColumn);
                    STColumnSupport.this.initializeColumn(column);
                    ruler.addDecorator(idx, (IVerticalRulerColumn)column);
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }

        protected void initializeColumn(IContributedRulerColumn column) {
            super.initializeColumn(column);
            RulerColumnDescriptor descriptor = column.getDescriptor();
            IVerticalRuler ruler = STAnnotatedCSourceEditor.this.getVerticalRuler();
            if (ruler instanceof CompositeRuler && "org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.column".equals(descriptor.getId())) {
                STAnnotatedCSourceEditor.this.fColumn = (STContributedRulerColumn)column;
                STChangeRulerColumn fDelegate = null;
                if (this.fColumns != null && this.fColumns.size() > 0) {
                    fDelegate = STAnnotatedCSourceEditor.this.createSTRulerColumn(this.fColumns.get(this.fColumns.size() - 1));
                }
                STAnnotatedCSourceEditor.this.fColumn.setSTColumn(fDelegate);
            }
        }
    }

    private static class ToolTipSupport
    extends DefaultToolTip {
        private final STContributedRulerColumn control;

        protected ToolTipSupport(STContributedRulerColumn control, int style, boolean manualActivation) {
            super(control.getControl(), style, manualActivation);
            this.control = control;
        }

        protected Object getToolTipArea(Event event) {
            int line = this.control.toDocumentLineNumber(event.y);
            return new ToolTipArea(line, this.control.getAnnotationColumn(line));
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)new FillLayout());
            Label b = new Label(comp, 0);
            ToolTipArea area = (ToolTipArea)this.getToolTipArea(event);
            if (area != null && area.getToolTip().trim().length() > 0) {
                b.setText(area.getToolTip());
            }
            return comp;
        }

        public static void enableFor(STContributedRulerColumn control) {
            new ToolTipSupport(control, 2, false);
        }

        static class ToolTipArea {
            final int line;
            final ISTAnnotationColumn ac;

            ToolTipArea(int line, ISTAnnotationColumn ac) {
                this.line = line;
                this.ac = ac;
            }

            public String getToolTip() {
                return this.ac.getTooltip(this.line);
            }
        }
    }
}

