/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch;

import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.IRemoteProxyManager;
import org.eclipse.linuxtools.profiling.launch.RemoteConnectionException;
import org.eclipse.linuxtools.profiling.launch.RemoteMessages;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteConnection {
    private IRemoteProxyManager rmtProxyMgr;
    private IRemoteCommandLauncher rmtCmdLauncher;
    private IRemoteFileProxy rmtFileProxy;
    private static final String ENV_CMD = "/bin/env";
    private static final String WHICH_CMD = "which";
    private static final String PATH_ENV_VAR = "PATH";
    private static final String SEPARATOR = ":";

    public RemoteConnection(URI uri) throws RemoteConnectionException {
        try {
            this.rmtProxyMgr = RemoteProxyManager.getInstance();
            this.rmtCmdLauncher = this.rmtProxyMgr.getLauncher(uri);
            this.rmtFileProxy = this.rmtProxyMgr.getFileProxy(uri);
        }
        catch (CoreException e) {
            throw new RemoteConnectionException(RemoteMessages.RemoteConnection_failed, e);
        }
    }

    private void copyFileFromRemoteHost(String remotePath, String localPath, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        try {
            IFileSystem localFS = EFS.getLocalFileSystem();
            IFileStore localFile = localFS.getStore(Path.fromOSString((String)localPath));
            IFileStore rmtFile = this.rmtFileProxy.getResource(remotePath);
            rmtFile.copy(localFile, 2, (IProgressMonitor)progress);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void upload(IPath localPath, IPath remotePath, IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            this.copyFileToRemoteHost(localPath.toOSString(), remotePath.toOSString(), monitor);
        }
        catch (CoreException e) {
            throw new RemoteConnectionException(e.getLocalizedMessage(), e);
        }
    }

    public void createFolder(IPath remoteFolderPath, IProgressMonitor monitor) throws RemoteConnectionException {
        IFileStore remoteFolder = this.rmtFileProxy.getResource(remoteFolderPath.toString());
        try {
            remoteFolder.mkdir(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new RemoteConnectionException(e.getLocalizedMessage(), e);
        }
    }

    public static String[] getLines(String buffer) {
        int numLines = 0;
        char[] cArray = buffer.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\n') {
                ++numLines;
            }
            ++n2;
        }
        String[] lines = new String[numLines];
        int line = 0;
        int startOfString = 0;
        int endOfString = 0;
        while (endOfString < buffer.length()) {
            if (buffer.charAt(endOfString) == '\n') {
                lines[line++] = new String(buffer.toCharArray(), startOfString, endOfString - startOfString);
                startOfString = endOfString + 1;
            }
            ++endOfString;
        }
        return lines;
    }

    public void delete(IPath remotePath, IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            IFileStore remoteFile = this.rmtFileProxy.getResource(remotePath.toString());
            remoteFile.delete(0, monitor);
        }
        catch (CoreException e) {
            throw new RemoteConnectionException(e.getLocalizedMessage(), e);
        }
    }

    public void download(IPath remotePath, IPath localPath, IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            this.copyFileFromRemoteHost(remotePath.toString(), localPath.toString(), monitor);
        }
        catch (CoreException e) {
            throw new RemoteConnectionException(e.getLocalizedMessage(), e);
        }
    }

    private void copyFileToRemoteHost(String localPath, String remotePath, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        try {
            IFileSystem localFS = EFS.getLocalFileSystem();
            IFileStore localFile = localFS.getStore(Path.fromOSString((String)localPath));
            IFileStore rmtFile = this.rmtFileProxy.getResource(remotePath);
            localFile.copy(rmtFile, 2, (IProgressMonitor)progress);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public Map<String, String> getEnv() throws CoreException {
        IPath envPath = Path.fromOSString((String)ENV_CMD);
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        String[] empty = new String[]{};
        this.rmtCmdLauncher.execute(envPath, empty, empty, null, (IProgressMonitor)new NullProgressMonitor());
        this.rmtCmdLauncher.waitAndRead(stdout, stderr, (IProgressMonitor)new NullProgressMonitor());
        HashMap<String, String> env = new HashMap<String, String>();
        String[] envLines = RemoteConnection.getLines(stdout.toString());
        int idx = 1;
        while (idx < envLines.length) {
            String[] keyAndVal = envLines[idx].split("=", 2);
            if (keyAndVal.length == 2) {
                env.put(keyAndVal[0], keyAndVal[1]);
            } else if (keyAndVal.length == 1) {
                env.put(keyAndVal[0], null);
            }
            ++idx;
        }
        return env;
    }

    public static String[] envMapToEnvArray(Map<String, String> envMap) {
        String[] envArray = new String[envMap.size()];
        int idx = 0;
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            envArray[idx++] = String.valueOf(entry.getKey()) + "=" + entry.getValue();
        }
        return envArray;
    }

    public IPath whichCommand(String command, String toolsPath) throws CoreException {
        String[] args = new String[1];
        Map<String, String> envMap = this.getEnv();
        IPath whichPath = Path.fromOSString((String)WHICH_CMD);
        args[0] = command;
        if (envMap.containsKey(PATH_ENV_VAR)) {
            String pathVal = envMap.get(PATH_ENV_VAR);
            envMap.put(PATH_ENV_VAR, String.valueOf(toolsPath) + SEPARATOR + pathVal);
        } else {
            envMap.put(PATH_ENV_VAR, toolsPath);
        }
        String[] envArray = RemoteConnection.envMapToEnvArray(envMap);
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        this.rmtCmdLauncher.execute(whichPath, args, envArray, null, (IProgressMonitor)new NullProgressMonitor());
        this.rmtCmdLauncher.waitAndRead(stdout, stderr, (IProgressMonitor)new NullProgressMonitor());
        String[] outputLines = RemoteConnection.getLines(stdout.toString());
        return Path.fromOSString((String)outputLines[1]);
    }

    public IRemoteCommandLauncher getRmtCmdLauncher() {
        return this.rmtCmdLauncher;
    }

    public IRemoteFileProxy getRmtFileProxy() {
        return this.rmtFileProxy;
    }
}

