/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.profiling.launch.Messages;
import org.eclipse.linuxtools.internal.profiling.launch.ProfileLaunchPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProfileLaunchShortcut
implements ILaunchShortcut {
    public void launch(IEditorPart editor, String mode) {
        this.searchAndLaunch(new Object[]{editor.getEditorInput()}, mode);
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
        }
    }

    public void launch(IBinary bin, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(bin, mode);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IBinary bin, String mode) {
        ILaunchConfiguration configuration = null;
        ILaunchConfigurationType configType = this.getLaunchConfigType();
        List<ILaunchConfiguration> candidateConfigs = Collections.emptyList();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                IPath programPath = CDebugUtils.getProgramPath((ILaunchConfiguration)config);
                String projectName = CDebugUtils.getProjectName((ILaunchConfiguration)config);
                IPath binPath = bin.getResource().getProjectRelativePath();
                if (programPath != null && programPath.equals((Object)binPath) && projectName != null && projectName.equals(bin.getCProject().getProject().getName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        int candidateCount = candidateConfigs.size();
        configuration = candidateCount < 1 ? this.createConfiguration(bin) : (candidateCount == 1 ? (ILaunchConfiguration)candidateConfigs.get(0) : this.chooseConfiguration(candidateConfigs, mode));
        return configuration;
    }

    protected abstract ILaunchConfigurationType getLaunchConfigType();

    protected abstract void setDefaultProfileAttributes(ILaunchConfigurationWorkingCopy var1) throws CoreException;

    public void setDefaultProfileLaunchShortcutAttributes(ILaunchConfigurationWorkingCopy wc) {
        try {
            this.setDefaultProfileAttributes(wc);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected ILaunchConfiguration createConfiguration(IBinary bin) {
        return this.createConfiguration(bin, true);
    }

    protected ILaunchConfiguration createConfiguration(IBinary bin, boolean save) {
        Object config = null;
        try {
            String projectName = bin.getResource().getProjectRelativePath().toString();
            ILaunchConfigurationType configType = this.getLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(bin.getElementName()));
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", projectName);
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", bin.getCProject().getElementName());
            wc.setMappedResources(new IResource[]{bin.getResource(), bin.getResource().getProject()});
            wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            this.setDefaultProfileAttributes(wc);
            config = save ? wc.doSave() : wc;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return config;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private void searchAndLaunch(final Object[] elements, String mode) {
        if (elements != null && elements.length > 0) {
            IBinary bin = null;
            if (elements.length == 1 && elements[0] instanceof IBinary) {
                bin = (IBinary)elements[0];
            } else {
                final ArrayList<IBinary> results = new ArrayList<IBinary>();
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getActiveWorkbenchShell());
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) throws InterruptedException {
                        int nElements = elements.length;
                        pm.beginTask(Messages.getString("ProfileLaunchShortcut.Looking_for_executables"), nElements);
                        try {
                            SubProgressMonitor sub = new SubProgressMonitor(pm, 1);
                            int i = 0;
                            while (i < nElements) {
                                ICProject cproject;
                                IResource r;
                                if (elements[i] instanceof IAdaptable && (r = (IResource)((IAdaptable)elements[i]).getAdapter(IResource.class)) != null && (cproject = CoreModel.getDefault().create(r.getProject())) != null) {
                                    try {
                                        IBinary[] bins = cproject.getBinaryContainer().getBinaries();
                                        int j = 0;
                                        while (j < bins.length) {
                                            if (bins[j].isExecutable()) {
                                                results.add(bins[j]);
                                            }
                                            ++j;
                                        }
                                    }
                                    catch (CModelException cModelException) {}
                                }
                                if (pm.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                sub.done();
                                ++i;
                            }
                        }
                        finally {
                            pm.done();
                        }
                    }
                };
                try {
                    dialog.run(true, true, runnable);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (InvocationTargetException e) {
                    this.handleFail(e.getMessage());
                    return;
                }
                int count = results.size();
                if (count == 0) {
                    this.handleFail(Messages.getString("ProfileLaunchShortcut.Binary_not_found"));
                } else {
                    bin = count > 1 ? this.chooseBinary(results, mode) : (IBinary)results.get(0);
                }
            }
            if (bin != null) {
                this.launch(bin, mode);
            }
        } else {
            this.handleFail(Messages.getString("ProfileLaunchShortcut.no_project_selected"));
        }
    }

    protected void handleFail(String message) {
        MessageDialog.openError((Shell)this.getActiveWorkbenchShell(), (String)Messages.getString("ProfileLaunchShortcut.Launcher"), (String)message);
    }

    protected IBinary chooseBinary(List<IBinary> binList, String mode) {
        CElementLabelProvider programLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(bin.getPath().lastSegment());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        CElementLabelProvider qualifierLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuffer name = new StringBuffer();
                    name.append(String.valueOf(bin.getCPU()) + (bin.isLittleEndian() ? "le" : "be"));
                    name.append(" - ");
                    name.append(bin.getPath().toString());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.getActiveWorkbenchShell(), (ILabelProvider)programLabelProvider, (ILabelProvider)qualifierLabelProvider);
        dialog.setElements(binList.toArray());
        dialog.setTitle(Messages.getString("ProfileLaunchShortcut.Profile"));
        dialog.setMessage(Messages.getString("ProfileLaunchShortcut.Choose_a_local_application"));
        dialog.setUpperListLabel(Messages.getString("ProfileLaunchShortcut.Binaries"));
        dialog.setLowerListLabel(Messages.getString("ProfileLaunchShortcut.Qualifier"));
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IBinary)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(Messages.getString("ProfileLaunchShortcut.Launch_Configuration_Selection"));
        dialog.setMessage(Messages.getString("ProfileLaunchShortcut.Choose_a_launch_configuration"));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected Shell getActiveWorkbenchShell() {
        return ProfileLaunchPlugin.getActiveWorkbenchShell();
    }
}

