/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.core.stateprovider;

import java.util.HashMap;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTrace;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystemBuilder;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.TmfStateValue;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class LttngKernelStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 2;
    private final HashMap<String, Integer> knownEventNames = LttngKernelStateProvider.fillEventNames();

    public LttngKernelStateProvider(CtfTmfTrace trace) {
        super((ITmfTrace)trace, CtfTmfEvent.class, "LTTng Kernel");
    }

    public int getVersion() {
        return 2;
    }

    public void assignTargetStateSystem(ITmfStateSystemBuilder ssb) {
        super.assignTargetStateSystem(ssb);
    }

    public LttngKernelStateProvider getNewInstance() {
        return new LttngKernelStateProvider((CtfTmfTrace)this.getTrace());
    }

    protected void eventHandle(ITmfEvent ev) {
        CtfTmfEvent event = (CtfTmfEvent)ev;
        ITmfEventField content = event.getContent();
        String eventName = event.getEventName();
        long ts = event.getTimestamp().getValue();
        try {
            Integer currentCPUNode = this.ss.getQuarkRelativeAndAdd(this.getNodeCPUs(), new String[]{String.valueOf(event.getCPU())});
            int quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Current_thread"});
            ITmfStateValue value = this.ss.queryOngoingState(quark);
            int thread = value.unboxInt();
            Integer currentThreadNode = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{String.valueOf(thread)});
            switch (this.getEventIndex(eventName)) {
                case 1: {
                    quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"System_call"});
                    value = TmfStateValue.nullValue();
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)2);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)1);
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 2: {
                    Integer irqId = ((Long)content.getField("irq").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.getNodeIRQs(), new String[]{irqId.toString()});
                    value = TmfStateValue.newValueInt((int)event.getCPU());
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)4);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)3);
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 3: {
                    Integer irqId = ((Long)content.getField("irq").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.getNodeIRQs(), new String[]{irqId.toString()});
                    value = TmfStateValue.nullValue();
                    this.ss.modifyAttribute(ts, value, quark);
                    this.setProcessToRunning(ts, currentThreadNode);
                    this.cpuExitInterrupt(ts, currentCPUNode, currentThreadNode);
                    break;
                }
                case 4: {
                    Integer softIrqId = ((Long)content.getField("vec").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.getNodeSoftIRQs(), new String[]{softIrqId.toString()});
                    value = TmfStateValue.newValueInt((int)event.getCPU());
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)4);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)4);
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 5: {
                    Integer softIrqId = ((Long)content.getField("vec").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.getNodeSoftIRQs(), new String[]{softIrqId.toString()});
                    value = TmfStateValue.nullValue();
                    this.ss.modifyAttribute(ts, value, quark);
                    this.setProcessToRunning(ts, currentThreadNode);
                    this.cpuExitInterrupt(ts, currentCPUNode, currentThreadNode);
                    break;
                }
                case 6: {
                    Integer softIrqId = ((Long)content.getField("vec").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.getNodeSoftIRQs(), new String[]{softIrqId.toString()});
                    value = TmfStateValue.newValueInt((int)-2);
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 7: {
                    Integer prevTid = ((Long)content.getField("prev_tid").getValue()).intValue();
                    Long prevState = (Long)content.getField("prev_state").getValue();
                    String nextProcessName = (String)content.getField("next_comm").getValue();
                    Integer nextTid = ((Long)content.getField("next_tid").getValue()).intValue();
                    Integer formerThreadNode = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{prevTid.toString()});
                    Integer newCurrentThreadNode = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{nextTid.toString()});
                    quark = this.ss.getQuarkRelativeAndAdd(formerThreadNode.intValue(), new String[]{"Status"});
                    value = prevState != 0L ? TmfStateValue.newValueInt((int)1) : TmfStateValue.newValueInt((int)5);
                    this.ss.modifyAttribute(ts, value, quark);
                    this.setProcessToRunning(ts, newCurrentThreadNode);
                    quark = this.ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"Exec_name"});
                    value = TmfStateValue.newValueString((String)nextProcessName);
                    this.ss.modifyAttribute(ts, value, quark);
                    this.ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"System_call"});
                    this.ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"PPID"});
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Current_thread"});
                    value = TmfStateValue.newValueInt((int)nextTid);
                    this.ss.modifyAttribute(ts, value, quark);
                    value = nextTid > 0 ? (this.ss.queryOngoingState(quark = this.ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"System_call"})).isNull() ? TmfStateValue.newValueInt((int)1) : TmfStateValue.newValueInt((int)2)) : TmfStateValue.newValueInt((int)0);
                    quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 8: {
                    String childProcessName = (String)content.getField("child_comm").getValue();
                    Integer parentTid = ((Long)content.getField("parent_tid").getValue()).intValue();
                    Integer childTid = ((Long)content.getField("child_tid").getValue()).intValue();
                    Integer parentTidNode = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{parentTid.toString()});
                    Integer childTidNode = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{childTid.toString()});
                    quark = this.ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"PPID"});
                    value = TmfStateValue.newValueInt((int)parentTid);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"Exec_name"});
                    value = TmfStateValue.newValueString((String)childProcessName);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)5);
                    this.ss.modifyAttribute(ts, value, quark);
                    quark = this.ss.getQuarkRelativeAndAdd(parentTidNode.intValue(), new String[]{"System_call"});
                    value = this.ss.queryOngoingState(quark);
                    if (value.isNull()) {
                        value = TmfStateValue.newValueString((String)"sys_clone");
                    }
                    quark = this.ss.getQuarkRelativeAndAdd(childTidNode.intValue(), new String[]{"System_call"});
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    Integer tid = ((Long)content.getField("tid").getValue()).intValue();
                    quark = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{tid.toString()});
                    this.ss.removeAttribute(ts, quark);
                    break;
                }
                case 11: {
                    Integer tid = ((Long)content.getField("tid").getValue()).intValue();
                    int ppid = ((Long)content.getField("ppid").getValue()).intValue();
                    int status = ((Long)content.getField("status").getValue()).intValue();
                    String name = (String)content.getField("name").getValue();
                    int curThreadNode = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{tid.toString()});
                    quark = this.ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"Exec_name"});
                    if (this.ss.queryOngoingState(quark).isNull()) {
                        value = TmfStateValue.newValueString((String)name);
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    if (this.ss.queryOngoingState(quark = this.ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"PPID"})).isNull()) {
                        value = TmfStateValue.newValueInt((int)ppid);
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    if (this.ss.queryOngoingState(quark = this.ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"Status"})).isNull()) {
                        value = status == 2 ? TmfStateValue.newValueInt((int)5) : (status == 5 ? TmfStateValue.newValueInt((int)1) : TmfStateValue.newValueInt((int)0));
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    break;
                }
                case 12: 
                case 13: {
                    int tid = ((Long)content.getField("tid").getValue()).intValue();
                    int threadNode = this.ss.getQuarkRelativeAndAdd(this.getNodeThreads(), new String[]{String.valueOf(tid)});
                    quark = this.ss.getQuarkRelativeAndAdd(threadNode, new String[]{"Status"});
                    value = TmfStateValue.newValueInt((int)5);
                    this.ss.modifyAttribute(ts, value, quark);
                    break;
                }
                default: {
                    if (eventName.startsWith("sys_") || eventName.startsWith("compat_sys_")) {
                        quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"System_call"});
                        value = TmfStateValue.newValueString((String)eventName);
                        this.ss.modifyAttribute(ts, value, quark);
                        quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode.intValue(), new String[]{"Status"});
                        value = TmfStateValue.newValueInt((int)3);
                        this.ss.modifyAttribute(ts, value, quark);
                        quark = this.ss.getQuarkRelativeAndAdd(currentCPUNode.intValue(), new String[]{"Status"});
                        value = TmfStateValue.newValueInt((int)2);
                        this.ss.modifyAttribute(ts, value, quark);
                    }
                    break;
                }
            }
        }
        catch (AttributeNotFoundException ae) {
            ae.printStackTrace();
        }
        catch (TimeRangeException tre) {
            System.err.println("TimeRangeExcpetion caught in the state system's event manager.");
            System.err.println("Are the events in the trace correctly ordered?");
            tre.printStackTrace();
        }
        catch (StateValueTypeException sve) {
            sve.printStackTrace();
        }
    }

    private int getNodeCPUs() {
        return this.ss.getQuarkAbsoluteAndAdd(new String[]{"CPUs"});
    }

    private int getNodeThreads() {
        return this.ss.getQuarkAbsoluteAndAdd(new String[]{"Threads"});
    }

    private int getNodeIRQs() {
        return this.ss.getQuarkAbsoluteAndAdd(new String[]{"Resources", "IRQs"});
    }

    private int getNodeSoftIRQs() {
        return this.ss.getQuarkAbsoluteAndAdd(new String[]{"Resources", "Soft_IRQs"});
    }

    private static HashMap<String, Integer> fillEventNames() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("exit_syscall", 1);
        map.put("irq_handler_entry", 2);
        map.put("irq_handler_exit", 3);
        map.put("softirq_entry", 4);
        map.put("softirq_exit", 5);
        map.put("softirq_raise", 6);
        map.put("sched_switch", 7);
        map.put("sched_process_fork", 8);
        map.put("sched_process_exit", 9);
        map.put("sched_process_free", 10);
        map.put("lttng_statedump_process_state", 11);
        map.put("sched_wakeup", 12);
        map.put("sched_wakeup_new", 13);
        return map;
    }

    private int getEventIndex(String eventName) {
        Integer ret = this.knownEventNames.get(eventName);
        return ret != null ? ret : -1;
    }

    private void setProcessToRunning(long ts, int currentThreadNode) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
        int quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"System_call"});
        TmfStateValue value = this.ss.queryOngoingState(quark).isNull() ? TmfStateValue.newValueInt((int)2) : TmfStateValue.newValueInt((int)3);
        quark = this.ss.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"Status"});
        this.ss.modifyAttribute(ts, (ITmfStateValue)value, quark);
    }

    private void cpuExitInterrupt(long ts, int currentCpuNode, int currentThreadNode) throws StateValueTypeException, AttributeNotFoundException, TimeRangeException {
        int quark = this.ss.getQuarkRelativeAndAdd(currentCpuNode, new String[]{"Current_thread"});
        TmfStateValue value = this.ss.queryOngoingState(quark).unboxInt() > 0 ? (this.ss.queryOngoingState(quark = this.ss.getQuarkRelative(currentThreadNode, new String[]{"System_call"})).isNull() ? TmfStateValue.newValueInt((int)1) : TmfStateValue.newValueInt((int)2)) : TmfStateValue.newValueInt((int)0);
        quark = this.ss.getQuarkRelativeAndAdd(currentCpuNode, new String[]{"Status"});
        this.ss.modifyAttribute(ts, (ITmfStateValue)value, quark);
    }
}

