/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.properties;

import java.util.ArrayList;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfiguration;
import org.eclipse.cdt.internal.autotools.core.configure.IAConfiguration;
import org.eclipse.cdt.internal.autotools.ui.properties.AbstractConfigurePropertyOptionsPage;
import org.eclipse.cdt.internal.autotools.ui.properties.ToolListElement;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class AutotoolsCategoryPropertyOptionPage
extends AbstractConfigurePropertyOptionsPage {
    private String catName = "";
    private IAConfiguration cfg;
    private ArrayList<FieldEditor> fieldEditors;

    public AutotoolsCategoryPropertyOptionPage(ToolListElement element, IAConfiguration cfg) {
        super(element.getName());
        this.catName = element.getName();
        this.cfg = cfg;
        this.fieldEditors = new ArrayList();
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    protected void createFieldEditors() {
        super.createFieldEditors();
        Composite parent = this.getFieldEditorParent();
        AutotoolsConfiguration.Option[] options = AutotoolsConfiguration.getChildOptions((String)this.catName);
        int i = 0;
        while (i < options.length) {
            AutotoolsConfiguration.Option option = options[i];
            switch (option.getType()) {
                case 2: 
                case 3: 
                case 4: {
                    parent = this.getFieldEditorParent();
                    StringFieldEditor f = new StringFieldEditor(option.getName(), option.getDescription(), 20, parent);
                    f.getLabelControl(parent).setToolTipText(option.getToolTip());
                    this.addField((FieldEditor)f);
                    this.fieldEditors.add((FieldEditor)f);
                    break;
                }
                case 1: 
                case 7: {
                    parent = this.getFieldEditorParent();
                    BooleanFieldEditor b = new BooleanFieldEditor(option.getName(), option.getDescription(), parent);
                    b.getDescriptionControl(parent).setToolTipText(option.getToolTip());
                    this.addField((FieldEditor)b);
                    this.fieldEditors.add((FieldEditor)b);
                    break;
                }
                case 6: {
                    parent = this.getFieldEditorParent();
                    FieldEditor l = this.createLabelEditor(parent, option.getName());
                    this.addField(l);
                    this.fieldEditors.add(l);
                }
            }
            ++i;
        }
    }

    protected FieldEditor createLabelEditor(Composite parent, String title) {
        return new LabelFieldEditor(parent, title);
    }

    @Override
    public void updateFields() {
        this.setValues();
    }

    @Override
    public void setValues() {
        int i = 0;
        while (i < this.fieldEditors.size()) {
            this.fieldEditors.get(i).load();
            ++i;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() instanceof StringFieldEditor) {
            StringFieldEditor f = (StringFieldEditor)event.getSource();
            this.cfg.setOption(f.getPreferenceName(), f.getStringValue());
        } else if (event.getSource() instanceof BooleanFieldEditor) {
            BooleanFieldEditor b = (BooleanFieldEditor)event.getSource();
            this.cfg.setOption(b.getPreferenceName(), Boolean.toString(b.getBooleanValue()));
        }
    }

    static class LabelFieldEditor
    extends FieldEditor {
        private String fTitle;
        private Label fTitleLabel;

        public LabelFieldEditor(Composite parent, String title) {
            this.fTitle = title;
            this.createControl(parent);
        }

        protected void adjustForNumColumns(int numColumns) {
            ((GridData)this.fTitleLabel.getLayoutData()).horizontalSpan = 2;
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.fTitleLabel = new Label(parent, 64);
            this.fTitleLabel.setText(this.fTitle);
            GridData gd = new GridData();
            gd.verticalAlignment = 128;
            gd.grabExcessHorizontalSpace = false;
            gd.horizontalSpan = 2;
            this.fTitleLabel.setLayoutData((Object)gd);
        }

        public int getNumberOfControls() {
            return 1;
        }

        protected void doLoad() {
        }

        protected void doLoadDefault() {
        }

        protected void doStore() {
        }
    }
}

