/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Messages;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesEntry;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesEvent;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesPresentationProvider;
import org.eclipse.linuxtools.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTimestamp;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;

public class ResourcesView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.lttng2.kernel.ui.views.resources";
    TimeGraphViewer fTimeGraphViewer;
    private ITmfTrace fTrace;
    private ArrayList<TraceEntry> fEntryList;
    private final HashMap<ITmfTrace, ArrayList<TraceEntry>> fEntryListMap = new HashMap();
    private final HashMap<ITmfTrace, BuildThread> fBuildThreadMap = new HashMap();
    private long fStartTime;
    private long fEndTime;
    private final int fDisplayWidth;
    private Action fNextResourceAction;
    private Action fPreviousResourceAction;
    private ZoomThread fZoomThread;
    private State fRedrawState = State.IDLE;
    private final Object fSyncObj = new Object();

    public ResourcesView() {
        super(ID);
        this.fDisplayWidth = Display.getDefault().getBounds().width;
    }

    public void createPartControl(Composite parent) {
        this.fTimeGraphViewer = new TimeGraphViewer(parent, 0);
        this.fTimeGraphViewer.setTimeGraphProvider((ITimeGraphPresentationProvider)new ResourcesPresentationProvider(this.fTimeGraphViewer));
        this.fTimeGraphViewer.setTimeFormat(Utils.TimeFormat.CALENDAR);
        this.fTimeGraphViewer.addRangeListener(new ITimeGraphRangeListener(){

            public void timeRangeUpdated(TimeGraphRangeUpdateEvent event) {
                long startTime = event.getStartTime();
                long endTime = event.getEndTime();
                TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new CtfTmfTimestamp(startTime), (ITmfTimestamp)new CtfTmfTimestamp(endTime));
                CtfTmfTimestamp time = new CtfTmfTimestamp(ResourcesView.this.fTimeGraphViewer.getSelectedTime());
                ResourcesView.this.broadcast((TmfSignal)new TmfRangeSynchSignal((Object)ResourcesView.this, range, (ITmfTimestamp)time));
                ResourcesView.this.startZoomThread(startTime, endTime);
            }
        });
        this.fTimeGraphViewer.addTimeListener(new ITimeGraphTimeListener(){

            public void timeSelected(TimeGraphTimeEvent event) {
                long time = event.getTime();
                ResourcesView.this.broadcast((TmfSignal)new TmfTimeSynchSignal((Object)ResourcesView.this, (ITmfTimestamp)new CtfTmfTimestamp(time)));
            }
        });
        this.makeActions();
        this.contributeToActionBars();
        ITmfTrace trace = this.getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
    }

    public void setFocus() {
        this.fTimeGraphViewer.setFocus();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.fTrace = signal.getTrace();
        this.loadTrace();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            return;
        }
        this.fTrace = signal.getTrace();
        this.loadTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        HashMap<ITmfTrace, Object> hashMap = this.fBuildThreadMap;
        synchronized (hashMap) {
            BuildThread buildThread = this.fBuildThreadMap.remove(signal.getTrace());
            if (buildThread != null) {
                buildThread.cancel();
            }
        }
        hashMap = this.fEntryListMap;
        synchronized (hashMap) {
            this.fEntryListMap.remove(signal.getTrace());
        }
        if (signal.getTrace() == this.fTrace) {
            this.fTrace = null;
            this.fStartTime = 0L;
            this.fEndTime = 0L;
            if (this.fZoomThread != null) {
                this.fZoomThread.cancel();
            }
            this.refresh();
        }
    }

    @TmfSignalHandler
    public void synchToTime(TmfTimeSynchSignal signal) {
        if (signal.getSource() == this || this.fTrace == null) {
            return;
        }
        final long time = signal.getCurrentTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ResourcesView.this.fTimeGraphViewer.getControl().isDisposed()) {
                    return;
                }
                ResourcesView.this.fTimeGraphViewer.setSelectedTime(time, true);
                ResourcesView.this.startZoomThread(ResourcesView.this.fTimeGraphViewer.getTime0(), ResourcesView.this.fTimeGraphViewer.getTime1());
            }
        });
    }

    @TmfSignalHandler
    public void synchToRange(TmfRangeSynchSignal signal) {
        if (signal.getSource() == this || this.fTrace == null) {
            return;
        }
        if (signal.getCurrentRange().getIntersection(this.fTrace.getTimeRange()) == null) {
            return;
        }
        final long startTime = signal.getCurrentRange().getStartTime().normalize(0L, -9).getValue();
        final long endTime = signal.getCurrentRange().getEndTime().normalize(0L, -9).getValue();
        final long time = signal.getCurrentTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ResourcesView.this.fTimeGraphViewer.getControl().isDisposed()) {
                    return;
                }
                ResourcesView.this.fTimeGraphViewer.setStartFinishTime(startTime, endTime);
                ResourcesView.this.fTimeGraphViewer.setSelectedTime(time, false);
                ResourcesView.this.startZoomThread(startTime, endTime);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTrace() {
        HashMap<ITmfTrace, ArrayList<TraceEntry>> hashMap = this.fEntryListMap;
        synchronized (hashMap) {
            this.fEntryList = this.fEntryListMap.get(this.fTrace);
            if (this.fEntryList == null) {
                HashMap<ITmfTrace, BuildThread> hashMap2 = this.fBuildThreadMap;
                synchronized (hashMap2) {
                    BuildThread buildThread = new BuildThread(this.fTrace);
                    this.fBuildThreadMap.put(this.fTrace, buildThread);
                    buildThread.start();
                }
            } else {
                this.fStartTime = this.fTrace.getStartTime().normalize(0L, -9).getValue();
                this.fEndTime = this.fTrace.getEndTime().normalize(0L, -9).getValue();
                this.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildEventList(ITmfTrace trace, IProgressMonitor monitor) {
        ITmfTrace aTrace;
        this.fStartTime = Long.MAX_VALUE;
        this.fEndTime = Long.MIN_VALUE;
        ArrayList<TraceEntry> entryList = new ArrayList<TraceEntry>();
        ITmfTrace[] iTmfTraceArray = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            aTrace = iTmfTraceArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (aTrace instanceof LttngKernelTrace) {
                LttngKernelTrace ctfKernelTrace = (LttngKernelTrace)aTrace;
                ITmfStateSystem ssq = (ITmfStateSystem)ctfKernelTrace.getStateSystems().get("org.eclipse.linuxtools.lttng2.kernel");
                if (!ssq.waitUntilBuilt()) {
                    return;
                }
                long startTime = ssq.getStartTime();
                long endTime = ssq.getCurrentEndTime() + 1L;
                TraceEntry groupEntry = new TraceEntry(ctfKernelTrace, aTrace.getName(), startTime, endTime);
                entryList.add(groupEntry);
                this.fStartTime = Math.min(this.fStartTime, startTime);
                this.fEndTime = Math.max(this.fEndTime, endTime);
                List cpuQuarks = ssq.getQuarks(new String[]{"CPUs", "*"});
                ResourcesEntry[] cpuEntries = new ResourcesEntry[cpuQuarks.size()];
                int i = 0;
                while (i < cpuQuarks.size()) {
                    int cpuQuark = (Integer)cpuQuarks.get(i);
                    int cpu = Integer.parseInt(ssq.getAttributeName(cpuQuark));
                    ResourcesEntry entry = new ResourcesEntry(cpuQuark, ctfKernelTrace, ResourcesEntry.Type.CPU, cpu);
                    groupEntry.addChild(entry);
                    cpuEntries[i] = entry;
                    ++i;
                }
                List irqQuarks = ssq.getQuarks(new String[]{"Resources", "IRQs", "*"});
                ResourcesEntry[] irqEntries = new ResourcesEntry[irqQuarks.size()];
                int i2 = 0;
                while (i2 < irqQuarks.size()) {
                    int irqQuark = (Integer)irqQuarks.get(i2);
                    int irq = Integer.parseInt(ssq.getAttributeName(irqQuark));
                    ResourcesEntry entry = new ResourcesEntry(irqQuark, ctfKernelTrace, ResourcesEntry.Type.IRQ, irq);
                    groupEntry.addChild(entry);
                    irqEntries[i2] = entry;
                    ++i2;
                }
                List softIrqQuarks = ssq.getQuarks(new String[]{"Resources", "Soft_IRQs", "*"});
                ResourcesEntry[] softIrqEntries = new ResourcesEntry[softIrqQuarks.size()];
                int i3 = 0;
                while (i3 < softIrqQuarks.size()) {
                    int softIrqQuark = (Integer)softIrqQuarks.get(i3);
                    int softIrq = Integer.parseInt(ssq.getAttributeName(softIrqQuark));
                    ResourcesEntry entry = new ResourcesEntry(softIrqQuark, ctfKernelTrace, ResourcesEntry.Type.SOFT_IRQ, softIrq);
                    groupEntry.addChild(entry);
                    softIrqEntries[i3] = entry;
                    ++i3;
                }
            }
            ++n2;
        }
        aTrace = this.fEntryListMap;
        synchronized (aTrace) {
            this.fEntryListMap.put(trace, (ArrayList)entryList.clone());
        }
        if (trace == this.fTrace) {
            this.refresh();
        }
        for (TraceEntry traceEntry : entryList) {
            if (monitor.isCanceled()) {
                return;
            }
            LttngKernelTrace ctfKernelTrace = traceEntry.getTrace();
            ITmfStateSystem ssq = (ITmfStateSystem)ctfKernelTrace.getStateSystems().get("org.eclipse.linuxtools.lttng2.kernel");
            long startTime = ssq.getStartTime();
            long endTime = ssq.getCurrentEndTime() + 1L;
            long resolution = (endTime - startTime) / (long)this.fDisplayWidth;
            for (ResourcesEntry entry : traceEntry.getChildren()) {
                List<ITimeEvent> eventList = ResourcesView.getEventList(entry, startTime, endTime, resolution, false, monitor);
                entry.setEventList(eventList);
                this.redraw();
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static List<ITimeEvent> getEventList(ResourcesEntry entry, long startTime, long endTime, long resolution, boolean includeNull, IProgressMonitor monitor) {
        ITmfStateSystem ssq = (ITmfStateSystem)entry.getTrace().getStateSystems().get("org.eclipse.linuxtools.lttng2.kernel");
        long realStart = Math.max(startTime, ssq.getStartTime());
        long realEnd = Math.min(endTime, ssq.getCurrentEndTime() + 1L);
        if (realEnd <= realStart) {
            return null;
        }
        ArrayList<TimeEvent> eventList = null;
        int quark = entry.getQuark();
        try {
            if (entry.getType().equals((Object)ResourcesEntry.Type.CPU)) {
                int statusQuark = ssq.getQuarkRelative(quark, new String[]{"Status"});
                List statusIntervals = ssq.queryHistoryRange(statusQuark, realStart, realEnd - 1L, resolution, monitor);
                eventList = new ArrayList(statusIntervals.size());
                long lastEndTime = -1L;
                for (ITmfStateInterval statusInterval : statusIntervals) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    int status = statusInterval.getStateValue().unboxInt();
                    long time = statusInterval.getStartTime();
                    long duration = statusInterval.getEndTime() - time + 1L;
                    if (!statusInterval.getStateValue().isNull()) {
                        if (lastEndTime != time && lastEndTime != -1L) {
                            eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime));
                        }
                        eventList.add(new ResourcesEvent(entry, time, duration, status));
                        lastEndTime = time + duration;
                        continue;
                    }
                    if (!includeNull) continue;
                    eventList.add(new ResourcesEvent(entry, time, duration));
                }
            } else if (entry.getType().equals((Object)ResourcesEntry.Type.IRQ)) {
                List irqIntervals = ssq.queryHistoryRange(quark, realStart, realEnd - 1L, resolution, monitor);
                eventList = new ArrayList<TimeEvent>(irqIntervals.size());
                long lastEndTime = -1L;
                boolean lastIsNull = true;
                for (ITmfStateInterval irqInterval : irqIntervals) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    long time = irqInterval.getStartTime();
                    long duration = irqInterval.getEndTime() - time + 1L;
                    if (!irqInterval.getStateValue().isNull()) {
                        int cpu = irqInterval.getStateValue().unboxInt();
                        eventList.add(new ResourcesEvent(entry, time, duration, cpu));
                        lastIsNull = false;
                    } else {
                        if (lastEndTime != time && lastEndTime != -1L && lastIsNull) {
                            eventList.add(new ResourcesEvent(entry, lastEndTime, time - lastEndTime, -1));
                        }
                        if (includeNull) {
                            eventList.add(new ResourcesEvent(entry, time, duration));
                        }
                        lastIsNull = true;
                    }
                    lastEndTime = time + duration;
                }
            } else if (entry.getType().equals((Object)ResourcesEntry.Type.SOFT_IRQ)) {
                List softIrqIntervals = ssq.queryHistoryRange(quark, realStart, realEnd - 1L, resolution, monitor);
                eventList = new ArrayList(softIrqIntervals.size());
                long lastEndTime = -1L;
                boolean lastIsNull = true;
                for (ITmfStateInterval softIrqInterval : softIrqIntervals) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    long time = softIrqInterval.getStartTime();
                    long duration = softIrqInterval.getEndTime() - time + 1L;
                    if (!softIrqInterval.getStateValue().isNull()) {
                        int cpu = softIrqInterval.getStateValue().unboxInt();
                        eventList.add(new ResourcesEvent(entry, time, duration, cpu));
                    } else {
                        if (lastEndTime != time && lastEndTime != -1L && lastIsNull) {
                            eventList.add(new ResourcesEvent(entry, lastEndTime, time - lastEndTime, -1));
                        }
                        if (includeNull) {
                            eventList.add(new ResourcesEvent(entry, time, duration));
                        }
                        lastIsNull = true;
                    }
                    lastEndTime = time + duration;
                }
            }
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (TimeRangeException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {}
        return eventList;
    }

    private void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ResourcesView.this.fTimeGraphViewer.getControl().isDisposed()) {
                    return;
                }
                ITimeGraphEntry[] entries = null;
                HashMap hashMap = ResourcesView.this.fEntryListMap;
                synchronized (hashMap) {
                    ResourcesView.this.fEntryList = (ArrayList)ResourcesView.this.fEntryListMap.get(ResourcesView.this.fTrace);
                    if (ResourcesView.this.fEntryList == null) {
                        ResourcesView.this.fEntryList = new ArrayList();
                    }
                    entries = ResourcesView.this.fEntryList.toArray(new ITimeGraphEntry[0]);
                }
                if (entries != null) {
                    Arrays.sort(entries, new TraceEntryComparator());
                    ResourcesView.this.fTimeGraphViewer.setInput(entries);
                    ResourcesView.this.fTimeGraphViewer.setTimeBounds(ResourcesView.this.fStartTime, ResourcesView.this.fEndTime);
                    long timestamp = ResourcesView.this.fTrace == null ? 0L : ResourcesView.this.fTraceManager.getCurrentTime().normalize(0L, -9).getValue();
                    long startTime = ResourcesView.this.fTrace == null ? 0L : ResourcesView.this.fTraceManager.getCurrentRange().getStartTime().normalize(0L, -9).getValue();
                    long endTime = ResourcesView.this.fTrace == null ? 0L : ResourcesView.this.fTraceManager.getCurrentRange().getEndTime().normalize(0L, -9).getValue();
                    startTime = Math.max(startTime, ResourcesView.this.fStartTime);
                    endTime = Math.min(endTime, ResourcesView.this.fEndTime);
                    ResourcesView.this.fTimeGraphViewer.setSelectedTime(timestamp, false);
                    ResourcesView.this.fTimeGraphViewer.setStartFinishTime(startTime, endTime);
                    ResourcesView.this.startZoomThread(startTime, endTime);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redraw() {
        Object object = this.fSyncObj;
        synchronized (object) {
            if (this.fRedrawState != State.IDLE) {
                this.fRedrawState = State.PENDING;
                return;
            }
            this.fRedrawState = State.BUSY;
        }
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ResourcesView.this.fTimeGraphViewer.getControl().isDisposed()) {
                    return;
                }
                ResourcesView.this.fTimeGraphViewer.getControl().redraw();
                ResourcesView.this.fTimeGraphViewer.getControl().update();
                Object object = ResourcesView.this.fSyncObj;
                synchronized (object) {
                    if (ResourcesView.this.fRedrawState == State.PENDING) {
                        ResourcesView.this.fRedrawState = State.IDLE;
                        ResourcesView.this.redraw();
                    } else {
                        ResourcesView.this.fRedrawState = State.IDLE;
                    }
                }
            }
        });
    }

    private void startZoomThread(long startTime, long endTime) {
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
        }
        this.fZoomThread = new ZoomThread(this.fEntryList, startTime, endTime);
        this.fZoomThread.start();
    }

    private void makeActions() {
        this.fPreviousResourceAction = this.fTimeGraphViewer.getPreviousItemAction();
        this.fPreviousResourceAction.setText(Messages.ResourcesView_previousResourceActionNameText);
        this.fPreviousResourceAction.setToolTipText(Messages.ResourcesView_previousResourceActionToolTipText);
        this.fNextResourceAction = this.fTimeGraphViewer.getNextItemAction();
        this.fNextResourceAction.setText(Messages.ResourcesView_nextResourceActionNameText);
        this.fNextResourceAction.setToolTipText(Messages.ResourcesView_previousResourceActionToolTipText);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fTimeGraphViewer.getShowLegendAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fTimeGraphViewer.getResetScaleAction());
        manager.add((IAction)this.fTimeGraphViewer.getPreviousEventAction());
        manager.add((IAction)this.fTimeGraphViewer.getNextEventAction());
        manager.add((IAction)this.fPreviousResourceAction);
        manager.add((IAction)this.fNextResourceAction);
        manager.add((IAction)this.fTimeGraphViewer.getZoomInAction());
        manager.add((IAction)this.fTimeGraphViewer.getZoomOutAction());
        manager.add((IContributionItem)new Separator());
    }

    private class BuildThread
    extends Thread {
        private final ITmfTrace fBuildTrace;
        private final IProgressMonitor fMonitor;

        public BuildThread(ITmfTrace trace) {
            super("ResourcesView build");
            this.fBuildTrace = trace;
            this.fMonitor = new NullProgressMonitor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ResourcesView.this.buildEventList(this.fBuildTrace, this.fMonitor);
            HashMap hashMap = ResourcesView.this.fBuildThreadMap;
            synchronized (hashMap) {
                ResourcesView.this.fBuildThreadMap.remove(this);
            }
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }
    }

    private static enum State {
        IDLE,
        BUSY,
        PENDING;

    }

    private class TraceEntry
    implements ITimeGraphEntry {
        private final LttngKernelTrace fKernelTrace;
        private final long fTraceStartTime;
        private final long fTraceEndTime;
        private final ArrayList<ResourcesEntry> fChildren;
        private final String fName;

        public TraceEntry(LttngKernelTrace trace, String name, long startTime, long endTime) {
            this.fKernelTrace = trace;
            this.fChildren = new ArrayList();
            this.fName = name;
            this.fTraceStartTime = startTime;
            this.fTraceEndTime = endTime;
        }

        public ITimeGraphEntry getParent() {
            return null;
        }

        public boolean hasChildren() {
            return this.fChildren != null && this.fChildren.size() > 0;
        }

        public List<ResourcesEntry> getChildren() {
            return this.fChildren;
        }

        public String getName() {
            return this.fName;
        }

        public long getStartTime() {
            return this.fTraceStartTime;
        }

        public long getEndTime() {
            return this.fTraceEndTime;
        }

        public boolean hasTimeEvents() {
            return false;
        }

        public Iterator<ITimeEvent> getTimeEventsIterator() {
            return null;
        }

        public <T extends ITimeEvent> Iterator<T> getTimeEventsIterator(long startTime, long stopTime, long visibleDuration) {
            return null;
        }

        public LttngKernelTrace getTrace() {
            return this.fKernelTrace;
        }

        public void addChild(ResourcesEntry entry) {
            int index = 0;
            while (index < this.fChildren.size()) {
                ResourcesEntry other = this.fChildren.get(index);
                if (entry.getType().compareTo(other.getType()) < 0 || entry.getType().equals((Object)other.getType()) && entry.getId() < other.getId()) break;
                ++index;
            }
            entry.setParent(this);
            this.fChildren.add(index, entry);
        }
    }

    private static class TraceEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private TraceEntryComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            int result;
            int n = o1.getStartTime() < o2.getStartTime() ? -1 : (result = o1.getStartTime() > o2.getStartTime() ? 1 : 0);
            if (result == 0) {
                result = o1.getName().compareTo(o2.getName());
            }
            return result;
        }
    }

    private class ZoomThread
    extends Thread {
        private final ArrayList<TraceEntry> fZoomEntryList;
        private final long fZoomStartTime;
        private final long fZoomEndTime;
        private final IProgressMonitor fMonitor;

        public ZoomThread(ArrayList<TraceEntry> entryList, long startTime, long endTime) {
            super("ResourcesView zoom");
            this.fZoomEntryList = entryList;
            this.fZoomStartTime = startTime;
            this.fZoomEndTime = endTime;
            this.fMonitor = new NullProgressMonitor();
        }

        @Override
        public void run() {
            if (this.fZoomEntryList == null) {
                return;
            }
            long resolution = Math.max(1L, (this.fZoomEndTime - this.fZoomStartTime) / (long)ResourcesView.this.fDisplayWidth);
            block0: for (TraceEntry traceEntry : this.fZoomEntryList) {
                if (!((ITmfStateSystem)traceEntry.fKernelTrace.getStateSystems().get("org.eclipse.linuxtools.lttng2.kernel")).waitUntilBuilt()) {
                    return;
                }
                for (ITimeGraphEntry iTimeGraphEntry : traceEntry.getChildren()) {
                    if (this.fMonitor.isCanceled()) continue block0;
                    ResourcesEntry entry = (ResourcesEntry)iTimeGraphEntry;
                    if (this.fZoomStartTime <= ResourcesView.this.fStartTime && this.fZoomEndTime >= ResourcesView.this.fEndTime) {
                        entry.setZoomedEventList(null);
                    } else {
                        List zoomedEventList = ResourcesView.getEventList(entry, this.fZoomStartTime, this.fZoomEndTime, resolution, true, this.fMonitor);
                        if (zoomedEventList != null) {
                            entry.setZoomedEventList(zoomedEventList);
                        }
                    }
                    ResourcesView.this.redraw();
                }
            }
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }
    }
}

