/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Messages;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesEntry;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class ResourcesPresentationProvider
extends TimeGraphPresentationProvider {
    private final TimeGraphViewer fTimeGraphViewer;
    private long fLastThreadId = -1L;

    public ResourcesPresentationProvider(TimeGraphViewer timeGraphViewer) {
        this.fTimeGraphViewer = timeGraphViewer;
    }

    public String getStateTypeName() {
        return Messages.ResourcesView_stateTypeName;
    }

    public StateItem[] getStateTable() {
        StateItem[] stateTable = new StateItem[State.values().length];
        int i = 0;
        while (i < stateTable.length) {
            State state = State.values()[i];
            stateTable[i] = new StateItem(state.rgb, state.toString());
            ++i;
        }
        return stateTable;
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof ResourcesEvent) {
            ResourcesEvent resourcesEvent = (ResourcesEvent)event;
            if (resourcesEvent.getType() == ResourcesEntry.Type.CPU) {
                int status = resourcesEvent.getValue();
                if (status == 0) {
                    return State.IDLE.ordinal();
                }
                if (status == 1) {
                    return State.USERMODE.ordinal();
                }
                if (status == 2) {
                    return State.SYSCALL.ordinal();
                }
                if (status == 3) {
                    return State.IRQ.ordinal();
                }
                if (status == 4) {
                    return State.SOFT_IRQ.ordinal();
                }
            } else {
                if (resourcesEvent.getType() == ResourcesEntry.Type.IRQ) {
                    return State.IRQ_ACTIVE.ordinal();
                }
                if (resourcesEvent.getType() == ResourcesEntry.Type.SOFT_IRQ) {
                    int cpu = resourcesEvent.getValue();
                    if (cpu == -2) {
                        return State.SOFT_IRQ_RAISED.ordinal();
                    }
                    return State.SOFT_IRQ_ACTIVE.ordinal();
                }
                return -1;
            }
        }
        return -2;
    }

    public String getEventName(ITimeEvent event) {
        if (event instanceof ResourcesEvent) {
            ResourcesEvent resourcesEvent = (ResourcesEvent)event;
            if (resourcesEvent.getType() == ResourcesEntry.Type.CPU) {
                int status = resourcesEvent.getValue();
                if (status == 0) {
                    return State.IDLE.toString();
                }
                if (status == 1) {
                    return State.USERMODE.toString();
                }
                if (status == 2) {
                    return State.SYSCALL.toString();
                }
                if (status == 3) {
                    return State.IRQ.toString();
                }
                if (status == 4) {
                    return State.SOFT_IRQ.toString();
                }
            } else {
                if (resourcesEvent.getType() == ResourcesEntry.Type.IRQ) {
                    return State.IRQ_ACTIVE.toString();
                }
                if (resourcesEvent.getType() == ResourcesEntry.Type.SOFT_IRQ) {
                    int cpu = resourcesEvent.getValue();
                    if (cpu == -2) {
                        return State.SOFT_IRQ_RAISED.toString();
                    }
                    return State.SOFT_IRQ_ACTIVE.toString();
                }
                return null;
            }
        }
        return Messages.ResourcesView_multipleStates;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (event instanceof ResourcesEvent) {
            int cpu;
            ResourcesEvent resourcesEvent = (ResourcesEvent)event;
            if ((resourcesEvent.getType().equals((Object)ResourcesEntry.Type.IRQ) || resourcesEvent.getType().equals((Object)ResourcesEntry.Type.SOFT_IRQ)) && (cpu = resourcesEvent.getValue()) >= 0) {
                retMap.put(Messages.ResourcesView_attributeCpuName, String.valueOf(cpu));
            }
            if (resourcesEvent.getType().equals((Object)ResourcesEntry.Type.CPU)) {
                int status = resourcesEvent.getValue();
                if (status == 3) {
                    ResourcesEntry entry = (ResourcesEntry)event.getEntry();
                    ITmfStateSystem ss = (ITmfStateSystem)entry.getTrace().getStateSystems().get("org.eclipse.linuxtools.lttng2.kernel");
                    int cpu2 = entry.getId();
                    try {
                        List fullState = ss.queryFullState(event.getTime());
                        List irqQuarks = ss.getQuarks(new String[]{"Resources", "IRQs", "*"});
                        Iterator iterator = irqQuarks.iterator();
                        while (iterator.hasNext()) {
                            int irqQuark = (Integer)iterator.next();
                            if (((ITmfStateInterval)fullState.get(irqQuark)).getStateValue().unboxInt() != cpu2) continue;
                            ITmfStateInterval value = ss.querySingleState(event.getTime(), irqQuark);
                            if (!value.getStateValue().isNull()) {
                                int irq = Integer.parseInt(ss.getAttributeName(irqQuark));
                                retMap.put(Messages.ResourcesView_attributeIrqName, String.valueOf(irq));
                            }
                            break;
                        }
                    }
                    catch (AttributeNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (TimeRangeException e) {
                        e.printStackTrace();
                    }
                    catch (StateValueTypeException e) {
                        e.printStackTrace();
                    }
                    catch (StateSystemDisposedException stateSystemDisposedException) {}
                } else if (status == 4) {
                    ResourcesEntry entry = (ResourcesEntry)event.getEntry();
                    ITmfStateSystem ss = (ITmfStateSystem)entry.getTrace().getStateSystems().get("org.eclipse.linuxtools.lttng2.kernel");
                    int cpu3 = entry.getId();
                    try {
                        List fullState = ss.queryFullState(event.getTime());
                        List softIrqQuarks = ss.getQuarks(new String[]{"Resources", "Soft_IRQs", "*"});
                        Iterator iterator = softIrqQuarks.iterator();
                        while (iterator.hasNext()) {
                            int softIrqQuark = (Integer)iterator.next();
                            if (((ITmfStateInterval)fullState.get(softIrqQuark)).getStateValue().unboxInt() != cpu3) continue;
                            ITmfStateInterval value = ss.querySingleState(event.getTime(), softIrqQuark);
                            if (!value.getStateValue().isNull()) {
                                int softIrq = Integer.parseInt(ss.getAttributeName(softIrqQuark));
                                retMap.put(Messages.ResourcesView_attributeSoftIrqName, String.valueOf(softIrq));
                            }
                            break;
                        }
                    }
                    catch (AttributeNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (TimeRangeException e) {
                        e.printStackTrace();
                    }
                    catch (StateValueTypeException e) {
                        e.printStackTrace();
                    }
                    catch (StateSystemDisposedException stateSystemDisposedException) {}
                } else if (status == 1 || status == 2) {
                    ResourcesEntry entry = (ResourcesEntry)event.getEntry();
                    ITmfStateSystem ssq = (ITmfStateSystem)entry.getTrace().getStateSystems().get("org.eclipse.linuxtools.lttng2.kernel");
                    try {
                        retMap.put(Messages.ResourcesView_attributeHoverTime, Utils.formatTime((long)hoverTime, (Utils.TimeFormat)Utils.TimeFormat.CALENDAR, (Utils.Resolution)Utils.Resolution.NANOSEC));
                        int cpuQuark = entry.getQuark();
                        int currentThreadQuark = ssq.getQuarkRelative(cpuQuark, new String[]{"Current_thread"});
                        ITmfStateInterval interval = ssq.querySingleState(hoverTime, currentThreadQuark);
                        if (!interval.getStateValue().isNull()) {
                            int syscallQuark;
                            ITmfStateValue value = interval.getStateValue();
                            int currentThreadId = value.unboxInt();
                            retMap.put(Messages.ResourcesView_attributeTidName, Integer.toString(currentThreadId));
                            int execNameQuark = ssq.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId), "Exec_name"});
                            interval = ssq.querySingleState(hoverTime, execNameQuark);
                            if (!interval.getStateValue().isNull()) {
                                value = interval.getStateValue();
                                retMap.put(Messages.ResourcesView_attributeProcessName, value.unboxStr());
                            }
                            if (status == 2 && !(interval = ssq.querySingleState(hoverTime, syscallQuark = ssq.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId), "System_call"}))).getStateValue().isNull()) {
                                value = interval.getStateValue();
                                retMap.put(Messages.ResourcesView_attributeSyscallName, value.unboxStr());
                            }
                        }
                    }
                    catch (AttributeNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (TimeRangeException e) {
                        e.printStackTrace();
                    }
                    catch (StateValueTypeException e) {
                        e.printStackTrace();
                    }
                    catch (StateSystemDisposedException stateSystemDisposedException) {}
                }
            }
        }
        return retMap;
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (bounds.width <= gc.getFontMetrics().getAverageCharWidth()) {
            return;
        }
        if (!(event instanceof ResourcesEvent)) {
            return;
        }
        ResourcesEvent resourcesEvent = (ResourcesEvent)event;
        if (!resourcesEvent.getType().equals((Object)ResourcesEntry.Type.CPU)) {
            return;
        }
        int status = resourcesEvent.getValue();
        if (status != 1 && status != 2) {
            return;
        }
        ResourcesEntry entry = (ResourcesEntry)event.getEntry();
        ITmfStateSystem ss = (ITmfStateSystem)entry.getTrace().getStateSystems().get("org.eclipse.linuxtools.lttng2.kernel");
        long time = event.getTime();
        try {
            while (time < event.getTime() + event.getDuration()) {
                int x;
                int cpuQuark = entry.getQuark();
                int currentThreadQuark = ss.getQuarkRelative(cpuQuark, new String[]{"Current_thread"});
                ITmfStateInterval tidInterval = ss.querySingleState(time, currentThreadQuark);
                if (!tidInterval.getStateValue().isNull()) {
                    int syscallQuark;
                    int width;
                    int x2;
                    long endTime;
                    long startTime;
                    ITmfStateInterval interval;
                    ITmfStateValue value = tidInterval.getStateValue();
                    int currentThreadId = value.unboxInt();
                    if (status == 1 && (long)currentThreadId != this.fLastThreadId) {
                        int execNameQuark = ss.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId), "Exec_name"});
                        interval = ss.querySingleState(time, execNameQuark);
                        if (!interval.getStateValue().isNull()) {
                            value = interval.getStateValue();
                            gc.setForeground(gc.getDevice().getSystemColor(1));
                            startTime = Math.max(tidInterval.getStartTime(), event.getTime());
                            endTime = Math.min(tidInterval.getEndTime() + 1L, event.getTime() + event.getDuration());
                            if (this.fTimeGraphViewer.getXForTime(endTime) > bounds.x) {
                                x2 = Math.max(this.fTimeGraphViewer.getXForTime(startTime), bounds.x);
                                width = Math.min(this.fTimeGraphViewer.getXForTime(endTime), bounds.x + bounds.width) - x2;
                                int drawn = Utils.drawText((GC)gc, (String)value.unboxStr(), (int)(x2 + 1), (int)(bounds.y - 2), (int)(width - 1), (boolean)true, (boolean)true);
                                if (drawn > 0) {
                                    this.fLastThreadId = currentThreadId;
                                }
                            }
                        }
                    } else if (status == 2 && !(interval = ss.querySingleState(time, syscallQuark = ss.getQuarkAbsolute(new String[]{"Threads", Integer.toString(currentThreadId), "System_call"}))).getStateValue().isNull()) {
                        value = interval.getStateValue();
                        gc.setForeground(gc.getDevice().getSystemColor(1));
                        startTime = Math.max(tidInterval.getStartTime(), event.getTime());
                        endTime = Math.min(tidInterval.getEndTime() + 1L, event.getTime() + event.getDuration());
                        if (this.fTimeGraphViewer.getXForTime(endTime) > bounds.x) {
                            x2 = Math.max(this.fTimeGraphViewer.getXForTime(startTime), bounds.x);
                            width = Math.min(this.fTimeGraphViewer.getXForTime(endTime), bounds.x + bounds.width) - x2;
                            Utils.drawText((GC)gc, (String)value.unboxStr().substring(4), (int)(x2 + 1), (int)(bounds.y - 2), (int)(width - 1), (boolean)true, (boolean)true);
                        }
                    }
                }
                if ((time = tidInterval.getEndTime() + 1L) >= event.getTime() + event.getDuration() || (x = this.fTimeGraphViewer.getXForTime(time)) < bounds.x) continue;
                gc.setForeground(gc.getDevice().getSystemColor(15));
                gc.drawLine(x, bounds.y + 1, x, bounds.y + bounds.height - 2);
            }
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (TimeRangeException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {}
    }

    public void postDrawEntry(ITimeGraphEntry entry, Rectangle bounds, GC gc) {
        this.fLastThreadId = -1L;
    }

    private static enum State {
        IDLE(new RGB(200, 200, 200)),
        USERMODE(new RGB(0, 200, 0)),
        SYSCALL(new RGB(0, 0, 200)),
        IRQ(new RGB(200, 0, 100)),
        SOFT_IRQ(new RGB(200, 150, 100)),
        IRQ_ACTIVE(new RGB(200, 0, 100)),
        SOFT_IRQ_RAISED(new RGB(200, 200, 0)),
        SOFT_IRQ_ACTIVE(new RGB(200, 150, 100));

        public final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

