/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.controlflow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.linuxtools.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.EventIterator;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class ControlFlowEntry
implements ITimeGraphEntry {
    private final int fThreadQuark;
    private final LttngKernelTrace fTrace;
    private ControlFlowEntry fParent = null;
    private final ArrayList<ControlFlowEntry> fChildren = new ArrayList();
    private String fName;
    private final int fThreadId;
    private final int fParentThreadId;
    private long fStartTime = -1L;
    private long fEndTime = -1L;
    private List<ITimeEvent> fEventList = new ArrayList<ITimeEvent>();
    private List<ITimeEvent> fZoomedEventList = null;

    public ControlFlowEntry(int threadQuark, LttngKernelTrace trace, String execName, int threadId, int parentThreadId, long startTime, long endTime) {
        this.fThreadQuark = threadQuark;
        this.fTrace = trace;
        this.fName = execName;
        this.fThreadId = threadId;
        this.fParentThreadId = parentThreadId;
        this.fStartTime = startTime;
        this.fEndTime = endTime;
    }

    public ITimeGraphEntry getParent() {
        return this.fParent;
    }

    public boolean hasChildren() {
        return this.fChildren.size() > 0;
    }

    public List<ControlFlowEntry> getChildren() {
        return this.fChildren;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String execName) {
        this.fName = execName;
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public long getEndTime() {
        return this.fEndTime;
    }

    public boolean hasTimeEvents() {
        return true;
    }

    public Iterator<ITimeEvent> getTimeEventsIterator() {
        return new EventIterator(this.fEventList, this.fZoomedEventList);
    }

    public Iterator<ITimeEvent> getTimeEventsIterator(long startTime, long stopTime, long visibleDuration) {
        return new EventIterator(this.fEventList, this.fZoomedEventList, startTime, stopTime);
    }

    public int getThreadQuark() {
        return this.fThreadQuark;
    }

    public LttngKernelTrace getTrace() {
        return this.fTrace;
    }

    public int getThreadId() {
        return this.fThreadId;
    }

    public int getParentThreadId() {
        return this.fParentThreadId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(ITimeEvent event) {
        long start = event.getTime();
        long end = start + event.getDuration();
        List<ITimeEvent> list = this.fEventList;
        synchronized (list) {
            this.fEventList.add(event);
            if (this.fStartTime == -1L || start < this.fStartTime) {
                this.fStartTime = start;
            }
            if (this.fEndTime == -1L || end > this.fEndTime) {
                this.fEndTime = end;
            }
        }
    }

    public void setEventList(List<ITimeEvent> eventList) {
        this.fEventList = eventList;
    }

    public void setZoomedEventList(List<ITimeEvent> eventList) {
        this.fZoomedEventList = eventList;
    }

    public void addChild(ControlFlowEntry child) {
        child.fParent = this;
        this.fChildren.add(child);
    }
}

