/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.filter;

import org.eclipse.linuxtools.internal.systemtap.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.graphingapi.core.filters.MatchFilter;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.filter.FilterWizardPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ColumnLayout;

public class MatchFilterWizardPage
extends FilterWizardPage {
    private Combo cboColumn;
    private Text txtCompare;
    private Button radKeepMatch;
    private Button radRemoveMatch;

    public MatchFilterWizardPage() {
        super("selectFilterOptions");
        this.setTitle(Localization.getString("MatchFilterWizardPage.CreateMatchFilter"));
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FormLayout());
        FormData data1 = new FormData();
        data1.left = new FormAttachment(0, 0);
        data1.top = new FormAttachment(0, 0);
        data1.right = new FormAttachment(40, 0);
        data1.bottom = new FormAttachment(100, 0);
        Composite cmpFilterOpts = new Composite(comp, 0);
        cmpFilterOpts.setLayoutData((Object)data1);
        ColumnLayout colLayout = new ColumnLayout();
        colLayout.maxNumColumns = 1;
        cmpFilterOpts.setLayout((Layout)colLayout);
        Label lblColumn = new Label(cmpFilterOpts, 0);
        lblColumn.setText(Localization.getString("MatchFilterWizardPage.Column"));
        this.cboColumn = new Combo(cmpFilterOpts, 4);
        this.cboColumn.addSelectionListener(this.selectionListener);
        int i = 0;
        while (i < this.wizard.series.length) {
            this.cboColumn.add(this.wizard.series[i]);
            ++i;
        }
        new Label(cmpFilterOpts, 0);
        Label lblCompare = new Label(cmpFilterOpts, 0);
        lblCompare.setText(Localization.getString("MatchFilterWizardPage.CompareTo"));
        this.txtCompare = new Text(cmpFilterOpts, 2048);
        this.txtCompare.addModifyListener(this.modifyListener);
        new Label(cmpFilterOpts, 0);
        this.radKeepMatch = new Button(cmpFilterOpts, 16);
        this.radKeepMatch.setText(Localization.getString("MatchFilterWizardPage.KeepMatching"));
        this.radKeepMatch.addSelectionListener(this.selectionListener);
        this.radKeepMatch.setSelection(true);
        this.radRemoveMatch = new Button(cmpFilterOpts, 16);
        this.radRemoveMatch.setText(Localization.getString("MatchFilterWizardPage.RemoveMatching"));
        this.radRemoveMatch.addSelectionListener(this.selectionListener);
        this.setControl((Control)comp);
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    protected void createFilter() {
        int style;
        int selected = this.cboColumn.getSelectionIndex();
        String compare = this.txtCompare.getText().trim();
        int n = style = this.radKeepMatch.getSelection() ? 0 : 1;
        if (selected >= 0 && selected < this.cboColumn.getItemCount() && compare.length() > 0) {
            this.wizard.filter = new MatchFilter(selected, (Object)compare, style);
        }
    }

    @Override
    public void dispose() {
        if (this.txtCompare != null) {
            this.txtCompare.removeModifyListener(this.modifyListener);
            this.txtCompare.dispose();
            this.txtCompare = null;
        }
        if (this.cboColumn != null) {
            this.cboColumn.removeSelectionListener(this.selectionListener);
            this.cboColumn.dispose();
            this.cboColumn = null;
        }
        if (this.radKeepMatch != null) {
            this.radKeepMatch.removeSelectionListener(this.selectionListener);
            this.radKeepMatch.dispose();
            this.radKeepMatch = null;
        }
        if (this.radRemoveMatch != null) {
            this.radRemoveMatch.removeSelectionListener(this.selectionListener);
            this.radRemoveMatch.dispose();
            this.radRemoveMatch = null;
        }
        super.dispose();
    }
}

