/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets;

import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.GraphCanvas;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.IGraphPrimitive;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class GraphLabel
implements IGraphPrimitive {
    private GraphCanvas canvas;
    private String title;
    private int width;
    private int height;
    private Point center;
    private Composite parent;
    private int x;
    private int y;
    private float size;
    private int style;
    private boolean staticSize;

    public GraphLabel(GraphCanvas canvas, String title, Point center, float size, int style) {
        this.canvas = canvas;
        this.title = title;
        this.center = center;
        this.size = size;
        this.style = style;
        this.parent = null;
    }

    public GraphLabel(GraphCanvas canvas, String title, Point center, int size, int style) {
        this(canvas, title, center, (float)size, style);
    }

    public GraphLabel(GraphCanvas canvas, String title, Composite parent, float size, int style) {
        this(canvas, title, parent.getSize(), size, style);
        this.parent = parent;
    }

    public GraphLabel(GraphCanvas canvas, String title, Composite parent, int size, int style) {
        this(canvas, title, parent, (float)size, style);
    }

    public int calculateSize(GC gc) {
        int width = 0;
        int i = 0;
        while (i < this.title.length()) {
            width += gc.getCharWidth(this.title.charAt(i));
            ++i;
        }
        return width;
    }

    @Override
    public void calculateBounds() {
        if (this.parent != null) {
            Point size = this.parent.getSize();
            this.x = size.x - this.width >> 1;
            this.y = this.parent.getBounds().y;
        } else {
            this.x = this.center.x - (this.width >> 1);
            this.y = this.center.y - (this.height >> 1);
        }
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isUnder(Point loc) {
        return loc.x >= this.x && loc.y >= this.y && loc.x <= this.x + this.width && loc.y <= this.y + this.height;
    }

    @Override
    public void paint(GC gc) {
        if (this.staticSize) {
            gc.setFont(new Font((Device)this.canvas.getDisplay(), "Times", (int)this.size, this.style));
        } else {
            gc.setFont(new Font((Device)this.canvas.getDisplay(), "Times", (int)((float)this.canvas.getSize().y * this.size), this.style));
        }
        this.width = this.calculateSize(gc);
        this.height = gc.getFontMetrics().getHeight();
        this.calculateBounds();
        Color temp = gc.getForeground();
        gc.setForeground(this.canvas.axisColor);
        gc.drawText(this.title, this.x, this.y);
        gc.setForeground(temp);
    }
}

