/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets;

import org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs.AGraph;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.GraphAxis;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class GraphAxis2
extends GraphAxis {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_TOP = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_BOTTOM = 3;
    public static final int HIDE_GRID_LINES = 4;
    public static final int HIDE_TITLE = 8;
    public static final int HIDE_TICKS = 16;
    public static final int UNNORMALIZED = 32;

    public GraphAxis2(AGraph graph, String title, int tickCount, int type, Color color) {
        super(graph, title, tickCount, type & 1);
        this.type = type;
        this.color = color;
    }

    @Override
    public void calculateBounds() {
        this.x1 = this.graph.getXPadding();
        this.y1 = this.graph.getYPadding();
        this.x2 = this.graph.getSize().x - this.graph.getXPadding();
        this.y2 = this.graph.getSize().y - this.graph.getYPadding();
        this.locationX = this.graph.getXPadding();
        this.locationY = this.graph.getSize().y - this.graph.getYPadding();
        this.tickAmount = 0.0;
        switch (this.type & 1) {
            case 0: {
                this.widthX = 0;
                this.widthY = this.graph.getSize().y - (this.graph.getYPadding() << 1);
                this.tickIncrament = (double)(this.graph.getLocalYMax() - this.graph.getLocalYMin()) / (double)this.tickCount;
                this.range = this.graph.getLocalYMax() - this.graph.getLocalYMin();
                this.localMin = this.graph.getLocalYMin();
                break;
            }
            case 1: {
                this.widthX = this.graph.getSize().x - (this.graph.getXPadding() << 1);
                this.widthY = 0;
                this.tickIncrament = (double)(this.graph.getLocalXMax() - this.graph.getLocalXMin()) / (double)this.tickCount;
                this.range = this.graph.getLocalXMax() - this.graph.getLocalXMin();
                this.localMin = this.graph.getLocalXMin();
            }
        }
        switch (this.type & 3) {
            case 3: {
                this.locationY = this.graph.getYPadding();
                this.y1 = this.graph.getSize().y - this.graph.getYPadding();
                this.y2a = this.graph.getSize().y - this.graph.getYPadding();
                this.x2a = (int)this.locationX;
                break;
            }
            case 1: {
                this.y2 = this.graph.getYPadding();
                this.y2a = this.graph.getYPadding();
                this.x2a = (int)this.locationX;
                break;
            }
            case 0: {
                this.x2 = this.graph.getXPadding();
                this.y2a = (int)this.locationY;
                this.x2a = this.graph.getSize().x - this.graph.getXPadding();
                break;
            }
            case 2: {
                this.locationX = this.graph.getSize().x - this.graph.getXPadding();
                this.x1 = this.graph.getSize().x - this.graph.getXPadding();
                this.y2a = (int)this.locationY;
                this.x2a = this.graph.getXPadding();
            }
        }
    }

    @Override
    protected void drawGridLine(GC gc, int x1, int y1, int x2, int y2) {
        if (4 != (4 & this.type)) {
            super.drawGridLine(gc, x1, y1, x2, y2);
        }
    }

    @Override
    protected void drawTick(GC gc, int x, int y, String val) {
        if (16 != (0x10 & this.type)) {
            super.drawTick(gc, x, y, val);
        }
    }

    @Override
    protected void drawTitle(GC gc) {
        if (8 != (8 & this.type)) {
            super.drawTitle(gc);
        }
    }
}

