/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs;

import org.eclipse.linuxtools.systemtap.graphingapi.core.IGraphColorConstants;
import org.eclipse.linuxtools.systemtap.graphingapi.core.adapters.BlockAdapter;
import org.eclipse.linuxtools.systemtap.graphingapi.core.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.NumberType;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs.AChart;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs.IBlockGraph;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.GraphComposite;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.GraphLegend;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class PieChart
extends AChart
implements IBlockGraph {
    public static final String ID = "org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs.piechart";
    private BlockAdapter adapter;
    private double sum;
    private static final int MAX_ANGLE = 360;

    public PieChart(GraphComposite parent, int style, String title, BlockAdapter adapt) {
        super(parent, style, title, (IAdapter)adapt);
        this.adapter = adapt;
        this.handleUpdateEvent();
    }

    private void updateLegend() {
        Object[][] l = this.adapter.getData();
        String[] labels = new String[this.adapter.getRecordCount()];
        Color[] colors = new Color[labels.length];
        int i = 0;
        while (i < labels.length) {
            labels[i] = l[i][0].toString();
            colors[i] = new Color((Device)this.getDisplay(), IGraphColorConstants.COLORS[i]);
            ++i;
        }
        this.legend = new GraphLegend(this, labels, colors);
    }

    @Override
    public void paintElementList(GC gc) {
        this.updateLegend();
        Color temp = gc.getForeground();
        Color temp1 = gc.getBackground();
        int pw = Math.min(super.getSize().x - (super.getXPadding() << 1), super.getSize().y - (super.getYPadding() << 1));
        int px = super.getSize().x - super.getXPadding() - pw >> 1;
        int py = super.getSize().y - super.getYPadding() - pw >> 1;
        int angle0 = 0;
        Number[] points = new Number[]{};
        points = this.elementList[0].toArray(points);
        int i = 0;
        while (i < points.length) {
            Color c = new Color((Device)this.getDisplay(), IGraphColorConstants.COLORS[i]);
            gc.setForeground(c);
            gc.setBackground(c);
            int angle1 = (int)(360.0 * (points[i].doubleValue() / this.sum) + 0.51);
            gc.fillArc(px, py, pw, pw, angle0, angle1);
            angle0 += angle1;
            ++i;
        }
        if (points.length == 0) {
            gc.drawArc(px, py, pw, pw, 0, 360);
            gc.drawLine(px, py, px + pw, py + pw);
            gc.drawLine(px, py + pw, px + pw, py);
        }
        gc.setForeground(temp);
        gc.setBackground(temp1);
    }

    @Override
    public boolean isMultiGraph() {
        return false;
    }

    @Override
    public void handleUpdateEvent() {
        if (this.adapter == null) {
            return;
        }
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                PieChart.this.elementList[0].clear();
                Object[][] data = PieChart.this.adapter.getData();
                PieChart.this.sum = 0.0;
                int i = 0;
                while (i < data.length) {
                    Number n = NumberType.obj2num((Object)data[i][1]);
                    PieChart.this.elementList[0].add(n);
                    PieChart pieChart = PieChart.this;
                    pieChart.sum = pieChart.sum + n.doubleValue();
                    ++i;
                }
            }
        });
        this.repaint();
    }
}

