/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs;

import org.eclipse.linuxtools.systemtap.graphingapi.core.IGraphColorConstants;
import org.eclipse.linuxtools.systemtap.graphingapi.core.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.graphingapi.core.adapters.ScrollAdapter;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.DataPoint;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.NumberType;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs.AGraph;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs.IScrollGraph;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.GraphComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class LineGraph
extends AGraph
implements IScrollGraph {
    private ScrollAdapter adapter;
    public static final String ID = "org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs.linegraph";

    public LineGraph(GraphComposite parent, int style, String title, ScrollAdapter adapter) {
        super(parent, style, title, (IAdapter)adapter);
        this.adapter = adapter;
        this.handleUpdateEvent();
    }

    @Override
    public void paintElementList(GC gc) {
        DataPoint[] points = new DataPoint[]{};
        Color temp = gc.getForeground();
        double xSize = super.getSize().x - (super.getXPadding() << 1);
        xSize /= (double)super.getLocalWidth();
        double ySize = super.getSize().y - (super.getYPadding() << 1);
        ySize /= (double)super.getLocalHeight();
        int j = 0;
        while (j < this.elementList.length) {
            points = this.elementList[j].toArray(points);
            Color c = new Color((Device)this.getDisplay(), IGraphColorConstants.COLORS[j]);
            gc.setForeground(c);
            double px2 = 0.0;
            double py2 = super.getSize().y - super.getYPadding();
            DataPoint[] dataPointArray = points;
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                DataPoint point = dataPointArray[n2];
                double px = point.x - (double)super.getLocalXMin();
                px *= xSize;
                double py = (double)super.getLocalYMax() - point.y;
                py *= ySize;
                gc.drawLine((int)(px += (double)super.getXPadding()), (int)(py += (double)super.getYPadding()), (int)px2, (int)py2);
                px2 = px;
                py2 = py;
                ++n2;
            }
            ++j;
        }
        gc.setForeground(temp);
    }

    @Override
    public boolean isMultiGraph() {
        return this.adapter.getSeriesCount() > 0;
    }

    @Override
    public void handleUpdateEvent() {
        if (this.adapter == null) {
            return;
        }
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Object[][] data = LineGraph.this.adapter.getData(LineGraph.this.removedItems, LineGraph.this.adapter.getRecordCount());
                if (LineGraph.this.normalize) {
                    int i = 0;
                    while (i < LineGraph.this.adapter.getSeriesCount()) {
                        LineGraph.this.elementList[i].clear();
                        double max = LineGraph.this.adapter.getYSeriesMax(i, LineGraph.this.removedItems, LineGraph.this.adapter.getRecordCount()).doubleValue() / 100.0;
                        int j = 0;
                        while (j < data.length) {
                            LineGraph.this.elementList[i].add(new DataPoint(NumberType.obj2num((Object)data[j][0]).doubleValue(), NumberType.obj2num((Object)data[j][i + 1]).doubleValue() / max));
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < LineGraph.this.adapter.getSeriesCount()) {
                        LineGraph.this.elementList[i].clear();
                        int j = 0;
                        while (j < data.length) {
                            LineGraph.this.elementList[i].add(new DataPoint(NumberType.obj2num((Object)data[j][0]).doubleValue(), NumberType.obj2num((Object)data[j][i + 1]).doubleValue()));
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        });
        this.repaint();
    }
}

