/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs;

import java.util.LinkedList;
import org.eclipse.linuxtools.internal.systemtap.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.graphingapi.core.IGraphColorConstants;
import org.eclipse.linuxtools.systemtap.graphingapi.core.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs.IGraph;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.GraphCanvas;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.GraphComposite;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.GraphLabel;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.GraphLegend;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public abstract class AChart
extends GraphCanvas
implements IGraph {
    private final PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            AChart.this.paintAll(e.gc);
        }
    };
    private SelectionListener titleListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            AChart.this.showTitle = ((Button)e.getSource()).getSelection();
            AChart.this.repaint();
        }
    };
    private SelectionListener legendListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            AChart.this.showLegend = ((Button)e.getSource()).getSelection();
            AChart.this.repaint();
        }
    };
    protected GraphComposite parent;
    protected GraphLegend legend;
    protected GraphLabel title;
    protected LinkedList<Object>[] elementList;
    public boolean showTitle;
    public boolean showLegend;
    private IAdapter adapter;

    public AChart(GraphComposite parent, int style, String title, IAdapter adapt) {
        super(parent, style);
        this.adapter = adapt;
        this.elementList = new LinkedList[adapt.getSeriesCount()];
        int i = 0;
        while (i < this.elementList.length) {
            this.elementList[i] = new LinkedList();
            ++i;
        }
        this.createLegend();
        this.createTitle(title);
        this.addPaintListener(this.paintListener);
        parent.addCheckOption(Localization.getString("AChart.Title"), this.titleListener);
        parent.addCheckOption(Localization.getString("AChart.Legend"), this.legendListener);
    }

    protected void createTitle(String title) {
        this.title = new GraphLabel((GraphCanvas)this, title, (Composite)this, 0.1f, 1);
    }

    protected void createLegend() {
        String[] labels = this.adapter.getLabels();
        String[] labels2 = new String[labels.length - 1];
        Color[] colors = new Color[labels2.length];
        int i = 0;
        while (i < labels2.length) {
            labels2[i] = labels[i + 1];
            colors[i] = new Color((Device)this.getDisplay(), IGraphColorConstants.COLORS[i]);
            ++i;
        }
        this.legend = new GraphLegend(this, labels2, colors);
    }

    protected void paintAll(GC gc) {
        this.paintElementList(gc);
        if (this.showLegend && this.legend != null) {
            this.legend.paint(gc);
        }
        if (this.showTitle && this.title != null) {
            this.title.paint(gc);
        }
    }

    public void dispose() {
        this.removePaintListener(this.paintListener);
        this.parent.removeCheckOption(Localization.getString("AChart.Title"));
        this.parent.removeCheckOption(Localization.getString("AChart.Legend"));
        this.legendListener = null;
        this.titleListener = null;
        super.dispose();
    }

    public abstract boolean isMultiGraph();

    public abstract void handleUpdateEvent();

    public abstract void paintElementList(GC var1);
}

